/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.web.controller;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.web.controller.AbstractWebController;
import ca.infodata.ofys.client.web.core.ActionResult;
import ca.infodata.ofys.client.web.core.IServerRequest;
import ca.infodata.ofys.client.web.core.ServerResponses;
import ca.infodata.ofys.client.web.core.routes.RouterFunction;
import ca.infodata.ofys.client.web.core.routes.RouterFunctions;
import ca.infodata.ofys.data.dataaccess.client.TemplateAccessorClient;
import ca.infodata.ofys.data.middle.dataobjects.template.XTemplate;
import ca.infodata.ofys.ui.dashboard.models.CTemplate;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TemplateAssistController
extends AbstractWebController {
    private static final Logger logger = Logger.getLogger(TemplateAssistController.class.getName());
    private final TemplateAccessorClient templateAccessorClient = new TemplateAccessorClient();
    private static final Integer TEMPLATE_SEARCH_LIMIT = 50;

    @Override
    public RouterFunction<?> getRoutes() {
        return RouterFunctions.routes("/dashboard/template/ws", RouterFunctions.routeAction("/getAssistText", this::handleGetAssistText), RouterFunctions.routeAction("/quicksave", this::handleQuickSave), RouterFunctions.routeAction("/openTemplateEditor", this::handleOpenTemplateEditor), RouterFunctions.routeAction("/assistantSelectedCount", this::handleAssistantSelectedCount), RouterFunctions.routeAction("/getMostUsedUser", this::handleMostUsedUser), RouterFunctions.routeAction("/getMostUsedClient", this::handleMostUsedClient), RouterFunctions.routeAction("/getMostUsedGlobal", this::handleMostUsedGlobal), RouterFunctions.routeAction("/getMostUsedClientAndGlobal", this::handleMostUsesClientAndGlobal), RouterFunctions.routeAction("/getAll", this::handleGetAll), RouterFunctions.routeAction("/find", this::handleFind), RouterFunctions.routeAction("/save", this::handleSave));
    }

    private ActionResult handleAssistantSelectedCount(IServerRequest req) {
        Integer idTemplate = req.getRequiredQueryParam("idTemplate", Integer.class);
        this.templateAccessorClient.use(idTemplate);
        return ServerResponses.SUCCESS();
    }

    private ActionResult handleOpenTemplateEditor(IServerRequest req) {
        Integer type = req.getRequiredQueryParam("type", Integer.class);
        Application.get().getApplicationUiPlugin().openTemplateEditor(type);
        return ServerResponses.SUCCESS();
    }

    private ActionResult handleQuickSave(IServerRequest req) {
        String name = req.getQueryParam("name");
        String txt = req.getQueryParam("txt");
        Integer idType = req.getQueryParam("idType", Integer.class);
        if (name != null && txt != null && idType != null) {
            XTemplate n = new XTemplate();
            n.setId(null);
            n.setName(name);
            n.setText(txt);
            n.setType(idType);
            try {
                this.templateAccessorClient.save(n);
                return ServerResponses.SUCCESS();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to quick save template", e);
            }
        }
        return ServerResponses.ERROR("Failed to save template");
    }

    private ActionResult handleGetAssistText(IServerRequest req) {
        String txt = StringUtils.removeAccents((String)StringUtils.toLowerCase((String)req.getQueryParam("txt")));
        Integer idType = req.getQueryParam("idType", Integer.class);
        List<CTemplate> list = CTemplate.templateToC(this.templateAccessorClient.findOneListGrouping(idType, txt));
        if (list == null) {
            list = new ArrayList<CTemplate>();
        }
        return ServerResponses.toJsonActionResult(list);
    }

    private ActionResult handleMostUsesClientAndGlobal(IServerRequest req) {
        String txt = req.getQueryParam("txt");
        if (txt != null) {
            txt = StringUtils.removeAccents((String)StringUtils.toLowerCase((String)txt));
        }
        Integer idType = req.getQueryParam("idType", Integer.class);
        Integer offset = req.getQueryParam("offset", Integer.class);
        ArrayList listToReturn = new ArrayList();
        List<CTemplate> list = CTemplate.templateToC(this.templateAccessorClient.findMostUsedClient(idType, txt, TEMPLATE_SEARCH_LIMIT, offset));
        Optional.ofNullable(list).ifPresent(listToReturn::addAll);
        list = CTemplate.templateToC(this.templateAccessorClient.findMostUsedGlobal(idType, txt, TEMPLATE_SEARCH_LIMIT, offset));
        Optional.ofNullable(list).ifPresent(listToReturn::addAll);
        return ServerResponses.toJsonActionResult(listToReturn);
    }

    private ActionResult handleMostUsedUser(IServerRequest req) {
        Integer offset;
        Integer idType;
        List<CTemplate> list;
        String txt = req.getQueryParam("txt");
        if (txt != null) {
            txt = StringUtils.removeAccents((String)StringUtils.toLowerCase((String)txt));
        }
        if ((list = CTemplate.templateToC(this.templateAccessorClient.findMostUsed(idType = req.getQueryParam("idType", Integer.class), txt, TEMPLATE_SEARCH_LIMIT, offset = req.getQueryParam("offset", Integer.class)))) == null) {
            list = new ArrayList<CTemplate>();
        }
        return ServerResponses.toJsonActionResult(list);
    }

    private ActionResult handleMostUsedClient(IServerRequest req) {
        Integer offset;
        Integer idType;
        List<CTemplate> list;
        String txt = req.getQueryParam("txt");
        if (txt != null) {
            txt = StringUtils.removeAccents((String)StringUtils.toLowerCase((String)txt));
        }
        if ((list = CTemplate.templateToC(this.templateAccessorClient.findMostUsedClient(idType = req.getQueryParam("idType", Integer.class), txt, TEMPLATE_SEARCH_LIMIT, offset = req.getQueryParam("offset", Integer.class)))) == null) {
            list = new ArrayList<CTemplate>();
        }
        return ServerResponses.toJsonActionResult(list);
    }

    private ActionResult handleMostUsedGlobal(IServerRequest req) {
        Integer offset;
        Integer idType;
        List<CTemplate> list;
        String txt = req.getQueryParam("txt");
        if (txt != null) {
            txt = StringUtils.removeAccents((String)StringUtils.toLowerCase((String)txt));
        }
        if ((list = CTemplate.templateToC(this.templateAccessorClient.findMostUsedGlobal(idType = req.getQueryParam("idType", Integer.class), txt, TEMPLATE_SEARCH_LIMIT, offset = req.getQueryParam("offset", Integer.class)))) == null) {
            list = new ArrayList<CTemplate>();
        }
        return ServerResponses.toJsonActionResult(list);
    }

    private ActionResult handleGetAll(IServerRequest req) {
        Integer idType = req.getQueryParam("type", Integer.class);
        List<CTemplate> list = CTemplate.templateToC(this.templateAccessorClient.getAll(idType));
        if (list == null) {
            list = new ArrayList<CTemplate>();
        }
        return ServerResponses.toJsonActionResult(list);
    }

    private ActionResult handleFind(IServerRequest req) {
        Integer idType = req.getQueryParam("type", Integer.class);
        String txt = req.getQueryParam("txt", String.class);
        try {
            List<CTemplate> list = CTemplate.templateToC(this.templateAccessorClient.find(idType, txt));
            return ServerResponses.toJsonActionResult(list);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to quick save template", e);
            return ServerResponses.ERROR("Failed to save template");
        }
    }

    private ActionResult handleSave(IServerRequest req) {
        CTemplate template = req.getPostBody(CTemplate.class);
        try {
            XTemplate x = this.templateAccessorClient.save(template.toX());
            return ServerResponses.toJsonActionResult(new CTemplate(x));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to quick save template", e);
            return ServerResponses.ERROR("Failed to save template");
        }
    }
}

