/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.web.controller;

import ca.infodata.ofys.client.web.controller.AbstractWebController;
import ca.infodata.ofys.client.web.core.ActionResult;
import ca.infodata.ofys.client.web.core.IServerRequest;
import ca.infodata.ofys.client.web.core.ServerResponses;
import ca.infodata.ofys.client.web.core.routes.RouterFunction;
import ca.infodata.ofys.client.web.core.routes.RouterFunctions;
import ca.infodata.ofys.data.middle.dataobjects.XIaTaskToDoType;
import ca.infodata.ofys.ui.dashboard.accessor.IaSyncAccessorClient;
import ca.infodata.ofys.ui.dashboard.models.IaData;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IaController
extends AbstractWebController {
    private static final Logger logger = Logger.getLogger(IaController.class.getName());
    private IaSyncAccessorClient iaAccessor = new IaSyncAccessorClient();

    @Override
    public RouterFunction<?> getRoutes() {
        return RouterFunctions.routes("/dashboard/ia/ws", RouterFunctions.routeAction("/consentPatient", req -> this.consentPatient(req)), RouterFunctions.routeAction("/sendChunk", req -> this.sendChunk(req)), RouterFunctions.routeAction("/dictation", req -> this.dictation(req)), RouterFunctions.routeAction("/improveDictation", req -> this.improveDictation(req)), RouterFunctions.routeAction("/interviewDictation", req -> this.interviewDictation(req)), RouterFunctions.routeAction("/medNoteFromInterview", req -> this.medNoteFromInterview(req)), RouterFunctions.routeAction("/summaryEnc4Prof", req -> this.summaryEnc4Prof(req)), RouterFunctions.routeAction("/summaryEnc4Pat", req -> this.summaryEnc4Pat(req)), RouterFunctions.routeAction("/encInfoClin4Form", req -> this.encInfoClin4Form(req)), RouterFunctions.routeAction("/generatePatientSummary", req -> this.generatePatientSummary(req)), RouterFunctions.routeAction("/improveText", req -> ServerResponses.toJsonActionResult(this.improveText(req))), RouterFunctions.routeAction("/medNoteFromNote", req -> this.medNoteFromNote(req)), RouterFunctions.routeAction("/noteInfoClin4Form", req -> this.noteInfoClin4Form(req)), RouterFunctions.routeAction("/summaryFile4Prof", req -> this.summaryFile4Prof(req)), RouterFunctions.routeAction("/getLastEnc3y", req -> this.getLastEnc3y(req)), RouterFunctions.routeAction("/lastEnc3y", req -> this.lastEnc3y(req)), RouterFunctions.routeAction("/summaryOfDoc4Prof", req -> this.summaryOfDoc4Prof(req)), RouterFunctions.routeAction("/summaryOfDoc4Pat", req -> this.summaryOfDoc4Pat(req)), RouterFunctions.routeAction("/summaryOfLab4Prof", req -> this.summaryOfLab4Prof(req)), RouterFunctions.routeAction("/summaryOfLab4Pat", req -> this.summaryOfLab4Pat(req)), RouterFunctions.routeAction("/toFrench", req -> this.toFrench(req)), RouterFunctions.routeAction("/toEnglish", req -> this.toEnglish(req)));
    }

    private ActionResult sendChunk(IServerRequest req) {
        try {
            byte[] audioData = req.getPart("audio");
            Integer idAudio = req.getQueryParam("idAudio", Integer.class);
            Integer chunkNo = req.getQueryParam("chunkNo", Integer.class);
            Boolean isFinalChunk = req.getQueryParam("isFinalChunk", Boolean.class);
            Integer id = this.iaAccessor.sendChunk(audioData, idAudio, chunkNo, isFinalChunk);
            return ServerResponses.toJsonActionResult(id);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error processing audio data", e);
            return ServerResponses.ERROR(e.getMessage());
        }
    }

    private ActionResult consentPatient(IServerRequest req) {
        try {
            Text data = req.getPostBody(Text.class);
            Integer idPatient = req.getQueryParam("id", Integer.class);
            String sexPat = req.getQueryParam("sexPat", String.class);
            String text = this.iaAccessor.consentPatient(data, idPatient == null ? null : idPatient, sexPat);
            return ServerResponses.toJsonActionResult(text);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error processing audio data", e);
            return ServerResponses.ERROR(e.getMessage());
        }
    }

    private ActionResult dictation(IServerRequest req) {
        try {
            Text data = req.getPostBody(Text.class);
            String text = this.iaAccessor.dictation(data);
            return ServerResponses.toJsonActionResult(text);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error processing audio data", e);
            return ServerResponses.ERROR(e.getMessage());
        }
    }

    private ActionResult improveDictation(IServerRequest req) {
        try {
            Text data = req.getPostBody(Text.class);
            String text = this.iaAccessor.improveDictation(data);
            return ServerResponses.toJsonActionResult(text);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error processing audio data", e);
            return ServerResponses.ERROR(e.getMessage());
        }
    }

    private ActionResult interviewDictation(IServerRequest req) {
        try {
            Text data = req.getPostBody(Text.class);
            Integer noteType = req.getQueryParam("noteType", Integer.class);
            String sexPat = req.getQueryParam("sexPat", String.class);
            IaData iad = new IaData();
            iad.setTaskToDo(noteType);
            iad.setSexPat(sexPat);
            iad.setIdAudio(data.idAudio);
            String text = this.iaAccessor.interviewDictation(iad);
            return ServerResponses.toJsonActionResult(text);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error processing audio data", e);
            return ServerResponses.ERROR(e.getMessage());
        }
    }

    private ActionResult medNoteFromInterview(IServerRequest req) {
        try {
            Text data = req.getPostBody(Text.class);
            Integer noteType = req.getQueryParam("noteType", Integer.class);
            String sexPat = req.getQueryParam("sexPat", String.class);
            IaData iad = new IaData();
            iad.setSexPat(sexPat);
            iad.setIdAudio(data.idAudio);
            iad.setText(data.text);
            iad.setTaskToDo(XIaTaskToDoType.from((Integer)noteType).getValue());
            String text = this.iaAccessor.medNoteFromInterview(iad);
            return ServerResponses.toJsonActionResult(text);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error processing request", e);
            return ServerResponses.ERROR(e.getMessage());
        }
    }

    private ActionResult generatePatientSummary(IServerRequest req) {
        try {
            Text data = req.getPostBody(Text.class);
            String text = this.iaAccessor.generatePatientSummary(data);
            return ServerResponses.toJsonActionResult(text);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error processing request", e);
            return ServerResponses.ERROR(e.getMessage());
        }
    }

    private ActionResult medNoteFromNote(IServerRequest req) {
        try {
            Text data = req.getPostBody(Text.class);
            XIaTaskToDoType toDo = XIaTaskToDoType.from((Integer)data.noteType);
            String text = this.iaAccessor.medNoteFromNote(data, toDo);
            return ServerResponses.toJsonActionResult(text);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error processing audio data", e);
            return ServerResponses.ERROR(e.getMessage());
        }
    }

    private ActionResult noteInfoClin4Form(IServerRequest req) {
        try {
            Text data = req.getPostBody(Text.class);
            String text = this.iaAccessor.medNoteFromNote(data, XIaTaskToDoType.noteInfoClin4Form);
            return ServerResponses.toJsonActionResult(text);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error processing request", e);
            return ServerResponses.ERROR(e.getMessage());
        }
    }

    private ActionResult summaryFile4Prof(IServerRequest req) {
        try {
            IdData data = req.getPostBody(IdData.class);
            String text = this.iaAccessor.resumeFile(data);
            return ServerResponses.toJsonActionResult(text);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error processing request", e);
            return ServerResponses.ERROR(e.getMessage());
        }
    }

    private ActionResult getLastEnc3y(IServerRequest req) {
        try {
            IdEnc data = req.getPostBody(IdEnc.class);
            String text = this.iaAccessor.getLastEnc3y(data);
            return ServerResponses.toJsonActionResult(text);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error processing request", e);
            return ServerResponses.ERROR(e.getMessage());
        }
    }

    private ActionResult lastEnc3y(IServerRequest req) {
        try {
            IdEnc data = req.getPostBody(IdEnc.class);
            String text = this.iaAccessor.lastEnc3y(data);
            return ServerResponses.toJsonActionResult(text);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error processing request", e);
            return ServerResponses.ERROR(e.getMessage());
        }
    }

    private ActionResult summaryOfDoc4Prof(IServerRequest req) {
        try {
            IdDoc data = req.getPostBody(IdDoc.class);
            String text = this.iaAccessor.summaryOfDoc4Prof(data);
            return ServerResponses.toJsonActionResult(text);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error processing request", e);
            return ServerResponses.ERROR(e.getMessage());
        }
    }

    private ActionResult summaryOfDoc4Pat(IServerRequest req) {
        try {
            IdDoc data = req.getPostBody(IdDoc.class);
            String text = this.iaAccessor.summaryOfDoc4Pat(data);
            return ServerResponses.toJsonActionResult(text);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error processing request", e);
            return ServerResponses.ERROR(e.getMessage());
        }
    }

    private ActionResult summaryOfLab4Prof(IServerRequest req) {
        try {
            IdDoc data = req.getPostBody(IdDoc.class);
            String text = this.iaAccessor.summaryOfLab4Prof(data);
            return ServerResponses.toJsonActionResult(text);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error processing request", e);
            return ServerResponses.ERROR(e.getMessage());
        }
    }

    private ActionResult summaryOfLab4Pat(IServerRequest req) {
        try {
            IdDoc data = req.getPostBody(IdDoc.class);
            String text = this.iaAccessor.summaryOfLab4Pat(data);
            return ServerResponses.toJsonActionResult(text);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error processing request", e);
            return ServerResponses.ERROR(e.getMessage());
        }
    }

    private ActionResult summaryEnc4Pat(IServerRequest req) {
        try {
            IdEnc data = req.getPostBody(IdEnc.class);
            String text = this.iaAccessor.summaryEnc4Pat(data.idPatient, data.idLink, data.lang, data.sexPat);
            return ServerResponses.toJsonActionResult(text);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error processing request", e);
            return ServerResponses.ERROR(e.getMessage());
        }
    }

    private ActionResult encInfoClin4Form(IServerRequest req) {
        try {
            IdEnc data = req.getPostBody(IdEnc.class);
            String text = this.iaAccessor.encInfoClin4Form(data.idPatient, data.idLink, data.lang, data.sexPat);
            return ServerResponses.toJsonActionResult(text);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error processing request", e);
            return ServerResponses.ERROR(e.getMessage());
        }
    }

    private ActionResult summaryEnc4Prof(IServerRequest req) {
        try {
            IdEnc data = req.getPostBody(IdEnc.class);
            String text = this.iaAccessor.summaryEnc4Prof(data.idPatient, data.idLink, data.lang, data.sexPat);
            return ServerResponses.toJsonActionResult(text);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error processing request", e);
            return ServerResponses.ERROR(e.getMessage());
        }
    }

    private ActionResult toFrench(IServerRequest req) {
        try {
            Text data = req.getPostBody(Text.class);
            String text = this.iaAccessor.toFrench(data.text);
            return ServerResponses.toJsonActionResult(text);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error processing request", e);
            return ServerResponses.ERROR(e.getMessage());
        }
    }

    private ActionResult toEnglish(IServerRequest req) {
        try {
            Text data = req.getPostBody(Text.class);
            String text = this.iaAccessor.toEnglish(data.text);
            return ServerResponses.toJsonActionResult(text);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error processing request", e);
            return ServerResponses.ERROR(e.getMessage());
        }
    }

    private ActionResult improveText(IServerRequest req) {
        try {
            Text data = req.getPostBody(Text.class);
            String text = this.iaAccessor.improveText(data);
            return ServerResponses.toJsonActionResult(text);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error processing request", e);
            return ServerResponses.ERROR(e.getMessage());
        }
    }

    public static class IdDoc {
        public Integer idPatient;
        public Integer idLink;
        public String lang;
        public String sexPat;
    }

    public static class IdEnc {
        public Integer idPatient;
        public Integer idLink;
        public String lang;
        public String sexPat;
    }

    public static class IdData {
        public String id;
        public String lang;
        public String sexPat;
    }

    public static class Text {
        public Integer idAudio;
        public String text;
        public Integer noteType;
        public String lang;
        public String sexPat;
    }
}

