/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.web.controller;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.IPrintController;
import ca.infodata.ofys.client.web.controller.AbstractWebController;
import ca.infodata.ofys.client.web.core.ActionResult;
import ca.infodata.ofys.client.web.core.IServerRequest;
import ca.infodata.ofys.client.web.core.IWebResource;
import ca.infodata.ofys.client.web.core.IWebResourcesDelegate;
import ca.infodata.ofys.client.web.core.IWebSocketChannel;
import ca.infodata.ofys.client.web.core.ServerResponses;
import ca.infodata.ofys.client.web.core.WebApplication;
import ca.infodata.ofys.client.web.core.WebSocketFilterByRequest;
import ca.infodata.ofys.client.web.core.routes.RouterFunction;
import ca.infodata.ofys.client.web.core.routes.RouterFunctions;
import ca.infodata.ofys.data.middle.dataobjects.LightweightReport;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.XUser;
import ca.infodata.ofys.data.middle.dataobjects.communication.XFaxSend;
import ca.infodata.ofys.data.middle.dataobjects.communication.XFaxSendContainer;
import ca.infodata.ofys.data.middle.dataobjects.communication.XFaxSendNumberContainer;
import ca.infodata.ofys.data.middle.dataobjects.communication.XFaxStatus;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IReport;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObjectUpdatedNotification;
import ca.infodata.ofys.data.middle.dataobjects.pdf.PdfUtil;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.data.middle.dataobjects.properties.report.PrintMode;
import ca.infodata.ofys.ui.dashboard.accessor.FaxSyncAccessorClient;
import ca.infodata.ofys.ui.dashboard.accessor.PatientSyncAccessorClient;
import ca.infodata.ofys.ui.dashboard.models.CFaxSend;
import ca.infodata.ofys.ui.dashboard.models.CQueryFaxSend;
import ca.infodata.ofys.ui.dashboard.models.IdsProf;
import ca.infodata.ofys.ui.dashboard.models.Utils;
import ca.infodata.util1.date.LocalDate;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;

public class FaxController
extends AbstractWebController {
    private static final Logger logger = Logger.getLogger(FaxController.class.getName());
    private FaxSyncAccessorClient faxAccessor = new FaxSyncAccessorClient();
    private PatientSyncAccessorClient patientAccessor = new PatientSyncAccessorClient();

    public FaxController() {
        this.getNotificationSystemConsumer().setHandleMethod(this::handleNotification);
    }

    private void handleNotification(DataObjectUpdatedNotification notification) throws Exception {
        IDataObject object = notification.getObject();
        if (object instanceof XFaxSend) {
            XFaxSend ximage = (XFaxSend)object;
            String docId = ximage.getId().toString();
            CFaxSend cimage = this.getCFaxSend(docId, new CFaxSend(ximage));
            ServerResponses.sendJsonToClient(notification.getClientId(), "fax.send.update", (Object)cimage);
        }
    }

    public XBaseProfessionnal getProfById(int idProf) {
        return Application.get().getPersonPluginController().getBaseProfessionnal(idProf);
    }

    public XPatient getPatient(int id) {
        try {
            return this.patientAccessor.getPatient(id);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error while retreiving patient", e);
            return null;
        }
    }

    public XFaxSendContainer faxStatusQuery(XFaxStatus status) {
        return this.faxQuery(-2, -1, status);
    }

    public XFaxSendContainer faxSearchQuery(String q) {
        return this.faxQuery(-2, -1, null);
    }

    public XFaxSendContainer faxSearchQuery(CQueryFaxSend q) {
        return this.faxQuery(q.idProf, q.idPatient, q.status);
    }

    public XFaxSendContainer faxQuery(Integer idProf, Integer idPatient, XFaxStatus status) {
        XFaxSendContainer query = new XFaxSendContainer(Application.get().getPreferencesPluginController().getNB_RESULT_BY_PAGE());
        if (idProf != null) {
            if (idProf == -1) {
                query.setProfessionnal(null);
            } else if (idProf > 0) {
                query.setProfessionnal(this.getProfById(idProf));
            } else {
                query.setProfessionnal(Application.get().getPersonPluginController().getSessionProfessionnal());
            }
        }
        if (idPatient != null && idPatient > 0) {
            query.setPatient((IPatient)this.getPatient(idPatient));
        }
        query.setDocumentDateRange(null);
        query.setOffsetPage(Integer.valueOf(0));
        query.setStatus(status);
        return query;
    }

    private ReturnObject save(CFaxSend fax) {
        ReturnObject answer = this.faxAccessor.save(fax.x());
        XFaxSend savedX = (XFaxSend)answer.getObj();
        if (savedX != null) {
            CFaxSend savedCimage = new CFaxSend(savedX);
            answer.setObj((Object)savedCimage);
        }
        return answer;
    }

    private List<CFaxSend> getFax(XFaxSendContainer docsList, String[] query) {
        ArrayList<CFaxSend> res = new ArrayList<CFaxSend>();
        if (docsList == null) {
            return res;
        }
        boolean search = query != null;
        for (XFaxSend doc : docsList.getFaxes()) {
            boolean match = false;
            if (search) {
                for (int i = 0; !match && i < query.length; ++i) {
                    match = doc.fullToString().toLowerCase().contains(query[i].toLowerCase());
                }
            } else {
                match = true;
            }
            if (!match) continue;
            res.add(new CFaxSend(doc));
        }
        return res;
    }

    private List<CFaxSend> getFax(List<XFaxSend> lstIm, boolean withPatient) {
        ArrayList<CFaxSend> res = new ArrayList<CFaxSend>();
        if (lstIm == null) {
            return res;
        }
        HashMap mapUsers = new HashMap();
        for (XFaxSend doc : lstIm) {
            CFaxSend cFaxSend = new CFaxSend(doc);
            cFaxSend.user = (String)mapUsers.get(doc.getIdUser());
            if (cFaxSend.user == null) {
                cFaxSend.user = Application.get().getPersonPluginController().getUserName(doc.getIdUser());
            }
            res.add(cFaxSend);
        }
        return res;
    }

    public CFaxSend getDocument(CFaxSend fax) throws Exception {
        IWebResourcesDelegate resourcesDelegate = WebApplication.get().getWebResourcesDelegate();
        String docId = null;
        if (fax.faxId != null) {
            docId = "faxId" + fax.faxId;
        } else if (fax.id != null) {
            docId = "id" + fax.id;
        }
        String resourceName = this.getCFaxSendResourceName(docId);
        boolean hasResourceLocally = resourcesDelegate.hasHtmlPdfViewerResource(resourceName);
        if (!hasResourceLocally) {
            if (fax.faxId != null) {
                fax.document = this.faxAccessor.getFaxDocumentByFaxId(fax.faxId);
            } else if (fax.id != null) {
                fax.document = this.faxAccessor.getFaxDocumentById(fax.id);
            }
        }
        fax = this.getCFaxSend(docId, fax);
        return fax;
    }

    public CFaxSend getCFaxSend(String docId, CFaxSend fax) throws Exception {
        if (docId == null) {
            throw new IllegalArgumentException("docId cant be null");
        }
        IWebResourcesDelegate webResourcesDelegate = WebApplication.get().getWebResourcesDelegate();
        String resourceName = this.getCFaxSendResourceName(docId);
        if (fax.document != null && fax.document.length() > 3) {
            String url;
            fax.picture = Base64.decodeBase64((String)fax.document);
            boolean recentViewer = (Boolean)Application.get().getPreferencesPluginController().getUserProp("user_settings_UseNewPDFViewer");
            IWebResource pdfViewerResource = webResourcesDelegate.getOrCreateHtmlPdfViewerResource(resourceName, fax.picture, true, recentViewer);
            fax.viewerUrl = url = pdfViewerResource.getUrl();
            fax.picture = null;
        } else {
            IWebResource pdfViewerResource = webResourcesDelegate.getHtmlPdfViewerResource(resourceName);
            if (pdfViewerResource != null) {
                fax.viewerUrl = pdfViewerResource.getUrl();
                fax.picture = null;
            }
        }
        return fax;
    }

    private String getCFaxSendResourceName(String docId) {
        return "CFaxSend_" + docId;
    }

    public byte[] addPrintByText(byte[] document, boolean isPdf) {
        try {
            String printedBy = "\"" + Messages.getString((String)"PRINTED_BY", (String[])new String[0]) + " " + Application.get().getGlobalInstances().getSession().getUser().getPersonNameOrTextOrEmpty() + " " + new SimpleDateFormat(FormatDateProvider.getFormatDate().toString() + " HH:mm").format(new Date()) + " - " + Messages.getString((String)"CONFIDENTIAL", (String[])new String[0]) + "\"";
            document = isPdf ? PdfUtil.addPrintedByToPdf((byte[])document, (String)printedBy) : this.addPrintByToImage(document, printedBy);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return document;
    }

    public byte[] addPrintByToImage(byte[] image, String printedBy) {
        try {
            BufferedImage old;
            BufferedImage img = old = ImageIO.read(new ByteArrayInputStream(image));
            Graphics2D g2d = img.createGraphics();
            g2d.drawImage((Image)old, 0, 0, null);
            g2d.setFont(new Font("SansSerif", 0, 12));
            FontMetrics fm = g2d.getFontMetrics();
            int x = img.getWidth() / 2 - fm.stringWidth(printedBy) / 2;
            int y = img.getHeight() - fm.getHeight();
            this.drawBackGroundRect(fm, printedBy, g2d, x, y);
            this.drawString(fm, printedBy, g2d, x, y);
            g2d.dispose();
            return this.getImageBytes(img);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void drawBackGroundRect(FontMetrics fm, String printedBy, Graphics2D g2d, int x, int y) {
        Color bgColor = Color.WHITE;
        g2d.setPaint(bgColor);
        Rectangle2D rect = fm.getStringBounds(printedBy, g2d);
        g2d.fillRect(x, y - fm.getAscent(), (int)rect.getWidth(), (int)rect.getHeight());
    }

    private void drawString(FontMetrics fm, String printedBy, Graphics2D g2d, int x, int y) {
        Color textColor = Color.BLACK;
        g2d.setPaint(textColor);
        g2d.drawString(printedBy, x, y);
    }

    public byte[] getImageBytes(BufferedImage img) {
        byte[] imageInByte = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)img, "png", baos);
            baos.flush();
            imageInByte = baos.toByteArray();
            baos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return imageInByte;
    }

    public XFaxSendNumberContainer getReviewCount() {
        XFaxSendNumberContainer container = new XFaxSendNumberContainer();
        container.doCountByStatus = true;
        container = this.faxAccessor.getCount(container);
        return container;
    }

    @Override
    public RouterFunction<?> getRoutes() {
        return RouterFunctions.routes("/dashboard", RouterFunctions.routes("/fax/ws", RouterFunctions.routeAction("/bypat", req -> {
            Integer id = req.getQueryParam("id", Integer.class);
            IWebSocketChannel wsChannel = null;
            try {
                wsChannel = WebApplication.get().getWebSocketDelegate().get(new WebSocketFilterByRequest(req));
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to get websocket channel documents by patient", e);
            }
            return this.getFaxByPatient(id, wsChannel);
        }), RouterFunctions.routeAction("/byIds", req -> {
            IdsProf data = req.getPostBody(IdsProf.class);
            List<Object> docs = data != null && data.ids != null && data.ids.length > 0 ? this.getFax(this.faxAccessor.byIds(data.ids, Boolean.TRUE), true) : Collections.emptyList();
            return ServerResponses.toJsonActionResult(docs);
        }), RouterFunctions.routeAction("/listOnDate", req -> {
            String data = req.getRequiredQueryParam("d", String.class);
            Integer idUser = req.getRequiredQueryParam("idUser", Integer.class);
            return ServerResponses.toJsonActionResult(this.listOnDate(data, idUser));
        }), RouterFunctions.routeAction("/search", req -> {
            if (req.hasQueryParam("q")) {
                String q = req.getQueryParam("q");
                return ServerResponses.toJsonActionResult(this.getFax(this.faxAccessor.faxList(this.faxSearchQuery(q)), q.split(" ")));
            }
            if (req.hasPostBody()) {
                CQueryFaxSend data = req.getPostBody(CQueryFaxSend.class);
                return ServerResponses.toJsonActionResult(this.getFax(this.faxAccessor.faxList(this.faxSearchQuery(data)), null));
            }
            return null;
        }), RouterFunctions.routeReturnObject("/save", req -> {
            CFaxSend cimage = req.getPostBody(CFaxSend.class);
            return this.save(cimage);
        }), RouterFunctions.routeReturnObject("/print", req -> {
            CFaxSend cimage = req.getPostBody(CFaxSend.class);
            return this.print(cimage);
        }), RouterFunctions.routeAction("/faxView", this::handleFaxView), RouterFunctions.routeAction("/faxResend", this::handleFaxResend)));
    }

    private ActionResult listOnDate(String data, Integer idUser) {
        XUser user;
        XSession session;
        XFaxSendNumberContainer fsc = new XFaxSendNumberContainer();
        LocalDate localDate = Utils.strToLocalDate(data);
        if (localDate == null) {
            localDate = LocalDate.today();
        }
        if (idUser == null && (session = Application.get().getGlobalInstances().getSession()) != null && (user = session.getUser()) != null) {
            idUser = user.id;
        }
        fsc.forLocalDate = localDate.dayFrom1970;
        fsc.doCountByStatus = true;
        fsc.idUser = idUser;
        XFaxSendNumberContainer count = this.faxAccessor.getCount(fsc);
        return ServerResponses.toJsonActionResult(count.countByStatus);
    }

    private ActionResult handleFaxView(IServerRequest req) throws Exception {
        CFaxSend fax = new CFaxSend();
        fax.id = req.getRequiredQueryParam("id", Integer.class);
        fax.faxId = req.getQueryParam("faxId", Long.class);
        fax = this.getDocument(fax);
        if (fax.viewerUrl != null) {
            try {
                return ServerResponses.toJsonActionResult((Object)fax);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error getting document " + (Object)((Object)fax), e);
                return ServerResponses.ERROR("Error getting document");
            }
        }
        return ServerResponses.ERROR("Invalid document id");
    }

    private ActionResult handleFaxResend(IServerRequest req) {
        CFaxSend fax = new CFaxSend();
        fax.id = req.getRequiredQueryParam("id", Integer.class);
        String docId = null;
        if (fax.faxId != null) {
            docId = "faxId" + fax.faxId;
            fax.document = this.faxAccessor.getFaxDocumentByFaxId(fax.faxId);
        } else if (fax.id != null) {
            docId = "id" + fax.id;
            fax.document = this.faxAccessor.getFaxDocumentById(fax.id);
        }
        if (docId != null && fax.document != null) {
            try {
                CFaxSend document = this.getCFaxSend(docId, fax);
                return ServerResponses.toJsonActionResult((Object)document);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error getting document " + docId, e);
                return ServerResponses.ERROR("Error getting document");
            }
        }
        return ServerResponses.ERROR("Invalid document id");
    }

    private ActionResult getFaxByPatient(Integer id, IWebSocketChannel wsChannel) {
        List<XFaxSend> lst = this.faxAccessor.faxListByPatient(id);
        return ServerResponses.toJsonActionResult(this.getFax(lst, false));
    }

    public ReturnObject print(CFaxSend image) {
        IPrintController ctrl = Application.get().getPrintControllerFactory().newPrintController((Serializable)image.x());
        ctrl.getSelection().add((IReport)new LightweightReport("fax", "Fax", PrintMode.ACTUAL_SIZE));
        return ServerResponses.print(ctrl);
    }
}

