/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.web.controller;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.web.controller.AbstractWebController;
import ca.infodata.ofys.client.web.core.ActionResult;
import ca.infodata.ofys.client.web.core.IServerRequest;
import ca.infodata.ofys.client.web.core.ServerResponses;
import ca.infodata.ofys.client.web.core.routes.RouterFunction;
import ca.infodata.ofys.client.web.core.routes.RouterFunctions;
import ca.infodata.ofys.data.middle.dataobjects.XUserRole;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObjectUpdatedNotification;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.ofys.ui.dashboard.accessor.FacilitySyncAccessorClient;
import ca.infodata.ofys.ui.dashboard.models.CSite;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class FacilityController
extends AbstractWebController {
    private static final Logger logger = Logger.getLogger(FacilityController.class.getName());
    private final FacilitySyncAccessorClient facilityAccessor = new FacilitySyncAccessorClient();

    public FacilityController() {
        this.getNotificationSystemConsumer().setHandleMethod(this::handleNotification);
    }

    private void handleNotification(DataObjectUpdatedNotification notification) throws Exception {
        IDataObject object = notification.getObject();
        if (object instanceof XSite) {
            boolean isAdmin;
            boolean bl = isAdmin = Application.get().getGlobalInstances().getSession() != null && Application.get().getGlobalInstances().hasOneOfRoles(XUserRole.ADMIN);
            if (!isAdmin) {
                ((XSite)object).hideFaxCredentials();
            }
            CSite jMsg = new CSite((XSite)object);
            ServerResponses.sendJsonToClient(notification.getClientId(), "site.update", (Object)jMsg);
        }
    }

    @Override
    public RouterFunction<?> getRoutes() {
        return RouterFunctions.routes("/dashboard/site/ws", RouterFunctions.routeAction("/findFixedPharmacies", this::findFixedPharmacies), RouterFunctions.routeAction("/save", req -> {
            CSite c = req.getPostBody(CSite.class);
            return ServerResponses.toJsonActionResult(this.save(c));
        }), RouterFunctions.routeAction("/get", this::getSite), RouterFunctions.routeAction("/findSiteB2bLogHeaders", this::findSiteB2bLogHeaders), RouterFunctions.routeAction("/readB2bSyncLog", this::readB2bSyncLog));
    }

    private ActionResult findSiteB2bLogHeaders(IServerRequest req) {
        Integer idSite = req.getRequiredQueryParam("idSite", Integer.class);
        Integer limit = req.getRequiredQueryParam("limit", Integer.class);
        return ServerResponses.toJsonActionResult(this.facilityAccessor.findSiteB2bLogHeaders(idSite, limit));
    }

    private ActionResult readB2bSyncLog(IServerRequest req) {
        Integer idB2bSiteLog = req.getRequiredQueryParam("idB2bSiteLog", Integer.class);
        return ServerResponses.toJsonActionResult(this.facilityAccessor.readB2bSyncLog(idB2bSiteLog));
    }

    private ActionResult findFixedPharmacies(IServerRequest req) {
        String s = req.getRequiredQueryParam("searchString", String.class);
        List<XSite> list = this.facilityAccessor.findFixedPharmacies(s);
        if (list == null) {
            list = new ArrayList<XSite>();
        }
        return ServerResponses.toJsonActionResult(list);
    }

    private ActionResult getSite(IServerRequest req) {
        Integer s = req.getRequiredQueryParam("id", Integer.class);
        XSite x = null;
        if (s != null) {
            x = this.facilityAccessor.getSite(s);
        }
        return ServerResponses.toJsonActionResult(x);
    }

    public ReturnObject save(CSite employee) {
        XSite x = employee.x();
        ReturnObject answer = this.facilityAccessor.save((IDataObject)x, true);
        XSite[] res = answer.getObj() instanceof XSite ? new XSite[]{(XSite)answer.getObj()} : (XSite[])answer.getObj();
        if (res != null) {
            ArrayList<CSite> retour = new ArrayList<CSite>();
            for (XSite i : res) {
                retour.add(new CSite(i));
            }
            answer.setObj(retour);
        }
        return answer;
    }
}

