/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.modules.dsq.internal;

import ca.infodata.dsq.domain.IPrescriptionSummary;
import ca.infodata.dsq.domain.NIU_PRESCRIPTION;
import ca.infodata.dsq.domain.PrescriptionDeviceDetails;
import ca.infodata.dsq.domain.PrescriptionDrugDetails;
import ca.infodata.dsq.service.dm.DMQRYCSvc.QueryContinuationResult;
import ca.infodata.dsq.signature.Signature;
import ca.infodata.dsq.signature.XmlSignatureI;
import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.job.IProgressMonitor;
import ca.infodata.ofys.client.job.Job;
import ca.infodata.ofys.client.job.JobStatus;
import ca.infodata.ofys.client.modules.dsq.AbortException;
import ca.infodata.ofys.client.modules.dsq.Alias;
import ca.infodata.ofys.client.modules.dsq.CancelException;
import ca.infodata.ofys.client.modules.dsq.DsqCallback;
import ca.infodata.ofys.client.modules.dsq.IDSQPluginController;
import ca.infodata.ofys.client.modules.dsq.internal.GetCandidateController;
import ca.infodata.ofys.client.modules.dsq.internal.OEPrescriptionControllerCallback;
import ca.infodata.ofys.client.modules.dsq.internal.QueryContinuationController;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.IDSQAccessor;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.status.StatusException;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OEPrescriptionController
extends QueryContinuationController {
    private static final LocalDate MINIMALDATE = LocalDate.from((int)1, (int)1, (int)2007);
    private static final String OBTENTION_DE_LA_LISTE_DES_ORDONNANCES_EN_ATTENTE = Messages.getString((String)"GetPrescriptionsNeverDispensedAction.OBTENTION_DE_LA_LISTE_DES_ORDONNANCES_EN_ATTENTE", (String[])new String[0]);
    private static final String OBTENTION_DE_L_ORDONNANCE_DETAILLEE = Messages.getString((String)"GetPrescriptionDispensedDetailsAction.OBTENTION_DE_L_ORDONNANCE_DETAILLEE", (String[])new String[0]);
    private static final Logger logger = Logger.getLogger(OEPrescriptionController.class.getName());
    private final OEPrescriptionControllerCallback callback;
    private final IDSQPluginController dsq;
    private final IDSQAccessor dsqAccessor;
    private final Integer idPatient;
    private LocalDate start = LocalDate.today().plusYear(-1);
    private LocalDate end = LocalDate.today();
    private boolean onlyActive = false;
    private int limit = 20;
    private List<IPrescriptionSummary> list;
    private QueryContinuationResult lastQCR;
    private Map<NIU_PRESCRIPTION, PrescriptionDrugDetails> drugMapDetail;
    private Map<NIU_PRESCRIPTION, PrescriptionDeviceDetails> deviceMapDetail;
    private GetCandidateController findCandidateAction;
    private Job listSummaryJob;
    private JobDeviceExtension getDeviceDetailJob;
    private JobDrugExtension getDrugDetailJob;

    public OEPrescriptionController(Integer idPatient, OEPrescriptionControllerCallback callback, GetCandidateController findCandidateAction) {
        if (callback == null) {
            throw new NullPointerException("callback");
        }
        if (findCandidateAction == null) {
            throw new NullPointerException("findCandidateAction");
        }
        this.idPatient = idPatient;
        this.callback = callback;
        this.findCandidateAction = findCandidateAction;
        this.dsq = Application.get().getDsqPluginController();
        this.dsqAccessor = Application.get().getDataAccessors().getDSQAccessor();
        this.drugMapDetail = new ConcurrentHashMap<NIU_PRESCRIPTION, PrescriptionDrugDetails>();
        this.deviceMapDetail = new ConcurrentHashMap<NIU_PRESCRIPTION, PrescriptionDeviceDetails>();
    }

    public void listSummary() throws Exception {
        if (this.listSummaryJob == null) {
            this.listSummaryJob = new Job("Sommaire des d\u00e9livrances", this::listSummary2);
        }
        if (this.listSummaryJob.getState() == JobStatus.RUNNING) {
            this.callback.listSummary(new DsqCallback<Object>(null, "Op\u00e9ration en cours...", null));
        } else {
            this.listSummaryJob.schedule();
        }
    }

    public void listSummary2(IProgressMonitor monitor) {
        if (this.list == null) {
            DsqCallback<QueryContinuationResult> r = this.listSummary3(monitor);
            this.lastQCR = (QueryContinuationResult)r.result;
            if (r.result != null) {
                this.list = new ArrayList<IPrescriptionSummary>(((QueryContinuationResult)r.result).prescriptions);
            }
            this.callback.listSummary(r);
        } else if (this.lastQCR != null && this.lastQCR.originalTotalQuantity < this.list.size()) {
            DsqCallback<QueryContinuationResult> r = this.continueQuery(this.idPatient, this.lastQCR, this.limit, monitor);
            if (r.result != null) {
                this.lastQCR = (QueryContinuationResult)r.result;
                this.list.addAll(((QueryContinuationResult)r.result).prescriptions);
                QueryContinuationResult r2 = new QueryContinuationResult();
                r2.originalTotalQuantity = this.lastQCR.originalTotalQuantity;
                r2.prescriptions = this.list;
                r2.queryId = ((QueryContinuationResult)r.result).queryId;
                r2.resultTotalQuantity = r2.originalTotalQuantity;
                r2.resultCurrentQuantity = r2.prescriptions.size();
                r2.resultRemainingQuantity = r2.resultTotalQuantity - r2.resultCurrentQuantity;
                this.callback.listSummary(new DsqCallback<QueryContinuationResult>(r2));
            } else {
                this.callback.listSummary(r);
            }
        } else {
            QueryContinuationResult r2 = new QueryContinuationResult();
            r2.originalTotalQuantity = this.lastQCR.originalTotalQuantity;
            r2.prescriptions = this.list;
            r2.queryId = this.lastQCR.queryId;
            r2.resultTotalQuantity = r2.originalTotalQuantity;
            r2.resultCurrentQuantity = r2.prescriptions.size();
            r2.resultRemainingQuantity = r2.resultTotalQuantity - r2.resultCurrentQuantity;
            this.callback.listSummary(new DsqCallback<QueryContinuationResult>(r2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DsqCallback<QueryContinuationResult> listSummary3(IProgressMonitor monitor) {
        DsqCallback<QueryContinuationResult> callback = new DsqCallback<QueryContinuationResult>();
        try {
            ReturnObject r;
            if (this.end == null || this.start == null) {
                callback.message = "Une date de d\u00e9but et une date de fin est requise";
                if (monitor != null) {
                    monitor.done();
                }
                DsqCallback<QueryContinuationResult> dsqCallback = callback;
                return dsqCallback;
            }
            if (this.end.before((IPartialDate)this.start)) {
                callback.message = "La date de d\u00e9but doit \u00eatre avant la date de fin";
                if (monitor != null) {
                    monitor.done();
                }
                DsqCallback<QueryContinuationResult> dsqCallback = callback;
                return dsqCallback;
            }
            if (this.start.before((IPartialDate)MINIMALDATE)) {
                callback.message = "La date de d\u00e9but ne peut \u00eatre avant " + MINIMALDATE.formatSlash();
                if (monitor != null) {
                    monitor.done();
                }
                DsqCallback<QueryContinuationResult> dsqCallback = callback;
                return dsqCallback;
            }
            if (monitor != null) {
                monitor.beginTask(OBTENTION_DE_LA_LISTE_DES_ORDONNANCES_EN_ATTENTE, 2);
            }
            XmlSignatureI signature = null;
            XmlSignatureI signatureNiu = null;
            if (!this.dsq.hasSignatures(this.idPatient)) {
                if (!Application.get().getApplicationUiPlugin().isWindowsDesktop()) {
                    throw new AbortException(Messages.getString((String)"ABSENCE_SIGN_DSQ", (String[])new String[0]));
                }
                this.dsq.checkIfActionWasCanceled(monitor);
                Alias alias = this.dsq.getAlias(monitor);
                this.dsq.checkIfActionWasCanceled(monitor);
                String niu = this.findCandidateAction.getNiu(monitor == null ? null : monitor.subMonitor(1));
                this.dsq.checkIfActionWasCanceled(monitor);
                signature = this.dsq.getSignatureI(monitor, alias);
                this.dsq.checkIfActionWasCanceled(monitor);
                signatureNiu = this.dsq.getXmlSignatureI(monitor, alias, niu);
                this.dsq.checkIfActionWasCanceled(monitor);
            }
            if (monitor != null) {
                monitor.worked(1);
            }
            this.dsq.checkIfActionWasCanceled(monitor);
            if (monitor != null) {
                monitor.subTask("Recherche");
            }
            if ((r = this.dsqAccessor.getPrescriptionOrderSummaryServiceOE((Signature)signature, (Signature)signatureNiu, this.idPatient, this.start, this.end, this.onlyActive)) == null) {
                throw new AbortException("Erreur lors de l'" + OBTENTION_DE_LA_LISTE_DES_ORDONNANCES_EN_ATTENTE.toLowerCase());
            }
            this.dsq.manageDsqStatus(r.getStatus());
            callback.result = (QueryContinuationResult)r.getObj();
            this.dsq.checkIfActionWasCanceled(monitor);
        }
        catch (AbortException | CancelException | CannotConnectToServerException | StatusException e) {
            callback.message = e.getMessage();
        }
        catch (Exception e) {
            callback.exception = e;
            callback.message = StringUtils.isBlank((CharSequence)e.getMessage()) ? Messages.getString((String)"UNE_ERREUR_INNATENDUE_EST_SURVENUE", (String[])new String[0]) : e.getMessage();
            logger.log(Level.SEVERE, String.format("Failed to list oe prescriptions list %s, %s, %s, %s", this.idPatient, this.start, this.end, this.onlyActive), e);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
        if (callback.result != null && ((QueryContinuationResult)callback.result).prescriptions != null) {
            Collections.sort(((QueryContinuationResult)callback.result).prescriptions, new Comparator<IPrescriptionSummary>(){

                @Override
                public int compare(IPrescriptionSummary o1, IPrescriptionSummary o2) {
                    return -o1.getDatetime().compareTo(o2.getDatetime());
                }
            });
        }
        return callback;
    }

    public IPrescriptionSummary get(NIU_PRESCRIPTION id) {
        if (id == null) {
            return null;
        }
        if (this.list == null) {
            return null;
        }
        for (IPrescriptionSummary s : this.list) {
            if (!s.getId().equals(id.value()) || !s.getVersion().equals(id.version())) continue;
            return s;
        }
        return null;
    }

    public void getDrugDetail(NIU_PRESCRIPTION id) throws Exception {
        if (this.getDrugDetailJob == null) {
            this.getDrugDetailJob = new JobDrugExtension(OBTENTION_DE_L_ORDONNANCE_DETAILLEE);
        }
        if (this.getDrugDetailJob.getState() == JobStatus.RUNNING) {
            this.callback.getDeviceDetail(id, new DsqCallback<Object>(null, "Op\u00e9ration en cours...", null));
        } else {
            this.getDrugDetailJob.setId(id);
            this.getDrugDetailJob.schedule();
        }
    }

    protected void getDrugDetail2(NIU_PRESCRIPTION id, IProgressMonitor monitor) {
        PrescriptionDrugDetails d = this.drugMapDetail.get(id);
        if (d == null) {
            DsqCallback<PrescriptionDrugDetails> c = this.getDrugDetail3(id, monitor);
            if (c.result != null) {
                this.drugMapDetail.put(id, (PrescriptionDrugDetails)c.result);
            }
            this.callback.getDrugDetail(id, c);
        } else {
            this.callback.getDrugDetail(id, new DsqCallback<PrescriptionDrugDetails>(d));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DsqCallback<PrescriptionDrugDetails> getDrugDetail3(NIU_PRESCRIPTION id, IProgressMonitor monitor) {
        DsqCallback<PrescriptionDrugDetails> callback = new DsqCallback<PrescriptionDrugDetails>();
        if (monitor != null) {
            monitor.beginTask(OBTENTION_DE_L_ORDONNANCE_DETAILLEE, 3);
        }
        try {
            ReturnObject r;
            XmlSignatureI signature = null;
            XmlSignatureI signatureNiu = null;
            if (!this.dsq.hasSignatures(this.idPatient)) {
                if (!Application.get().getApplicationUiPlugin().isWindowsDesktop()) {
                    throw new AbortException(Messages.getString((String)"ABSENCE_SIGN_DSQ", (String[])new String[0]));
                }
                Alias alias = this.dsq.getAlias(monitor);
                String niu = this.findCandidateAction.getNiu(monitor == null ? null : monitor.subMonitor(1));
                signature = this.dsq.getSignatureI(monitor, alias);
                signatureNiu = this.dsq.getXmlSignatureI(monitor, alias, niu);
            }
            if ((r = this.dsqAccessor.getDrugPrescriptionDetailsOE((Signature)signature, (Signature)signatureNiu, this.idPatient, id.value(), id.version())) == null) {
                throw new AbortException("Erreur lors de l'" + OBTENTION_DE_L_ORDONNANCE_DETAILLEE.toLowerCase());
            }
            this.dsq.manageDsqStatus(r.getStatus());
            callback.result = (PrescriptionDrugDetails)r.getObj();
        }
        catch (CannotConnectToServerException e) {
            callback.message = Messages.getString((String)"IMPOSSIBLE_DACCEDER_AU_SERVEUR_DE_LOGICIELS_INFODATA", (String[])new String[0]);
        }
        catch (InterruptedException e) {
        }
        catch (AbortException | StatusException e) {
            callback.message = e.getMessage();
        }
        catch (CancelException e) {
        }
        catch (Exception e) {
            callback.exception = e;
            callback.message = StringUtils.isBlank((CharSequence)e.getMessage()) ? Messages.getString((String)"UNE_ERREUR_INNATENDUE_EST_SURVENUE", (String[])new String[0]) : e.getMessage();
            logger.log(Level.SEVERE, "Failed to get prescription drug details with niu=" + id + ", patient=" + this.idPatient, e);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
        return callback;
    }

    public void getDeviceDetail(NIU_PRESCRIPTION id) throws Exception {
        if (this.getDeviceDetailJob == null) {
            this.getDeviceDetailJob = new JobDeviceExtension(OBTENTION_DE_L_ORDONNANCE_DETAILLEE);
        }
        if (this.getDeviceDetailJob.getState() == JobStatus.RUNNING) {
            this.callback.getDeviceDetail(id, new DsqCallback<Object>(null, "Op\u00e9ration en cours...", null));
        } else {
            this.getDeviceDetailJob.setId(id);
            this.getDeviceDetailJob.schedule();
        }
    }

    protected void getDeviceDetail2(NIU_PRESCRIPTION id, IProgressMonitor monitor) {
        PrescriptionDeviceDetails d = this.deviceMapDetail.get(id);
        if (d == null) {
            DsqCallback<PrescriptionDeviceDetails> c = this.getDeviceDetail3(id, monitor);
            if (c.result != null) {
                this.deviceMapDetail.put(id, (PrescriptionDeviceDetails)c.result);
            }
            this.callback.getDeviceDetail(id, c);
        } else {
            this.callback.getDeviceDetail(id, new DsqCallback<PrescriptionDeviceDetails>(d));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DsqCallback<PrescriptionDeviceDetails> getDeviceDetail3(NIU_PRESCRIPTION id, IProgressMonitor monitor) {
        DsqCallback<PrescriptionDeviceDetails> callback = new DsqCallback<PrescriptionDeviceDetails>();
        if (monitor != null) {
            monitor.beginTask(OBTENTION_DE_L_ORDONNANCE_DETAILLEE, 3);
        }
        try {
            ReturnObject r;
            XmlSignatureI signature = null;
            XmlSignatureI signatureNiu = null;
            if (!this.dsq.hasSignatures(this.idPatient)) {
                if (!Application.get().getApplicationUiPlugin().isWindowsDesktop()) {
                    throw new AbortException(Messages.getString((String)"ABSENCE_SIGN_DSQ", (String[])new String[0]));
                }
                Alias alias = this.dsq.getAlias(monitor);
                String niu = this.findCandidateAction.getNiu(monitor == null ? null : monitor.subMonitor(1));
                signature = this.dsq.getSignatureI(monitor, alias);
                signatureNiu = this.dsq.getXmlSignatureI(monitor, alias, niu);
            }
            if ((r = this.dsqAccessor.getDevicePrescriptionDetailsOE((Signature)signature, (Signature)signatureNiu, this.idPatient, id.value(), id.version())) == null) {
                throw new AbortException("Erreur lors de l'" + OBTENTION_DE_L_ORDONNANCE_DETAILLEE.toLowerCase());
            }
            this.dsq.manageDsqStatus(r.getStatus());
            callback.result = (PrescriptionDeviceDetails)r.getObj();
        }
        catch (CannotConnectToServerException e) {
            callback.message = Messages.getString((String)"IMPOSSIBLE_DACCEDER_AU_SERVEUR_DE_LOGICIELS_INFODATA", (String[])new String[0]);
        }
        catch (InterruptedException e) {
        }
        catch (AbortException | StatusException e) {
            callback.message = e.getMessage();
        }
        catch (CancelException e) {
        }
        catch (Exception e) {
            callback.exception = e;
            callback.message = StringUtils.isBlank((CharSequence)e.getMessage()) ? Messages.getString((String)"UNE_ERREUR_INNATENDUE_EST_SURVENUE", (String[])new String[0]) : e.getMessage();
            logger.log(Level.SEVERE, "Failed to get prescription device details with niu=" + id + ", patient=" + this.idPatient, e);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
        return callback;
    }

    public void clear() {
        this.list = null;
        this.lastQCR = null;
        this.drugMapDetail.clear();
        this.deviceMapDetail.clear();
    }

    public LocalDate getStart() {
        return this.start;
    }

    public void setStart(LocalDate start) {
        this.start = start;
        this.list = null;
        this.lastQCR = null;
    }

    public LocalDate getEnd() {
        return this.end;
    }

    public void setEnd(LocalDate end) {
        this.end = end;
        this.list = null;
        this.lastQCR = null;
    }

    public boolean isOnlyActive() {
        return this.onlyActive;
    }

    public void setOnlyActive(boolean onlyActive) {
        this.onlyActive = onlyActive;
        this.list = null;
        this.lastQCR = null;
    }

    public OEPrescriptionControllerCallback getCallback() {
        return this.callback;
    }

    final class JobDeviceExtension
    extends Job {
        private NIU_PRESCRIPTION id;

        public void setId(NIU_PRESCRIPTION id) {
            this.id = id;
        }

        private JobDeviceExtension(String name) {
            super(name);
        }

        @Override
        public void runWithException() {
            OEPrescriptionController.this.getDeviceDetail2(this.id, this);
        }
    }

    final class JobDrugExtension
    extends Job {
        private NIU_PRESCRIPTION id;

        public void setId(NIU_PRESCRIPTION id) {
            this.id = id;
        }

        private JobDrugExtension(String name) {
            super(name);
        }

        @Override
        public void runWithException() {
            OEPrescriptionController.this.getDrugDetail2(this.id, this);
        }
    }
}

