/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.modules.dsq.internal;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.pdf.ParagraphBuilder;
import ca.infodata.ofys.data.middle.dataobjects.pdf.TablePdf;
import ca.infodata.ofys.ui.dashboard.models.CDsqRequest;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class ListImagingExamWebControllerPrint {
    private static String PRINTTITLE = "Liste des r\u00e9sultats d'imagerie m\u00e9dicale";
    private static final String CES_DONNEES_SONT_EXTRAITES_DU_DOSSIER_SANTE_QUEBEC_DSQ = "Ces donn\u00e9es sont extraites du DOSSIER SANT\u00c9 QU\u00c9BEC (DSQ)";
    private CDsqRequest dsqRequest;

    public ListImagingExamWebControllerPrint(CDsqRequest dsqRequest) {
        this.dsqRequest = dsqRequest;
    }

    public byte[] print() throws DocumentException, IOException {
        List<Paragraph> com = this.getPrintComments(this.dsqRequest.patientName);
        TablePdf print = this.getPrintTable(PRINTTITLE, com, this.dsqRequest.printColumns, this.dsqRequest.printTable);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        print.generatePdf((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private TablePdf getPrintTable(String title, List<Paragraph> comments, List<String> columns, List<List<String>> table) {
        TablePdf pdf = new TablePdf();
        pdf.setTitle(title);
        pdf.setComments(comments);
        pdf.setPrintedBy(Application.get().getApplicationUiPlugin().getPrintedByNotice());
        for (int i = 0; i < columns.size(); ++i) {
            pdf.getHeaders().add(columns.get(i));
        }
        pdf.setRows(table);
        return pdf;
    }

    private List<Paragraph> getPrintComments(String patient) {
        Font font = new Font(2, 10.0f, 0, Color.black);
        ArrayList<Paragraph> comments = new ArrayList<Paragraph>();
        comments.add(new ParagraphBuilder("Patient : " + patient, font, 0).build());
        comments.add(new ParagraphBuilder("   ", font, 0).build());
        comments.add(new ParagraphBuilder("Ces donn\u00e9es sont extraites du DOSSIER SANT\u00c9 QU\u00c9BEC (DSQ)\n\n", new Font(2, 10.0f, 2, Color.black), 1).build());
        return comments;
    }
}

