/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.datatypes;

import com.hivemq.client.annotations.Immutable;
import com.hivemq.client.internal.mqtt.datatypes.MqttUtf8StringImpl;
import com.hivemq.client.internal.shaded.io.netty.buffer.ByteBuf;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Contract;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import com.hivemq.client.mqtt.mqtt5.datatypes.Mqtt5UserProperty;

@Immutable
public class MqttUserPropertyImpl
implements Mqtt5UserProperty {
    @NotNull
    private final MqttUtf8StringImpl name;
    @NotNull
    private final MqttUtf8StringImpl value;

    @Contract(value="null, _ -> fail; _, null -> fail")
    @NotNull
    public static MqttUserPropertyImpl of(@Nullable String name, @Nullable String value) {
        return MqttUserPropertyImpl.of(MqttUtf8StringImpl.of(name, "User property name"), MqttUtf8StringImpl.of(value, "User property value"));
    }

    @NotNull
    public static MqttUserPropertyImpl of(@NotNull MqttUtf8StringImpl name, @NotNull MqttUtf8StringImpl value) {
        return new MqttUserPropertyImpl(name, value);
    }

    @Nullable
    public static MqttUserPropertyImpl decode(@NotNull ByteBuf in) {
        MqttUtf8StringImpl name = MqttUtf8StringImpl.decode(in);
        if (name == null) {
            return null;
        }
        MqttUtf8StringImpl value = MqttUtf8StringImpl.decode(in);
        if (value == null) {
            return null;
        }
        return new MqttUserPropertyImpl(name, value);
    }

    public MqttUserPropertyImpl(@NotNull MqttUtf8StringImpl name, @NotNull MqttUtf8StringImpl value) {
        this.name = name;
        this.value = value;
    }

    @Override
    @NotNull
    public MqttUtf8StringImpl getName() {
        return this.name;
    }

    @Override
    @NotNull
    public MqttUtf8StringImpl getValue() {
        return this.value;
    }

    void encode(@NotNull ByteBuf out) {
        out.writeByte(38);
        this.name.encode(out);
        this.value.encode(out);
    }

    int encodedLength() {
        return 1 + this.name.encodedLength() + this.value.encodedLength();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MqttUserPropertyImpl)) {
            return false;
        }
        MqttUserPropertyImpl that = (MqttUserPropertyImpl)o;
        return this.name.equals(that.name) && this.value.equals(that.value);
    }

    public int hashCode() {
        return 31 * this.name.hashCode() + this.value.hashCode();
    }

    @Override
    public int compareTo(@NotNull Mqtt5UserProperty that) {
        int nameComparison = this.name.compareTo(that.getName());
        return nameComparison != 0 ? nameComparison : this.value.compareTo(that.getValue());
    }

    @NotNull
    public String toString() {
        return "(" + this.name + ", " + this.value + ")";
    }
}

