/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1.date;

import ca.infodata.util1.JoinList;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.IRelativeDate;
import ca.infodata.util1.date.LocalDate;
import java.util.concurrent.ConcurrentHashMap;

public final class PartialDate
implements IPartialDate,
IRelativeDate {
    private static final ConcurrentHashMap<Integer, PartialDate> cache = new ConcurrentHashMap(200);
    private static final long serialVersionUID = 1L;
    private final Integer day;
    private final Integer month;
    private final Integer year;

    public static PartialDate from(Integer day, Integer month, Integer year) {
        int hashCode = PartialDate.hashCode(day, month, year);
        PartialDate date = cache.get(hashCode);
        if (date == null) {
            date = new PartialDate(day, month, year);
            PartialDate putByOtherThreadJustNow = cache.putIfAbsent(hashCode, date);
            if (putByOtherThreadJustNow != null) {
                date = putByOtherThreadJustNow;
            }
        }
        return date;
    }

    public static PartialDate from(LocalDate localDate) {
        if (localDate == null) {
            return null;
        }
        return PartialDate.from(Integer.valueOf(localDate.day), Integer.valueOf(localDate.month), localDate.year);
    }

    private PartialDate(Integer day, Integer month, Integer year) {
        if (year == null) {
            throw new NullPointerException("year should always be not null");
        }
        if (day != null && month == null) {
            throw new NullPointerException("month cant be null if day is not null");
        }
        if (month != null && (month < 1 || month > 12)) {
            throw new IllegalArgumentException("month must be between 1 and 12 but is " + month);
        }
        if (day != null && (day < 1 || day > 31)) {
            throw new IllegalArgumentException("day must be between 1 and 31 but is " + day);
        }
        if (day != null && month != null && year != null) {
            LocalDate.from(day, month, year);
        }
        this.day = day;
        this.month = month;
        this.year = year;
    }

    private Object readResolve() {
        int hashCode = this.hashCode();
        PartialDate date = cache.get(hashCode);
        if (date == null) {
            date = new PartialDate(this.day, this.month, this.year);
            PartialDate putByOtherThreadJustNow = cache.putIfAbsent(hashCode, date);
            if (putByOtherThreadJustNow != null) {
                date = putByOtherThreadJustNow;
            }
        }
        return date;
    }

    public int hashCode() {
        return PartialDate.hashCode(this.day, this.month, this.year);
    }

    private static int hashCode(Integer day, Integer month, Integer year) {
        int result = 0;
        if (year != null) {
            result += year * 10000;
        }
        if (month != null) {
            result += month * 100;
        }
        if (day != null) {
            result += day.intValue();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PartialDate other = (PartialDate)obj;
        if (this.day == null ? other.day != null : !this.day.equals(other.day)) {
            return false;
        }
        if (this.month == null ? other.month != null : !this.month.equals(other.month)) {
            return false;
        }
        return this.year == other.year;
    }

    public String toString() {
        return this.year + "/" + this.month + "/" + this.day;
    }

    @Override
    public String formatHyphen() {
        JoinList list = new JoinList("-", 3);
        if (this.year != null) {
            list.add(StringUtils.leftPad(this.year.toString(), 4, '0'));
        }
        if (this.month != null) {
            list.add(StringUtils.leftPad(this.month.toString(), 2, '0'));
        }
        if (this.day != null) {
            list.add(StringUtils.leftPad(this.day.toString(), 2, '0'));
        }
        return list.toString();
    }

    @Override
    public String formatSlash() {
        JoinList list = new JoinList("/", 3);
        if (this.year != null) {
            list.add(StringUtils.leftPad(this.year.toString(), 4, '0'));
        }
        if (this.month != null) {
            list.add(StringUtils.leftPad(this.month.toString(), 2, '0'));
        }
        if (this.day != null) {
            list.add(StringUtils.leftPad(this.day.toString(), 2, '0'));
        }
        return list.toString();
    }

    @Override
    public Integer getDay() {
        return this.day;
    }

    @Override
    public Integer getMonth() {
        return this.month;
    }

    @Override
    public Integer getYear() {
        return this.year;
    }

    @Override
    public boolean isComplete() {
        return this.day != null && this.month != null && this.year != null;
    }

    @Override
    public boolean after(IPartialDate date) {
        return this.compareTo(date) > 0;
    }

    @Override
    public boolean before(IPartialDate date) {
        return this.compareTo(date) < 0;
    }

    @Override
    public LocalDate toAbsoluteDate() {
        return LocalDate.from(this);
    }

    @Override
    public String store() {
        return "PartialDate;" + this.getDay() + ";" + this.getMonth() + ";" + this.getYear();
    }

    public static PartialDate restore(String s) {
        String[] split;
        if (StringUtils.isNotBlank(s) && (split = s.split(";")).length == 4 && split[0].equals("PartialDate")) {
            try {
                Integer d = split[1].equals("null") ? null : Integer.valueOf(Integer.parseInt(split[0]));
                Integer m = split[2].equals("null") ? null : Integer.valueOf(Integer.parseInt(split[1]));
                Integer y = split[3].equals("null") ? null : Integer.valueOf(Integer.parseInt(split[2]));
                return new PartialDate(d, m, y);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public int compareTo(IPartialDate o) {
        if (o == null) {
            throw new NullPointerException("o");
        }
        if (this == o) {
            return 0;
        }
        int i = PartialDate.compareNullFirst(this.getYear(), o.getYear());
        if (i == 0 && (i = PartialDate.compareNullFirst(this.getMonth(), o.getMonth())) == 0) {
            i = PartialDate.compareNullFirst(this.getDay(), o.getDay());
        }
        return i;
    }

    private static int compareNullFirst(Integer o1, Integer o2) {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        return o1.compareTo(o2);
    }

    @Override
    public PartialDate clone() {
        return this;
    }
}

