/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1;

import ca.infodata.util1.RangeNotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class FastIntRange {
    public static final int NULL = Integer.MIN_VALUE;
    private volatile int hashCodeCache;
    private int start;
    private int end;
    private RangeNotation notation;

    public FastIntRange() {
        this(Integer.MIN_VALUE, Integer.MIN_VALUE, null);
    }

    public FastIntRange(RangeNotation notation) {
        this(Integer.MIN_VALUE, Integer.MIN_VALUE, notation);
    }

    public FastIntRange(int start, int end, RangeNotation notation) {
        this.start = start;
        this.end = end;
        this.notation = notation;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
        this.hashCodeCache = Integer.MIN_VALUE;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
        this.hashCodeCache = Integer.MIN_VALUE;
    }

    public RangeNotation getNotation() {
        return this.notation;
    }

    public void setNotation(RangeNotation notation) {
        this.notation = notation;
        this.hashCodeCache = Integer.MIN_VALUE;
    }

    public void valid() {
        if (this.notation == null) {
            throw new IllegalArgumentException("notation cant be null");
        }
        if (this.start != Integer.MIN_VALUE && this.end != Integer.MIN_VALUE) {
            int compareTo = this.start - this.end;
            if (compareTo > 0) {
                throw new IllegalArgumentException("start must be lower than or equals to end");
            }
            switch (this.notation) {
                case LEFT_CLOSED: 
                case RIGHT_CLOSED: 
                case OPEN: {
                    if (compareTo != 0) break;
                    throw new IllegalArgumentException("with LEFT_CLOSED, RIGHT_CLOSED or OPEN notation, start cant be equals to end");
                }
            }
        }
        if (this.start != Integer.MIN_VALUE && this.end != Integer.MIN_VALUE && this.notation == RangeNotation.OPEN && this.start + 1 == this.end) {
            throw new IllegalArgumentException("]n,n+1[ is invalid. was " + this);
        }
    }

    public boolean contains(int other) {
        this.valid();
        return this.inRange(other, this.start, this.end, this.notation);
    }

    public String toString() {
        String starts = this.start == Integer.MIN_VALUE ? "" : String.valueOf(this.start);
        String ends = this.end == Integer.MIN_VALUE ? "" : String.valueOf(this.end);
        switch (this.notation) {
            case OPEN: {
                return String.format("]%s...%s[", starts, ends);
            }
            case CLOSED: {
                return String.format("[%s...%s]", starts, ends);
            }
            case LEFT_CLOSED: {
                return String.format("[%s...%s[", starts, ends);
            }
            case RIGHT_CLOSED: {
                return String.format("]%s...%s]", starts, ends);
            }
        }
        return super.toString();
    }

    public List<FastIntRange> remove(FastIntRange range) {
        if (range == null) {
            throw new NullPointerException("range");
        }
        this.valid();
        range.valid();
        if (this.intersect(range)) {
            FastIntRange r;
            int start1 = this.toClosedStart(this.start, this.notation);
            int end1 = this.toClosedEnd(this.end, this.notation);
            int start2 = this.toClosedStart(range.start, range.notation);
            int end2 = this.toClosedEnd(range.end, range.notation);
            if (start2 == Integer.MIN_VALUE && end2 == Integer.MIN_VALUE) {
                return Collections.emptyList();
            }
            if (start2 == Integer.MIN_VALUE) {
                return Arrays.asList(new FastIntRange(end2, end1, end1 == Integer.MIN_VALUE ? RangeNotation.OPEN : RangeNotation.RIGHT_CLOSED));
            }
            if (end2 == Integer.MIN_VALUE) {
                return Arrays.asList(new FastIntRange(start1, start2, start1 == Integer.MIN_VALUE ? RangeNotation.OPEN : RangeNotation.LEFT_CLOSED));
            }
            if (start1 == Integer.MIN_VALUE && end1 == Integer.MIN_VALUE) {
                FastIntRange r1 = new FastIntRange(Integer.MIN_VALUE, start2, RangeNotation.OPEN);
                FastIntRange r2 = new FastIntRange(end2, Integer.MIN_VALUE, RangeNotation.OPEN);
                return Arrays.asList(r1, r2);
            }
            if (start1 == Integer.MIN_VALUE) {
                ArrayList<FastIntRange> list = new ArrayList<FastIntRange>(2);
                FastIntRange r1 = new FastIntRange(Integer.MIN_VALUE, start2, RangeNotation.OPEN);
                list.add(r1);
                if (end1 > end2) {
                    FastIntRange r2 = new FastIntRange(end2, end1, RangeNotation.RIGHT_CLOSED);
                    list.add(r2);
                }
                return list;
            }
            if (end1 == Integer.MIN_VALUE) {
                ArrayList<FastIntRange> list = new ArrayList<FastIntRange>(2);
                FastIntRange r1 = new FastIntRange(end2, Integer.MIN_VALUE, RangeNotation.OPEN);
                list.add(r1);
                if (start1 < start2) {
                    FastIntRange r2 = new FastIntRange(start1, start2, RangeNotation.LEFT_CLOSED);
                    list.add(r2);
                }
                return list;
            }
            ArrayList<FastIntRange> list = new ArrayList<FastIntRange>(2);
            if (start1 < start2) {
                r = new FastIntRange(start1, start2, RangeNotation.LEFT_CLOSED);
                list.add(r);
            }
            if (end1 > end2) {
                r = new FastIntRange(end2, end1, RangeNotation.RIGHT_CLOSED);
                list.add(r);
            }
            return list;
        }
        return Arrays.asList(this);
    }

    public boolean intersect(FastIntRange range) {
        if (range == null) {
            throw new NullPointerException("range");
        }
        this.valid();
        range.valid();
        int start1 = this.toClosedStart(this.start, this.notation);
        int end1 = this.toClosedEnd(this.end, this.notation);
        int start2 = this.toClosedStart(range.start, range.notation);
        int end2 = this.toClosedEnd(range.end, range.notation);
        return start1 == Integer.MIN_VALUE && end1 == Integer.MIN_VALUE && start2 == Integer.MIN_VALUE && end2 == Integer.MIN_VALUE || this.inRange(start2, start1, end1, RangeNotation.CLOSED) || this.inRange(end2, start1, end1, RangeNotation.CLOSED) || this.inRange(start1, start2, end2, RangeNotation.CLOSED) || this.inRange(end1, start2, end2, RangeNotation.CLOSED);
    }

    private boolean inRange(int value, int lowerLimit, int upperLimit, RangeNotation notation) {
        if (value == Integer.MIN_VALUE) {
            return false;
        }
        if (lowerLimit == Integer.MIN_VALUE) {
            return true;
        }
        if (upperLimit == Integer.MIN_VALUE) {
            return true;
        }
        return notation.inRange(value, lowerLimit, upperLimit);
    }

    public FastIntRange merge(FastIntRange range) {
        int newStart;
        if (range == null) {
            throw new NullPointerException("range");
        }
        this.valid();
        range.valid();
        int start1 = this.toClosedStart(this.start, this.notation);
        int end1 = this.toClosedEnd(this.end, this.notation);
        int start2 = this.toClosedStart(range.start, range.notation);
        int end2 = this.toClosedEnd(range.end, range.notation);
        if (start1 == Integer.MIN_VALUE || start2 == Integer.MIN_VALUE) {
            newStart = Integer.MIN_VALUE;
        } else {
            int n = newStart = start1 < start2 ? start1 : start2;
        }
        int newEnd = end1 == Integer.MIN_VALUE || end2 == Integer.MIN_VALUE ? Integer.MIN_VALUE : (end1 > end2 ? end1 : end2);
        return new FastIntRange(newStart, newEnd, RangeNotation.CLOSED);
    }

    private int toClosedEnd(int end, RangeNotation notation) {
        if (end == Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        switch (notation) {
            case RIGHT_CLOSED: 
            case CLOSED: {
                return end;
            }
            case LEFT_CLOSED: 
            case OPEN: {
                return end - 1;
            }
        }
        throw new IllegalArgumentException("invalid notation " + (Object)((Object)notation));
    }

    private int toClosedStart(int start, RangeNotation notation) {
        if (start == Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        switch (notation) {
            case LEFT_CLOSED: 
            case CLOSED: {
                return start;
            }
            case RIGHT_CLOSED: 
            case OPEN: {
                return start + 1;
            }
        }
        throw new IllegalArgumentException("invalid notation " + (Object)((Object)notation));
    }

    public int hashCode() {
        if (this.hashCodeCache == Integer.MIN_VALUE) {
            int prime = 31;
            int result = 1;
            int start = this.toClosedStart(this.start, this.notation);
            int end = this.toClosedEnd(this.end, this.notation);
            result = 31 * result + (end == Integer.MIN_VALUE ? 0 : end);
            result = 31 * result + (start == Integer.MIN_VALUE ? 0 : start);
            this.hashCodeCache = result = 31 * result + RangeNotation.CLOSED.hashCode();
        }
        return this.hashCodeCache;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return obj.hashCode() == this.hashCode();
    }
}

