/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.preferences;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.PreferencesAccessorClient;
import ca.infodata.ofys.data.dataaccess.callback.Callback;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XPreferencesContainer;
import ca.infodata.ofys.data.middle.dataobjects.XRight;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.ui.controls.BaseMultiEditor;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.ICancelablePart;
import ca.infodata.ofys.ui.controls.ISaveablePart;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.preferences.ImportExportPreferencesEditor;
import ca.infodata.ofys.ui.preferences.MainPreferencesEditor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;

public class PreferencesMultiEditor
extends BaseMultiEditor
implements ISaveablePart,
ICancelablePart {
    private static final Logger logger = Logger.getLogger(PreferencesMultiEditor.class.getName());
    private int iNextPage = 0;
    private MainPreferencesEditor mainPreferencesEditor;
    private ImportExportPreferencesEditor importExportPreferencesEditor;

    public XPreferencesContainer getPreferencesContainer() {
        return (XPreferencesContainer)((EditorInput)this.getEditorInput()).getCompleteDataObject();
    }

    public void createMyPages() throws PartInitException {
        boolean isAdminOrInfodata;
        boolean bl = isAdminOrInfodata = Application.get().getGlobalInstances().getSession() != null && Application.get().getGlobalInstances().hasRight(XRight.PREFERENCES_GLOBAL);
        if (isAdminOrInfodata) {
            this.mainPreferencesEditor = new MainPreferencesEditor(this);
            this.addPage((IEditorPart)this.mainPreferencesEditor, this.getEditorInput());
            this.setPageText(this.iNextPage, Messages.getString((String)"GLOBALE", (String[])new String[0]));
            this.setPageImage(this.iNextPage, ResourceGetter.getImage((String)"images/pen.gif"));
            ++this.iNextPage;
            if (Application.get().getGlobalInstances().hasRight(XRight.IMPORT_PATIENT) || Application.get().getGlobalInstances().hasRight(XRight.EXPORT_PATIENT)) {
                this.importExportPreferencesEditor = new ImportExportPreferencesEditor(this);
                this.addPage((IEditorPart)this.importExportPreferencesEditor, this.getEditorInput());
                this.setPageText(this.iNextPage, Messages.getString((String)"GmfPreferencesEditor.IMPORTATION/EXPORTATION", (String[])new String[0]));
                this.setPageImage(this.iNextPage, ResourceGetter.getImage((String)"images/pen.gif"));
                ++this.iNextPage;
            }
        }
    }

    public void setToolBarStatus() {
    }

    public BaseAccessorClient getAccessor() throws CannotConnectToServerException {
        return PreferencesAccessorClient.getInstance();
    }

    public void initDataOverride() {
        if (((EditorInput)this.getEditorInput()).getDataObject() instanceof XPreferencesContainer) {
            JobCallback callback = new JobCallback((IStatusHandler)DefaultStatusHandler.getInstance()){

                public void responseReceived(final ReturnObject response) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            PreferencesMultiEditor.this.initializeCompleteDataObject((EditableDataObject)response.getObj());
                        }
                    });
                }
            };
            try {
                PreferencesAccessorClient.getInstance().getPreferencesContainer(this.getUniqueKey(), Application.get().getGlobalInstances().getSession(), (Callback)callback);
            }
            catch (CannotConnectToServerException cannotConnectToServerException) {
                MessageUtil.cannotConnectToServerExceptionMsg();
                callback.kill();
            }
            catch (Exception e) {
                callback.kill();
                logger.log(Level.SEVERE, "Erreur", e);
            }
        }
    }

    public boolean isDataDirty() {
        return this.getPreferencesContainer().isDirty();
    }

    public Image getEditorTitleImage() {
        return ResourceGetter.getImage((String)"images/Heart-icon32.png");
    }

    public String getEditorTitle() {
        if (Application.get().getGlobalInstances().inDebugMode()) {
            return super.getEditorTitle();
        }
        return Messages.getString((String)"PREFERENCES", (String[])new String[0]);
    }

    public void saved() {
        super.saved();
        Application.get().getGlobalInstances().getSession().setClientPreferences(this.getPreferencesContainer().getClientPreferences());
        Application.get().getGlobalInstances().getSession().getUser().setUserPreferences(this.getPreferencesContainer().getUserPreferences());
    }

    public void initializeCompleteDataObject(EditableDataObject completeDataObject) {
        super.initializeCompleteDataObject(completeDataObject);
        if (completeDataObject != null) {
            completeDataObject.setListenerEnabled(true);
        }
    }
}

