/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.professionnal;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.ProfessionnalAccessorClient;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IVariablesReplacer;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.patient.XPatientInactiveRaison;
import ca.infodata.ofys.data.middle.dataobjects.variablereplacer.PersonVariableReplacer;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.ICancelablePart;
import ca.infodata.ofys.ui.controls.ISaveablePart;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.person.PersonMultiEditor;
import ca.infodata.ofys.ui.person.professionnal.ProfessionnalEditor;
import ca.infodata.util1.StringUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;

public class ProfessionnalMultiEditor
extends PersonMultiEditor
implements ISaveablePart,
ICancelablePart {
    private static final Logger logger = Logger.getLogger("ca.infodata.ofys.ui.person.professionnal.ProfessionnalMultiEditor");
    private ProfessionnalEditor professionnalEditor;
    private int iNextPage;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initDataOverride() {
        if (((EditorInput)this.getEditorInput()).getDataObject() instanceof XBaseProfessionnal) {
            XBaseProfessionnal baseProfessionnal = (XBaseProfessionnal)((EditorInput)this.getEditorInput()).getDataObject();
            if (baseProfessionnal.getId() == null) {
                XProfessionnal professionnal = new XProfessionnal();
                professionnal.initialize();
                this.initializeCompleteDataObject((EditableDataObject)professionnal);
                return;
            } else {
                JobCallback callback = new JobCallback(Messages.getString((String)"CHARGEMENT", (String[])new String[0]), (IStatusHandler)DefaultStatusHandler.getInstance()){

                    public void responseReceived(final ReturnObject response) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ProfessionnalMultiEditor.this.initializeCompleteDataObject((EditableDataObject)response.getObj());
                            }
                        });
                    }
                };
                try {
                    ProfessionnalAccessorClient.getInstance().getProfessionnal(this.getUniqueKey(), Application.get().getGlobalInstances().getSession(), (ICallback)callback, baseProfessionnal.getId().intValue(), false);
                    return;
                }
                catch (CannotConnectToServerException cannotConnectToServerException) {
                    MessageUtil.cannotConnectToServerExceptionMsg();
                    if (callback == null || callback.killed()) return;
                    callback.kill();
                    return;
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Failed to get professionnal: " + StringUtils.safeToString((Logger)logger, (Object)baseProfessionnal), e);
                    if (callback == null || callback.killed()) return;
                    callback.kill();
                }
            }
            return;
        } else {
            if (!(((EditorInput)this.getEditorInput()).getDataObject() instanceof XProfessionnal)) return;
            this.initializeCompleteDataObject((EditableDataObject)((EditorInput)this.getEditorInput()).getDataObject());
        }
    }

    public void createMyPages() throws PartInitException {
        this.iNextPage = 0;
        this.professionnalEditor = new ProfessionnalEditor(this);
        this.addPage(this.professionnalEditor, this.getEditorInput());
        this.setPageText(this.iNextPage, GENERAL);
        this.setPageImage(this.iNextPage, ResourceGetter.getImage((String)"images/pen.gif"));
        ++this.iNextPage;
    }

    public XProfessionnal getProfessionnal() {
        return (XProfessionnal)this.getPerson();
    }

    public BaseAccessorClient getAccessor() throws CannotConnectToServerException {
        return ProfessionnalAccessorClient.getInstance();
    }

    public boolean isDataDirty() {
        return this.getProfessionnal().isDirty();
    }

    public IVariablesReplacer getVariablesReplacerNewInstance() {
        return new PersonVariableReplacer();
    }

    public Image getEditorTitleImage() {
        return ResourceGetter.getImage((String)"images/stethoscope-icon32.png");
    }

    @Override
    protected boolean showInactivationCondition(boolean forDcd) {
        return true;
    }

    @Override
    protected String getInactiveText() {
        return null;
    }

    @Override
    protected XPatientInactiveRaison getInactiveRaison() {
        return null;
    }

    @Override
    protected void setInactiveRaison(XPatientInactiveRaison r) {
    }
}

