/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.patient;

import ca.infodata.ofys.ui.controls.MyMaskedText;
import ca.infodata.ofys.ui.controls.MyMasks;
import ca.infodata.ofys.ui.controls.form.MyText;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ExpCamText
extends MyMaskedText {
    private Color red;
    private Color originalForeground;
    private LocalDate referenceDate;

    public ExpCamText(Composite parent, FormToolkit formToolkit) {
        super(parent, formToolkit);
        this.init();
    }

    public ExpCamText(Composite parent, int style, FormToolkit formToolkit) {
        super(parent, style, formToolkit);
        this.init();
    }

    public ExpCamText(Composite parent, int style) {
        super(parent, style);
        this.init();
    }

    public ExpCamText(MyText text) {
        super(text);
        this.init();
    }

    private void init() {
        this.referenceDate = LocalDate.today();
        this.red = ResourceGetter.getColor((int)255, (int)0, (int)0);
        this.originalForeground = this.getForeground();
        this.setMask(MyMasks.expirationCam);
        this.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                ExpCamText.this.setRedIfExpired(ExpCamText.this.getText());
            }

            public void focusGained(FocusEvent e) {
                ExpCamText.this.setRedIfExpired(ExpCamText.this.getText());
            }
        });
    }

    public void setRawText(String string) {
        super.setRawText(string);
        this.setRedIfExpired(this.getText());
    }

    public void setRawTextKeepSelection(String string) {
        super.setRawTextKeepSelection(string);
        this.setRedIfExpired(this.getText());
    }

    private void setRedIfExpired(String s) {
        if (StringUtils.isNotBlank((String)s) && s.length() == 4) {
            try {
                int an = Integer.parseInt("20" + s.substring(0, 2));
                int mois = Integer.parseInt(s.substring(2, 4));
                if (mois >= 0 && mois <= 12) {
                    LocalDate date = LocalDate.from((int)1, (int)mois, (int)an);
                    if (this.referenceDate.dayFrom1970 == date.dayFrom1970 || this.referenceDate.after((IPartialDate)date)) {
                        this.setForeground(this.red);
                    } else {
                        this.setForeground(this.originalForeground);
                    }
                }
            }
            catch (Exception exception) {}
        }
    }

    public LocalDate getReferenceDate() {
        return this.referenceDate;
    }

    public void setReferenceDate(LocalDate referenceDate) {
        this.referenceDate = referenceDate;
    }
}

