/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.menu;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseEmployee;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XBaseUser;
import ca.infodata.ofys.data.middle.dataobjects.XImageDecorator;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.ui.controls.ITreeElements;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.person.menu.element.EmployeeElements;
import ca.infodata.ofys.ui.person.menu.element.ProfessionnalElements;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;

public class ListUser
implements ITreeElements {
    private static final Logger logger = Logger.getLogger(ListUser.class.getName());
    private ITreeElements parent;
    private ITreeElements[] child;

    public ListUser(ITreeElements parent) {
        this.parent = parent;
    }

    public Object[] getChildren() {
        if (this.child == null) {
            ArrayList<Object> list = new ArrayList<Object>();
            PersonUiPlugin plugin = PersonUiPlugin.getDefault();
            ArrayList<XBaseUser> users = new ArrayList<XBaseUser>(plugin.getUsers());
            System.out.println("il y a " + users.size() + " users in total.");
            for (XBaseUser user : users) {
                if (user.getIsBlocked()) continue;
                IDataObject profOrEmployee = this.getDataObjectElementFromCacheOrServer(user);
                if (profOrEmployee instanceof XBaseProfessionnal) {
                    list.add((Object)new ProfessionnalElements(this, (XBaseProfessionnal)profOrEmployee));
                    continue;
                }
                if (profOrEmployee instanceof XBaseEmployee) {
                    list.add(new EmployeeElements(this, (XBaseEmployee)profOrEmployee));
                    continue;
                }
                logger.log(Level.INFO, " user " + user.getId() + " has no corresponding prof or employee");
            }
            Collections.sort(list, new Comparator<ITreeElements>(){

                @Override
                public int compare(ITreeElements o1, ITreeElements o2) {
                    return StringUtils.compareAscii((String)o1.getText(), (String)o2.getText());
                }
            });
            this.child = new ITreeElements[list.size()];
            list.toArray(this.child);
        }
        return this.child;
    }

    private IDataObject getDataObjectElementFromCacheOrServer(XBaseUser user) {
        PersonUiPlugin plugin = PersonUiPlugin.getDefault();
        XBaseProfessionnal prof = plugin.getBaseProfessionnalByIdPerson(user.getIdPerson(), false, false);
        if (prof != null) {
            return prof;
        }
        XBaseEmployee employee = plugin.getBaseEmployeeByIdPerson(user.getIdPerson(), false, false);
        if (employee != null) {
            return employee;
        }
        prof = plugin.getBaseProfessionnalByIdPerson(user.getIdPerson(), false, true);
        if (prof != null) {
            return prof;
        }
        employee = plugin.getBaseEmployeeByIdPerson(user.getIdPerson(), false, true);
        if (employee != null) {
            return employee;
        }
        return null;
    }

    public Object getParent() {
        return this.parent;
    }

    public boolean hasChildren() {
        return true;
    }

    public String getText() {
        return Messages.getString((String)"USERS", (String[])new String[0]);
    }

    public String getTooltipText() {
        return this.getText();
    }

    public Image getImage() {
        return ResourceGetter.getImage((String)"images/person_lock.gif");
    }

    public String getEditorClass() {
        return null;
    }

    public IEditorInput getEditorInput() {
        return null;
    }

    public XImageDecorator getDecorators() {
        return XImageDecorator.NULL_DECORATORS;
    }

    public void setParent(ITreeElements parent) {
        this.parent = parent;
    }

    public ITreeElements getElementToRefresh() {
        return this;
    }

    public void showContextMenu(Control control) {
    }

    public int hashCode() {
        return new String(String.valueOf(this.parent.hashCode()) + " " + this.getClass().getName()).hashCode();
    }

    public boolean equals(Object toCompare) {
        boolean ret = false;
        if (toCompare instanceof ListUser && toCompare.hashCode() == this.hashCode()) {
            ret = true;
        }
        return ret;
    }

    public void doKeyListener(Control control, KeyEvent ke) {
    }

    public int getChildrenNumberForPastille() {
        return 0;
    }
}

