/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.address2;

import ca.infodata.ofys.city.City;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XCity;
import ca.infodata.ofys.data.middle.dataobjects.XCompletionProposalType;
import ca.infodata.ofys.data.middle.dataobjects.XCountry;
import ca.infodata.ofys.data.middle.dataobjects.XProvince;
import ca.infodata.ofys.ui.controls.ControlDecorator;
import ca.infodata.ofys.ui.controls.EditorModifyListener;
import ca.infodata.ofys.ui.controls.IBaseEditor;
import ca.infodata.ofys.ui.controls.IBaseEditor2;
import ca.infodata.ofys.ui.controls.MyMaskedText;
import ca.infodata.ofys.ui.controls.MyMasks;
import ca.infodata.ofys.ui.controls.PostalCodeText;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.form.combo.proposal.CityProposal;
import ca.infodata.ofys.ui.controls.form.combo.proposal.CityProposalProvider;
import ca.infodata.ofys.ui.controls.form.combo.proposal.CityText;
import ca.infodata.ofys.ui.controls.form.combo.proposal.CountryText;
import ca.infodata.ofys.ui.controls.form.combo.proposal.IAddress;
import ca.infodata.ofys.ui.controls.form.combo.proposal.ProvinceText;
import ca.infodata.ofys.ui.controls.template.completion.TemplateAssistText;
import ca.infodata.ofys.ui.library.LibPlugin;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.util1.StringUtils;
import java.util.List;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class AddressControl2
extends Composite {
    public static final int STANDARD_TEXT_LIMIT = 100;
    protected ProvinceText cmbProvince;
    protected CityText cmbCity;
    protected CountryText cmbCountry;
    protected MyMaskedText txtStreet;
    protected PostalCodeText txtPostalCode;
    protected TemplateAssistText txtNote;
    protected MyLabel lblStreet;
    protected MyLabel lblCity;
    protected MyLabel lblCountry;
    protected MyLabel lblPostalCode;
    protected MyLabel lblProvince;
    protected MyLabel lblNote;
    private IAddress address;
    private IBaseEditor parentEditor;

    public AddressControl2(Composite parent, FormToolkit toolkit, IBaseEditor parentEditor) {
        super(parent, 0);
        this.parentEditor = parentEditor;
        this.createMyControl(this, toolkit);
    }

    public void showCurrentAddress() {
        IAddress address = this.getAddress();
        if (address == null) {
            this.txtStreet.clear();
            this.cmbCountry.selectNone();
            this.cmbCity.clear();
            this.cmbProvince.selectNone();
            this.setPostalCode(null);
            this.txtNote.setText(null);
            this.txtPostalCode.getMaskedText().setEnabled(false);
            this.txtStreet.setEnabled(false);
            this.cmbCountry.setEnabled(false);
            this.cmbCity.setEnabled(false);
            this.cmbProvince.setEnabled(false);
            this.txtNote.setEnabled(false);
        } else {
            this.txtStreet.setEnabled(true);
            this.cmbCountry.setEnabled(true);
            this.cmbCity.setEnabled(true);
            this.cmbProvince.setEnabled(true);
            this.txtPostalCode.getMaskedText().setEnabled(true);
            this.txtNote.setEnabled(true);
            this.setPostalCode(address);
            this.txtStreet.setRawText(address.getStreet());
            if ((address.getCountry() == null || StringUtils.isBlank((CharSequence)address.getCountry().getName())) && StringUtils.isBlank((CharSequence)address.getStreet())) {
                this.cmbCountry.select(new XCountry("CANADA"));
            } else {
                this.cmbCountry.select(address.getCountry());
            }
            String city = address.getCity() == null ? null : address.getCity().getName();
            this.cmbCity.setText(city);
            if (this.cmbProvince.contains(address.getProvince())) {
                this.cmbProvince.select(address.getProvince());
            } else {
                String province = address.getProvince() == null ? null : address.getProvince().getName();
                this.cmbProvince.setText(province);
            }
            this.txtNote.setText(address.getNote());
        }
    }

    private void setPostalCode(IAddress address) {
        if (address == null) {
            this.txtPostalCode.setCountry(null);
            this.txtPostalCode.setText("");
        } else {
            String postalCode = address.getPostalCode();
            XCountry country = address.getCountry();
            this.txtPostalCode.setCountry(country == null ? null : country.getName());
            this.txtPostalCode.setText(postalCode == null ? "" : postalCode);
        }
    }

    public void setFirstFocus() {
        this.txtStreet.setFocus();
    }

    public void createMyControl(Composite parent, FormToolkit toolkit) {
        this.createControls(parent, toolkit);
        this.txtStreet.addModifyListener((ModifyListener)new EditorModifyListener((IBaseEditor2)this.getParentEditor()){

            public void edited(Event e) {
                AddressControl2.this.getAddress().setStreet(AddressControl2.this.txtStreet.getText());
            }
        });
        this.txtStreet.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.text = e.text.toUpperCase();
            }
        });
        this.txtPostalCode.getMaskedText().addModifyListener((ModifyListener)new EditorModifyListener((IBaseEditor2)this.getParentEditor()){

            public void edited(Event e) {
                AddressControl2.this.getAddress().setPostalCode(AddressControl2.this.txtPostalCode.getText());
            }
        });
        final CityProposalProvider cityByPostalCodeProposalProvider = new CityProposalProvider(){

            protected List<City> findCities(String contents) throws Exception {
                return LibPlugin.getDefault().getCityIndex().findCitiesByPostalCode(contents, 100);
            }
        };
        this.txtPostalCode.getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                IContentProposal[] proposals;
                String cityText;
                String actualValue = AddressControl2.this.txtPostalCode.getText();
                if (AddressControl2.this.cmbCountry.getText().equals("CANADA") && !StringUtils.isBlank((CharSequence)actualValue) && actualValue.length() >= 6 && StringUtils.isBlank((CharSequence)(cityText = AddressControl2.this.cmbCity.getText())) && (proposals = cityByPostalCodeProposalProvider.getProposals(actualValue, 0)) != null && proposals.length > 0) {
                    e.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            (this).AddressControl2.this.cmbCity.setTempProposals(proposals);
                        }
                    });
                }
            }
        });
        this.cmbCity.getCityContentProposal().getContentProposalAdapter().addContentProposalListener(new IContentProposalListener(){

            public void proposalAccepted(IContentProposal proposal) {
                CityProposal c = (CityProposal)proposal;
                if (AddressControl2.this.getAddress() != null) {
                    AddressControl2.this.getAddress().setCity(new XCity(c.getContent().toUpperCase()));
                    AddressControl2.this.getAddress().setCountry(new XCountry("CANADA"));
                    AddressControl2.this.getAddress().setProvince(new XProvince(c.getCity().province.toUpperCase()));
                    AddressControl2.this.showCurrentAddress();
                }
            }
        });
        this.cmbCity.addModifyListener((ModifyListener)new EditorModifyListener((IBaseEditor2)this.getParentEditor(), 24){

            public void edited(Event e) {
                if (StringUtils.isBlank((CharSequence)AddressControl2.this.cmbCity.getText())) {
                    AddressControl2.this.getAddress().setCity(null);
                } else {
                    AddressControl2.this.getAddress().setCity(new XCity(AddressControl2.this.cmbCity.getText()));
                }
            }
        });
        EditorModifyListener countryListener = new EditorModifyListener((IBaseEditor2)this.getParentEditor()){

            public void edited(Event e) {
                AddressControl2.this.txtPostalCode.setCountry(AddressControl2.this.cmbCountry.getText());
                XCountry country = AddressControl2.this.cmbCountry.getSelection2();
                if (country == null) {
                    country = new XCountry();
                    country.setName(AddressControl2.this.cmbCountry.getText());
                }
                AddressControl2.this.getAddress().setCountry(country);
            }
        };
        this.cmbCountry.addListener(24, (Listener)countryListener);
        EditorModifyListener provinceListener = new EditorModifyListener((IBaseEditor2)this.getParentEditor()){

            public void edited(Event e) {
                XProvince province = AddressControl2.this.cmbProvince.getSelection2();
                if (province == null) {
                    province = new XProvince();
                    province.setName(AddressControl2.this.cmbProvince.getText());
                }
                AddressControl2.this.getAddress().setProvince(province);
            }
        };
        this.cmbProvince.addListener(13, (Listener)provinceListener);
        this.cmbProvince.addListener(24, (Listener)provinceListener);
        this.txtNote.getStyledText().addModifyListener((ModifyListener)new EditorModifyListener((IBaseEditor2)this.getParentEditor()){

            public void edited(Event e) {
                if (AddressControl2.this.txtNote.getText().length() > 32671) {
                    AddressControl2.this.txtNote.setText(AddressControl2.this.txtNote.getText().substring(0, 32671));
                }
                AddressControl2.this.getAddress().setNote(AddressControl2.this.txtNote.getText());
            }
        });
        this.doLayout(parent, toolkit);
        toolkit.adapt(parent);
    }

    private void createControls(Composite parent, FormToolkit toolkit) {
        this.txtStreet = new MyMaskedText((Composite)this, 0, toolkit);
        this.txtStreet.setValidStyle(2);
        this.txtStreet.setMask(MyMasks.standardText);
        this.cmbCity = new CityText((Composite)this, 0, toolkit);
        this.txtPostalCode = new PostalCodeText((Composite)this, 0, toolkit);
        this.cmbProvince = new ProvinceText((Composite)this, 0, toolkit);
        this.cmbCountry = new CountryText((Composite)this, 0, toolkit);
        this.cmbCountry.selectCanada();
        this.txtNote = new TemplateAssistText((Composite)this, 64, toolkit);
        this.txtNote.setType(XCompletionProposalType.ADDRESS_NOTE);
        ControlDecorator.decorateWithEditProposal((TemplateAssistText)this.txtNote, (int)131200);
        parent.setTabList(new Control[]{this.txtStreet.getControl(), this.cmbCity.getControl(), this.cmbProvince.getControl(), this.txtPostalCode.getControl(), this.cmbCountry.getControl(), this.txtNote.getControl()});
    }

    protected void doLayout(Composite parent, FormToolkit toolkit) {
        this.lblStreet = new MyLabel(parent, Messages.getString((String)"RUE", (String[])new String[0]), 0, toolkit);
        this.lblCity = new MyLabel(parent, Messages.getString((String)"VILLE", (String[])new String[0]), 0, toolkit);
        this.lblCountry = new MyLabel(parent, Messages.getString((String)"PAYS", (String[])new String[0]), 0, toolkit);
        this.lblPostalCode = new MyLabel(parent, Messages.getString((String)"CODE_POSTAL", (String[])new String[0]), 0, toolkit);
        this.lblProvince = new MyLabel(parent, Messages.getString((String)"PROVINCE_ETAT", (String[])new String[0]), 0, toolkit);
        this.lblNote = new MyLabel(parent, Messages.getString((String)"NOTE", (String[])new String[0]), 0, toolkit);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        layout.spacing = 5;
        parent.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        this.lblStreet.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblStreet.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.txtStreet.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtStreet.getControl());
        data.left = new FormAttachment(0);
        this.lblCity.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblCity.getControl());
        data.left = new FormAttachment(0);
        data.width = 200 + ResourceGetter.getFontSizeIncrement() * 10;
        this.cmbCity.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtStreet.getControl());
        data.left = new FormAttachment(this.cmbCity.getControl());
        this.lblProvince.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblProvince.getControl());
        data.left = new FormAttachment(this.lblProvince.getControl(), 0, 16384);
        data.width = 100 + ResourceGetter.getFontSizeIncrement() * 10;
        this.cmbProvince.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtStreet.getControl());
        data.left = new FormAttachment(this.cmbProvince.getControl());
        this.lblPostalCode.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblPostalCode.getControl());
        data.left = new FormAttachment(this.lblPostalCode.getControl(), 0, 16384);
        data.right = new FormAttachment(this.lblPostalCode.getControl(), 0, 131072);
        this.txtPostalCode.getMaskedText().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtStreet.getControl());
        data.left = new FormAttachment(this.txtPostalCode.getControl());
        this.lblCountry.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblCountry.getControl());
        data.left = new FormAttachment(this.lblCountry.getControl(), 0, 16384);
        data.width = 100 + ResourceGetter.getFontSizeIncrement() * 10;
        this.cmbCountry.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtStreet.getControl());
        data.left = new FormAttachment(this.cmbCountry.getControl());
        this.lblNote.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblNote.getControl());
        data.left = new FormAttachment(this.lblNote.getControl(), 0, 16384);
        data.bottom = new FormAttachment(this.cmbProvince.getControl(), 0, 1024);
        data.right = new FormAttachment(100);
        this.txtNote.getControl().setLayoutData((Object)data);
    }

    protected IBaseEditor getParentEditor() {
        return this.parentEditor;
    }

    public IAddress getAddress() {
        return this.address;
    }

    public void setAddress(IAddress address) {
        this.address = address;
    }
}

