/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XPerson;
import ca.infodata.ofys.data.middle.dataobjects.patient.XPatientInactiveRaison;
import ca.infodata.ofys.ui.person.BasePersonControl;
import ca.infodata.ofys.ui.person.PersonMultiEditor;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PersonControl
extends BasePersonControl {
    private static final String DESACTIVE = Messages.getString((String)"PersonControl.DESACTIVE", (String[])new String[0]);
    private static final String REACTIVE = Messages.getString((String)"PersonControl.REACTIVE", (String[])new String[0]);
    private static final String DCD = Messages.getString((String)"PersonControl.DCD", (String[])new String[0]);
    private static final String NON_DCD = Messages.getString((String)"PersonControl.NON_DCD", (String[])new String[0]);

    public PersonControl(Composite parent, FormToolkit toolkit, PersonMultiEditor parentEditor) {
        super(parent, toolkit, parentEditor);
    }

    public void setAgeLabel(String label) {
        this.lblAge.setText(label);
    }

    @Override
    public void showCurrentPerson() {
        System.out.println("SHOW CURRENT PERSON");
        XPerson person = this.getParentEditor().getPerson();
        if (person == null) {
            this.txtTitle.setText(null);
            this.txtLastName.setText(null);
            this.txtFirstName.setText(null);
            this.txtMidInit.setText(null);
            this.txtBirthDate.setDate(null);
            this.lblAge.setText(Messages.getString((String)"AGE_", (String[])new String[0]));
            this.btnUnknown.setSelection(false);
            this.btnMale.setSelection(false);
            this.btnFemale.setSelection(false);
            this.cmbRace.select(-1);
            this.cmbLanguageCode.select(-1);
            this.cmbMaritalStatus.select(-1);
            this.cmbCitizenship.selectNone();
            if (this.btnToggleIsActive != null) {
                this.btnToggleIsActive.setText(DESACTIVE);
            }
            if (this.btnToggleDcd != null) {
                this.btnToggleDcd.setText(DCD);
            }
            if (this.lblNotActiveInfo != null) {
                String text = this.getParentEditor().getInactiveText();
                this.lblNotActiveInfo.setText(text == null ? "" : text);
            }
            this.txtNote.setText(null);
            this.txtNoteVariablesReplacer.setDataObject(null);
            this.cmdEditCompletionProposal.setEnabled(false);
            this.sectionPersonSupp.setEnabled(false);
            this.txtTitle.setEnabled(false);
            this.txtLastName.setEnabled(false);
            this.txtFirstName.setEnabled(false);
            this.txtMidInit.setEnabled(false);
            this.txtBirthDate.getControl().setEnabled(false);
            this.lblAge.setEnabled(false);
            this.btnUnknown.setEnabled(false);
            this.btnMale.setEnabled(false);
            this.btnFemale.setEnabled(false);
            this.cmbRace.setEnabled(false);
            this.cmbLanguageCode.setEnabled(false);
            this.cmbMaritalStatus.setEnabled(false);
            this.cmbCitizenship.setEnabled(false);
            if (this.btnToggleIsActive != null) {
                this.btnToggleIsActive.setEnabled(false);
            }
            if (this.btnToggleDcd != null) {
                this.btnToggleDcd.setEnabled(false);
            }
            this.txtNote.getControl().setEnabled(false);
        } else {
            this.cmdEditCompletionProposal.setEnabled(true);
            this.sectionPersonSupp.setEnabled(true);
            this.txtTitle.setEnabled(true);
            this.txtLastName.setEnabled(true);
            this.txtFirstName.setEnabled(true);
            this.txtMidInit.setEnabled(true);
            this.txtBirthDate.getControl().setEnabled(true);
            this.lblAge.setEnabled(true);
            this.btnUnknown.setEnabled(true);
            this.btnMale.setEnabled(true);
            this.btnFemale.setEnabled(true);
            this.cmbRace.setEnabled(true);
            this.cmbLanguageCode.setEnabled(true);
            this.cmbMaritalStatus.setEnabled(true);
            this.cmbCitizenship.setEnabled(true);
            if (this.btnToggleIsActive != null) {
                this.btnToggleIsActive.setEnabled(true);
            }
            if (this.btnToggleDcd != null) {
                this.btnToggleDcd.setEnabled(true);
            }
            if (this.btnToggleIsActive != null) {
                this.btnToggleIsActive.setText(Boolean.TRUE.equals(this.getParentEditor().getPerson().getIsDeleted()) ? REACTIVE : DESACTIVE);
            }
            if (this.btnToggleDcd != null) {
                this.btnToggleDcd.setText(XPatientInactiveRaison.DCD.equals((Object)this.getParentEditor().getInactiveRaison()) ? NON_DCD : DCD);
            }
            if (this.lblNotActiveInfo != null) {
                String text = this.getParentEditor().getInactiveText();
                this.lblNotActiveInfo.setText(text == null ? "" : text);
            }
            this.txtNote.getControl().setEnabled(true);
            this.txtTitle.setText(person.getTitle());
            this.txtLastName.setText(person.getLastName());
            this.txtFirstName.setText(person.getFirstName());
            this.txtMidInit.setText(person.getMidInitial());
            this.txtBirthDate.setDate((IPartialDate)person.getBirthDate());
            if (person.getGender().equals("M")) {
                this.btnUnknown.setSelection(false);
                this.btnMale.setSelection(true);
                this.btnFemale.setSelection(false);
            } else if (person.getGender().equals("F")) {
                this.btnUnknown.setSelection(false);
                this.btnMale.setSelection(false);
                this.btnFemale.setSelection(true);
            } else {
                this.btnUnknown.setSelection(true);
                this.btnMale.setSelection(false);
                this.btnFemale.setSelection(false);
            }
            if (person.getRace() == null) {
                this.cmbRace.select(-1);
            } else {
                this.cmbRace.select(person.getRace().intValue());
            }
            if (person.getLanguageCode() == null) {
                this.cmbLanguageCode.select(-1);
            } else {
                this.cmbLanguageCode.select(person.getLanguageCode().intValue());
            }
            if (person.getMaritalStatus() == null) {
                this.cmbMaritalStatus.select(-1);
            } else {
                this.cmbMaritalStatus.select(person.getMaritalStatus().intValue());
            }
            this.cmbCitizenship.select(person.getCitizenship());
            this.txtNote.setText(person.getNote());
            this.txtNoteVariablesReplacer.setDataObject((Object)person);
            this.txtNoteVariablesReplacer.setToday(LocalDate.today());
        }
    }

    public void setFirstFocus() {
        this.txtLastName.setFocus();
    }
}

