/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.io.pcx;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import org.nightlabs.io.pcx.ImageInputStream;
import org.nightlabs.io.pcx.PCXHeader;
import org.nightlabs.io.pcx.PCXReader;
import org.nightlabs.util.Binary;

public class PCXImageReader
extends ImageReader {
    private PCXReader pcxReader = null;
    private PCXHeader header = null;
    private InputStream inputStream = null;

    public PCXImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IOException {
        return 1;
    }

    @Override
    public int getWidth(int imageIndex) throws IOException {
        if (imageIndex == 0 && this.header != null) {
            return this.header.getWidth();
        }
        return 0;
    }

    @Override
    public int getHeight(int imageIndex) throws IOException {
        if (imageIndex == 0 && this.header != null) {
            return this.header.getHeight();
        }
        return 0;
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        return null;
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        return null;
    }

    protected PCXReader getPCXReader() {
        if (this.pcxReader == null) {
            this.pcxReader = new PCXReader();
        }
        return this.pcxReader;
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        if (imageIndex == 0 && this.getInputStream() != null) {
            return this.getPCXReader().read(this.getInputStream());
        }
        return null;
    }

    @Override
    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        super.setInput(input, seekForwardOnly, ignoreMetadata);
        this.inputStream = null;
    }

    public static PCXHeader getHeader(InputStream in) {
        try {
            BufferedInputStream bin = new BufferedInputStream(in);
            bin.mark(128);
            Binary binary = new Binary(in);
            PCXHeader header = new PCXHeader(binary);
            bin.reset();
            return header;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected InputStream getInputStream() {
        if (this.inputStream == null && this.input != null) {
            if (this.input instanceof javax.imageio.stream.ImageInputStream) {
                javax.imageio.stream.ImageInputStream imageInpuStream = (javax.imageio.stream.ImageInputStream)this.input;
                this.inputStream = new ImageInputStream(imageInpuStream);
            } else if (this.input instanceof InputStream) {
                this.inputStream = (InputStream)this.input;
            }
        }
        return this.inputStream;
    }
}

