/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.nightlabs.io.DataBuffer;

public class DataBufferInputStream
extends InputStream {
    DataBuffer dataBuffer;
    protected long markedReadPos = 0L;
    protected long dataReadPos = 0L;
    protected BufferedInputStream in = null;
    protected boolean closed = false;
    protected int markReadLimit = 0;

    protected DataBufferInputStream(DataBuffer _dataBuffer) {
        this.dataBuffer = _dataBuffer;
    }

    @Override
    public int available() throws IOException {
        if (this.in != null) {
            return this.in.available();
        }
        long avl = this.dataBuffer.length - this.dataReadPos;
        if (avl <= 0L) {
            return 0;
        }
        if (avl > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)avl;
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        this.closed = true;
    }

    @Override
    public void mark(int readlimit) {
        if (this.in != null) {
            this.in.mark(readlimit);
        }
        this.markReadLimit = readlimit;
        this.markedReadPos = this.dataReadPos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    protected void checkMode() throws IOException {
        if (this.in == null && this.dataBuffer.mode == 1) {
            this.in = new BufferedInputStream(this.dataBuffer.createFileInputStream());
            if (this.markedReadPos > 0L) {
                this.in.skip(this.markedReadPos);
                this.in.mark(this.markReadLimit);
            }
            this.in.skip(this.dataReadPos - this.markedReadPos);
        }
    }

    @Override
    public int read() throws IOException {
        this.checkMode();
        if (this.closed) {
            throw new IOException("InputStream has already been closed!");
        }
        if (this.in != null) {
            int i = this.in.read();
            if (i >= 0) {
                ++this.dataReadPos;
            }
            return i;
        }
        if (this.dataReadPos > 0x7FFFFFF5L) {
            throw new IllegalStateException("dataReadPos is too big! Should have switched to file mode earlier!");
        }
        if (this.dataReadPos < this.dataBuffer.length) {
            return this.dataBuffer.data[(int)this.dataReadPos++] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int dr;
        this.checkMode();
        if (this.closed) {
            throw new IOException("InputStream has already been closed!");
        }
        if (this.in != null) {
            dr = this.in.read(b, off, len);
        } else {
            if (this.dataReadPos + (long)len > this.dataBuffer.length) {
                len = (int)(this.dataBuffer.length - this.dataReadPos);
            }
            if (this.dataReadPos > 0x7FFFFFF5L) {
                throw new IllegalStateException("dataReadPos is too big! Should have switched to file mode earlier!");
            }
            if (len > 0) {
                System.arraycopy(this.dataBuffer.data, (int)this.dataReadPos, b, off, len);
                dr = len;
            } else {
                dr = -1;
            }
        }
        if (dr > 0) {
            this.dataReadPos += (long)dr;
        }
        return dr;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public void reset() throws IOException {
        this.checkMode();
        if (this.in != null) {
            this.in.reset();
        }
        this.dataReadPos = this.markedReadPos;
    }

    @Override
    public long skip(long n) throws IOException {
        this.checkMode();
        if (this.in != null) {
            n = this.in.skip(n);
        } else {
            long max = this.dataBuffer.length - this.dataReadPos;
            if (n > max) {
                n = max;
            }
            this.dataReadPos += n;
        }
        return n;
    }
}

