/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;
import org.nightlabs.config.ConfigModule;
import org.nightlabs.util.RWLockable;

public class CfModList<E>
extends ArrayList<E>
implements RWLockable {
    private static final Logger logger = Logger.getLogger(CfModList.class);
    protected ConfigModule ownerCfMod = null;

    public CfModList() {
    }

    public CfModList(Collection c) {
        super(c);
    }

    public CfModList(ConfigModule ownerCfMod) {
        this.ownerCfMod = ownerCfMod;
    }

    public CfModList(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        this.acquireWriteLock();
        try {
            super.removeRange(fromIndex, toIndex);
            this.setChanged();
        }
        finally {
            this.releaseLock();
        }
    }

    protected void setChanged() {
        if (this.ownerCfMod == null) {
            logger.warn((Object)"Owner ConfigModule is null! Cannot notify change!");
            return;
        }
        this.ownerCfMod.setChanged();
    }

    @Override
    public void acquireReadLock() {
        if (this.ownerCfMod == null) {
            logger.warn((Object)"Owner ConfigModule is null! Cannot lock! Operation is not thread-safe!!!");
            return;
        }
        this.ownerCfMod.acquireReadLock();
    }

    @Override
    public void acquireWriteLock() {
        if (this.ownerCfMod == null) {
            logger.warn((Object)"Owner ConfigModule is null! Cannot lock! Operation is not thread-safe!!!");
            return;
        }
        this.ownerCfMod.acquireReadLock();
    }

    @Override
    public boolean add(E o) {
        this.acquireWriteLock();
        try {
            boolean res = super.add(o);
            this.setChanged();
            boolean bl = res;
            return bl;
        }
        finally {
            this.releaseLock();
        }
    }

    @Override
    public void add(int index, E element) {
        this.acquireWriteLock();
        try {
            super.add(index, element);
            this.setChanged();
        }
        finally {
            this.releaseLock();
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.acquireWriteLock();
        try {
            boolean res = super.addAll(c);
            this.setChanged();
            boolean bl = res;
            return bl;
        }
        finally {
            this.releaseLock();
        }
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.acquireWriteLock();
        try {
            boolean res = super.addAll(index, c);
            this.setChanged();
            boolean bl = res;
            return bl;
        }
        finally {
            this.releaseLock();
        }
    }

    @Override
    public void clear() {
        this.acquireWriteLock();
        try {
            super.clear();
            this.setChanged();
        }
        finally {
            this.releaseLock();
        }
    }

    @Override
    public Object clone() {
        this.acquireReadLock();
        try {
            Object object = super.clone();
            return object;
        }
        finally {
            this.releaseLock();
        }
    }

    @Override
    public boolean contains(Object elem) {
        this.acquireReadLock();
        try {
            boolean bl = super.contains(elem);
            return bl;
        }
        finally {
            this.releaseLock();
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.acquireReadLock();
        try {
            boolean bl = super.containsAll(c);
            return bl;
        }
        finally {
            this.releaseLock();
        }
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        this.acquireReadLock();
        try {
            super.ensureCapacity(minCapacity);
        }
        finally {
            this.releaseLock();
        }
    }

    @Override
    public boolean equals(Object o) {
        this.acquireReadLock();
        try {
            boolean bl = super.equals(o);
            return bl;
        }
        finally {
            this.releaseLock();
        }
    }

    @Override
    public E get(int index) {
        this.acquireReadLock();
        try {
            Object e = super.get(index);
            return e;
        }
        finally {
            this.releaseLock();
        }
    }

    public ConfigModule getOwnerCfMod() {
        return this.ownerCfMod;
    }

    @Override
    public int hashCode() {
        this.acquireReadLock();
        try {
            int n = super.hashCode();
            return n;
        }
        finally {
            this.releaseLock();
        }
    }

    @Override
    public int indexOf(Object elem) {
        this.acquireReadLock();
        try {
            int n = super.indexOf(elem);
            return n;
        }
        finally {
            this.releaseLock();
        }
    }

    @Override
    public boolean isEmpty() {
        this.acquireReadLock();
        try {
            boolean bl = super.isEmpty();
            return bl;
        }
        finally {
            this.releaseLock();
        }
    }

    @Override
    public Iterator<E> iterator() {
        return super.iterator();
    }

    @Override
    public int lastIndexOf(Object elem) {
        this.acquireReadLock();
        try {
            int n = super.lastIndexOf(elem);
            return n;
        }
        finally {
            this.releaseLock();
        }
    }

    @Override
    public ListIterator<E> listIterator() {
        return super.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return super.listIterator(index);
    }

    @Override
    public void releaseLock() {
        if (this.ownerCfMod == null) {
            logger.warn((Object)"Owner ConfigModule is null! Cannot lock! Operation is not thread-safe!!!");
            return;
        }
        this.ownerCfMod.releaseLock();
    }

    @Override
    public E remove(int index) {
        this.acquireWriteLock();
        try {
            Object res = super.remove(index);
            this.setChanged();
            Object e = res;
            return e;
        }
        finally {
            this.releaseLock();
        }
    }

    @Override
    public boolean remove(Object o) {
        this.acquireWriteLock();
        try {
            boolean res = super.remove(o);
            this.setChanged();
            boolean bl = res;
            return bl;
        }
        finally {
            this.releaseLock();
        }
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.acquireWriteLock();
        try {
            boolean res = super.removeAll(c);
            this.setChanged();
            boolean bl = res;
            return bl;
        }
        finally {
            this.releaseLock();
        }
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.acquireWriteLock();
        try {
            boolean res = super.retainAll(c);
            this.setChanged();
            boolean bl = res;
            return bl;
        }
        finally {
            this.releaseLock();
        }
    }

    @Override
    public E set(int index, E element) {
        this.acquireWriteLock();
        try {
            E res = super.set(index, element);
            this.setChanged();
            E e = res;
            return e;
        }
        finally {
            this.releaseLock();
        }
    }

    public void setOwnerCfMod(ConfigModule ownerCfMod) {
        this.ownerCfMod = ownerCfMod;
    }

    @Override
    public int size() {
        this.acquireReadLock();
        try {
            int n = super.size();
            return n;
        }
        finally {
            this.releaseLock();
        }
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        this.acquireReadLock();
        try {
            List list = super.subList(fromIndex, toIndex);
            return list;
        }
        finally {
            this.releaseLock();
        }
    }

    @Override
    public Object[] toArray() {
        this.acquireReadLock();
        try {
            Object[] objectArray = super.toArray();
            return objectArray;
        }
        finally {
            this.releaseLock();
        }
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.acquireReadLock();
        try {
            T[] TArray = super.toArray(a);
            return TArray;
        }
        finally {
            this.releaseLock();
        }
    }

    @Override
    public String toString() {
        this.acquireReadLock();
        try {
            String string = super.toString();
            return string;
        }
        finally {
            this.releaseLock();
        }
    }

    @Override
    public void trimToSize() {
        this.acquireWriteLock();
        try {
            super.trimToSize();
            this.setChanged();
        }
        finally {
            this.releaseLock();
        }
    }
}

