/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.library.printer;

import ca.infodata.ofys.ui.library.printer.IPrinterList;
import ca.infodata.ofys.ui.library.printer.sun.print.MyPrintServiceLookup;
import java.awt.print.PrinterException;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.print.PrintService;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;

public class PrinterListAwtFix
implements IPrinterList {
    private static final Logger logger = Logger.getLogger(PrinterListAwtFix.class.getName());
    private final Object lock = new Object();
    private volatile boolean loadingPrinterList;
    private String[] printersCache = null;
    private final MyPrintServiceLookup printServiceLookup = new MyPrintServiceLookup();

    @Override
    public synchronized void loadPrinterListAsync() {
        if (!this.loadingPrinterList) {
            this.loadPrinterList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadPrinterList() {
        Object object = this.lock;
        synchronized (object) {
            logger.info("loading printer list");
            this.loadingPrinterList = true;
            try {
                PrinterData[] printerList = Printer.getPrinterList();
                Object[] list = new String[printerList.length];
                int i = 0;
                while (i < printerList.length) {
                    list[i] = PrinterListAwtFix.fixName(printerList[i].name);
                    ++i;
                }
                Arrays.sort(list);
                this.printersCache = list;
                this.printServiceLookup.clearCache();
            }
            finally {
                this.loadingPrinterList = false;
            }
        }
    }

    private static String fixName(String name) {
        return name.replace("_", " ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getPrinters() {
        Object object = this.lock;
        synchronized (object) {
            block4: {
                if (this.printersCache != null) break block4;
                return null;
            }
            return Arrays.copyOf(this.printersCache, this.printersCache.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDefaultPrinter() {
        Object object = this.lock;
        synchronized (object) {
            String def = null;
            PrinterData data = Printer.getDefaultPrinterData();
            if (data == null) {
                String[] printers = this.getPrinters();
                if (printers != null && printers.length > 0) {
                    def = printers[0];
                }
            } else {
                def = PrinterListAwtFix.fixName(data.name);
            }
            return def;
        }
    }

    @Override
    public PrintService getPrintService(String name) throws PrinterException {
        return this.printServiceLookup.getService(name);
    }
}

