/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.library.log;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.LoggingMXBean;

public class LoggerTree {
    private static final Logger logger0 = Logger.getLogger("ca.infodata.ofys");
    private static final Logger logger1 = Logger.getLogger("ca.infodata.ofys2");
    private static final Logger logger2 = Logger.getLogger("ca.infodata.ofys3");
    private static final Logger logger3 = Logger.getLogger("ca.infodata.ofys4");
    private static final Logger logger4 = Logger.getLogger("ca.infodata.ofys4");
    private static int level;

    public static Node getRootNode() {
        LoggingMXBean loggingMXBean = LogManager.getLoggingMXBean();
        List<String> loggerNames = loggingMXBean.getLoggerNames();
        Collections.sort(loggerNames, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                String[] o2s;
                if (o1.equals("")) {
                    return -1;
                }
                if (o2.equals("")) {
                    return 1;
                }
                String[] o1s = o1.split("\\.");
                if (o1s.length - (o2s = o2.split("\\.")).length == 0) {
                    return o1.compareTo(o2);
                }
                return o1s.length - o2s.length;
            }
        });
        HashMap<String, Node> tree = new HashMap<String, Node>();
        for (String name : loggerNames) {
            Node parentNode;
            if (tree.containsKey(name)) continue;
            Logger logger = Logger.getLogger(name);
            Node node = new Node();
            node.logger = logger;
            tree.put(name, node);
            Logger parent = logger.getParent();
            if (parent == null) continue;
            node.parent = parentNode = (Node)tree.get(parent.getName());
            if (parentNode == null) continue;
            parentNode.children.add(node);
        }
        Node root = (Node)tree.get("");
        return root;
    }

    public static void main(String[] args) {
        LoggerTree.printNode(LoggerTree.getRootNode());
    }

    private static void printNode(Node node) {
        char[] tab = new char[level];
        Arrays.fill(tab, '-');
        String name = node.logger.getName();
        if (name.length() == 0) {
            System.out.println(String.valueOf(String.valueOf(tab)) + "root");
        } else {
            System.out.println(String.valueOf(String.valueOf(tab)) + name);
        }
        ++level;
        for (Node child : node.children) {
            LoggerTree.printNode(child);
        }
        --level;
    }

    public static enum ELevel {
        ALL(Level.ALL),
        OFF(Level.OFF),
        SEVERE(Level.SEVERE),
        WARNING(Level.WARNING),
        INFO(Level.INFO),
        FINE(Level.FINE),
        FINER(Level.FINER),
        FINEST(Level.FINEST),
        NONE(null);

        public final Level level;
        private static final String[] svalues;

        static {
            ELevel[] values = ELevel.values();
            svalues = new String[values.length];
            int i = 0;
            while (i < svalues.length) {
                ELevel.svalues[i] = values[i].toString();
                ++i;
            }
        }

        private ELevel(Level level) {
            this.level = level;
        }

        public static String[] svalues() {
            String[] s = new String[svalues.length];
            System.arraycopy(svalues, 0, s, 0, svalues.length);
            return s;
        }

        public static ELevel valueOf(String string) {
            return Enum.valueOf(ELevel.class, string);
        }
    }

    public static class Node {
        Node parent;
        Logger logger;
        final List<Node> children = new ArrayList<Node>();

        public String toString() {
            return this.logger.getName();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Node) {
                String name = this.logger == null ? "" : this.logger.getName();
                String objName = ((Node)obj).logger == null ? "" : ((Node)obj).logger.getName();
                return name.equals(objName);
            }
            return false;
        }

        public Level getLevel() {
            Level level = this.logger.getLevel();
            if (level != null) {
                return level;
            }
            if (this.parent != null) {
                return this.parent.getLevel();
            }
            return null;
        }

        public int hashCode() {
            String name = this.logger == null ? "" : this.logger.getName();
            return name.hashCode();
        }

        public boolean isRoot() {
            return this.parent == null;
        }
    }
}

