/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.library.h2cache;

import ca.infodata.util1.JoinList;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractEncryptedFileSystem {
    private static final Logger logger = Logger.getLogger(AbstractEncryptedFileSystem.class.getName());
    private File mvdbFile;
    private File traceFile;
    protected final Connection connection;

    public AbstractEncryptedFileSystem(File file, String filePassword) throws ClassNotFoundException, SQLException {
        this.mvdbFile = new File(file.getParent(), String.valueOf(file.getName()) + ".mv.db");
        this.traceFile = new File(file.getParent(), String.valueOf(file.getName()) + ".trace.db");
        Class.forName("org.h2.Driver");
        String path = file.getAbsolutePath();
        JoinList urlBuilder = new JoinList(";", new Object[]{String.format("jdbc:h2:%s", path)});
        if (filePassword != null) {
            urlBuilder.add((CharSequence)"CIPHER=AES");
        }
        urlBuilder.add((CharSequence)"AUTO_RECONNECT=TRUE");
        urlBuilder.add((CharSequence)"CACHE_SIZE=50000");
        urlBuilder.add((CharSequence)"TRACE_LEVEL_FILE=0");
        String url = urlBuilder.toString();
        String user = "ofys";
        String userPassword = "ofys";
        String password = new JoinList(" ", new Object[]{filePassword, userPassword}).toString();
        this.connection = DriverManager.getConnection(url, user, password);
    }

    public void closeAndDelete() {
        AbstractEncryptedFileSystem.closeAll(null, null, this.connection);
        AbstractEncryptedFileSystem.delete(this.mvdbFile);
        AbstractEncryptedFileSystem.delete(this.traceFile);
    }

    private static void delete(File file) {
        try {
            boolean delete;
            if (file.exists() && !(delete = file.delete())) {
                logger.log(Level.INFO, file + " not deleted");
                file.deleteOnExit();
            }
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Failed to delete file " + file.getName());
        }
    }

    protected static void closeAll(ResultSet rs, Statement stmt, Connection conn) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Cannot close ResultSet", e);
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Cannot close Statement", e);
        }
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, "Cannot close Connection", e);
        }
    }
}

