/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.library.city;

import ca.infodata.ofys.city.City;
import ca.infodata.ofys.city.FindCityCriteria;
import ca.infodata.ofys.city.ICityIndex;
import ca.infodata.ofys.city.Province;
import ca.infodata.ofys.ui.library.LibPlugin;
import ca.infodata.ofys.ui.library.file.FileUtil;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.LocaleProvider;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.services.IDisposable;

public class CityIndex
implements IDisposable,
ICityIndex {
    private static final Logger logger = Logger.getLogger(CityIndex.class.getName());
    private File mvdbFile;
    private Connection connection;
    private volatile boolean initialized = false;
    private final ReentrantLock lock;
    private final String sqlWithText;
    private final String sqlNoText;
    private final String sqlByPostalCode;
    private final String sqlByCensusDivision;
    private final Map<String, Integer> QC_ORDERING = new HashMap<String, Integer>();
    private final Map<String, Integer> NB_ORDERING = new HashMap<String, Integer>();
    private Map<String, Integer> ordering = this.QC_ORDERING;

    public CityIndex() {
        this.QC_ORDERING.put("QC", 0);
        this.QC_ORDERING.put("NB", 1);
        this.QC_ORDERING.put("ON", 2);
        this.QC_ORDERING.put("AL", 3);
        this.QC_ORDERING.put("BC", 3);
        this.QC_ORDERING.put("NS", 3);
        this.QC_ORDERING.put("NU", 3);
        this.QC_ORDERING.put("SK", 3);
        this.QC_ORDERING.put("NL", 3);
        this.QC_ORDERING.put("NT", 3);
        this.QC_ORDERING.put("YT", 3);
        this.QC_ORDERING.put("PE", 3);
        this.QC_ORDERING.put("ELSE", 4);
        this.NB_ORDERING.put("NB", 0);
        this.NB_ORDERING.put("NS", 1);
        this.NB_ORDERING.put("PE", 2);
        this.NB_ORDERING.put("QC", 3);
        this.NB_ORDERING.put("AL", 4);
        this.NB_ORDERING.put("BC", 4);
        this.NB_ORDERING.put("NU", 4);
        this.NB_ORDERING.put("ON", 4);
        this.NB_ORDERING.put("SK", 4);
        this.NB_ORDERING.put("NL", 4);
        this.NB_ORDERING.put("NT", 4);
        this.NB_ORDERING.put("YT", 4);
        this.NB_ORDERING.put("ELSE", 5);
        this.lock = new ReentrantLock();
        this.sqlWithText = "SELECT name, \n       province_code, \n       census_division, \n       postcode_area, \n       CASE \n         WHEN province_code = 'AL' THEN ? \n         WHEN province_code = 'BC' THEN ? \n         WHEN province_code = 'NB' THEN ? \n         WHEN province_code = 'NS' THEN ? \n         WHEN province_code = 'NU' THEN ? \n         WHEN province_code = 'ON' THEN ? \n         WHEN province_code = 'QC' THEN ? \n         WHEN province_code = 'SK' THEN ? \n         WHEN province_code = 'NL' THEN ? \n         WHEN province_code = 'NT' THEN ? \n         WHEN province_code = 'YT' THEN ? \n         WHEN province_code = 'PE' THEN ? \n         ELSE ? \n       END AS sort, \n       CASE \n         WHEN TYPE = 'City' THEN 0 \n         WHEN TYPE = 'Town' THEN 1 \n         WHEN TYPE = 'Village' THEN 2 \n         WHEN TYPE = 'Hamlet' THEN 3 \n         WHEN TYPE = 'Municipality' THEN 3 \n         WHEN TYPE = 'Unincorporated area' THEN 5 \n         ELSE 6 \n       END AS type2, \n       TYPE \nFROM ca_cities \nWHERE NAME_SEARCH REGEXP ? \nORDER BY sort, \n         type2 ASC, \n         name ASC limit ? \n";
        this.sqlNoText = "SELECT name, \n       province_code, \n       census_division, \n       postcode_area, \n       CASE \n         WHEN province_code = 'AL' THEN ? \n         WHEN province_code = 'BC' THEN ? \n         WHEN province_code = 'NB' THEN ? \n         WHEN province_code = 'NS' THEN ? \n         WHEN province_code = 'NU' THEN ? \n         WHEN province_code = 'ON' THEN ? \n         WHEN province_code = 'QC' THEN ? \n         WHEN province_code = 'SK' THEN ? \n         WHEN province_code = 'NL' THEN ? \n         WHEN province_code = 'NT' THEN ? \n         WHEN province_code = 'YT' THEN ? \n         WHEN province_code = 'PE' THEN ? \n         ELSE ? \n       END AS sort, \n       CASE \n         WHEN TYPE = 'City' THEN 0 \n         WHEN TYPE = 'Town' THEN 1 \n         WHEN TYPE = 'Village' THEN 2 \n         WHEN TYPE = 'Hamlet' THEN 3 \n         WHEN TYPE = 'Municipality' THEN 4 \n         WHEN TYPE = 'Unincorporated area' THEN 5 \n         ELSE 6 \n       END AS type2, \n       TYPE \nFROM ca_cities \nORDER BY sort, \n         type2 ASC, \n         name ASC limit ?";
        this.sqlByPostalCode = "SELECT name,  \n       province_code,  \n       census_division,  \n       postcode_area,  \n       CASE  \n         WHEN province_code = 'AL' THEN ? \n         WHEN province_code = 'BC' THEN ? \n         WHEN province_code = 'NB' THEN ? \n         WHEN province_code = 'NS' THEN ? \n         WHEN province_code = 'NU' THEN ? \n         WHEN province_code = 'ON' THEN ? \n         WHEN province_code = 'QC' THEN ? \n         WHEN province_code = 'SK' THEN ? \n         WHEN province_code = 'NL' THEN ? \n         WHEN province_code = 'NT' THEN ? \n         WHEN province_code = 'YT' THEN ? \n         WHEN province_code = 'PE' THEN ? \n         ELSE ? \n       END AS sort,  \n       CASE  \n         WHEN TYPE = 'City' THEN 0  \n         WHEN TYPE = 'Town' THEN 1  \n         WHEN TYPE = 'Village' THEN 2  \n         WHEN TYPE = 'Hamlet' THEN 3  \n         WHEN TYPE = 'Municipality' THEN 4  \n         WHEN TYPE = 'Unincorporated area' THEN 5  \n         ELSE 6  \n       END AS type2,  \n       TYPE  \nFROM ca_cities  \nwhere POSTCODE_AREA like ? \nORDER BY sort,  \n         type2 ASC,  \n         name ASC limit ?";
        this.sqlByCensusDivision = "SELECT name,  \n       province_code,  \n       census_division,  \n       postcode_area,  \n       CASE  \n         WHEN province_code = 'AL' THEN ? \n         WHEN province_code = 'BC' THEN ? \n         WHEN province_code = 'NB' THEN ? \n         WHEN province_code = 'NS' THEN ? \n         WHEN province_code = 'NU' THEN ? \n         WHEN province_code = 'ON' THEN ? \n         WHEN province_code = 'QC' THEN ? \n         WHEN province_code = 'SK' THEN ? \n         WHEN province_code = 'NL' THEN ? \n         WHEN province_code = 'NT' THEN ? \n         WHEN province_code = 'YT' THEN ? \n         WHEN province_code = 'PE' THEN ? \n         ELSE ? \n       END AS sort,  \n       CASE  \n         WHEN TYPE = 'City' THEN 0  \n         WHEN TYPE = 'Town' THEN 1  \n         WHEN TYPE = 'Village' THEN 2  \n         WHEN TYPE = 'Hamlet' THEN 3  \n         WHEN TYPE = 'Municipality' THEN 4  \n         WHEN TYPE = 'Unincorporated area' THEN 5  \n         ELSE 6  \n       END AS type2,  \n       TYPE  \nFROM ca_cities  \nwhere census_division = ? and type in ('City', 'Town', 'Village') \nORDER BY sort,  \n         type2 ASC,  \n         name ASC limit ?";
    }

    public void setOrdering(ICityIndex.ORDERING o) {
        if (o == ICityIndex.ORDERING.NB) {
            this.setNBOrdering();
        } else {
            this.setQCOrdering();
        }
    }

    public void setQCOrdering() {
        this.ordering = this.QC_ORDERING;
    }

    public void setNBOrdering() {
        this.ordering = this.NB_ORDERING;
    }

    public synchronized void initAsync() throws Exception {
        try {
            this.lock.lock();
            if (this.initialized) {
                return;
            }
            try {
                Job job = new Job("Cities"){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            try {
                                CityIndex.this.lock.lock();
                                CityIndex.this.init();
                            }
                            catch (Exception e) {
                                logger.log(Level.SEVERE, "Failed to init CityIndex", e);
                                Status status = new Status(4, "ca.infodata.ofys.ui.library", "Erreur lors de l'initialisation des villes");
                                CityIndex.this.lock.unlock();
                                return status;
                            }
                        }
                        finally {
                            CityIndex.this.lock.unlock();
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
            catch (Exception exception) {}
        }
        finally {
            this.lock.unlock();
        }
    }

    protected synchronized void init() throws Exception {
        if (this.initialized) {
            return;
        }
        Exception exception = null;
        int i = 0;
        while (!this.initialized && i < 3) {
            try {
                this.initMvdbFile();
                Class.forName("org.h2.Driver");
                String path = this.mvdbFile.getAbsolutePath().replace(".mv.db", "");
                JoinList urlBuilder = new JoinList(";", new Object[]{String.format("jdbc:h2:%s", path)});
                urlBuilder.add((CharSequence)"AUTO_RECONNECT=TRUE");
                urlBuilder.add((CharSequence)"CACHE_SIZE=5000");
                urlBuilder.add((CharSequence)"TRACE_LEVEL_FILE=0");
                urlBuilder.add((CharSequence)"ACCESS_MODE_DATA=r");
                String url = urlBuilder.toString();
                this.connection = DriverManager.getConnection(url);
                this.initialized = true;
            }
            catch (Exception e) {
                exception = e;
                logger.log(Level.INFO, "Failed to init city index, try count " + i, e);
            }
        }
        if (!this.initialized) {
            logger.log(Level.SEVERE, "Failed to init city index, after 3 tries", exception);
        }
    }

    private void initMvdbFile() throws IOException {
        this.mvdbFile = new File(LibPlugin.OFYS_HOME_FILE, "cities" + System.currentTimeMillis() + "_" + new String(StringUtils.random((char[])MiscUtil.alphanumericChars, (int)5)) + ".mv.db");
        FileUtil.saveToFile(this.mvdbFile, this.getClass().getResourceAsStream("cities.mv.db"));
    }

    public static void cleanupOldFilesAsync() {
        try {
            Job job = new Job("Nettoyage des vieux fichiers ..."){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        CityIndex.cleanup();
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Failed to clean cities old files", e);
                        return new Status(4, "ca.infodata.ofys.ui.library", "Erreur lors du nettoyage des vieux fichiers");
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        catch (Exception exception) {}
    }

    private static void cleanup() {
        try {
            File[] listFiles;
            final long now = System.currentTimeMillis();
            File[] fileArray = listFiles = LibPlugin.OFYS_HOME_FILE.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isFile() && pathname.canWrite() && pathname.exists() && pathname.getName().startsWith("cities") && pathname.getName().endsWith(".mv.db") && pathname.lastModified() < now - TimeUnit.DAYS.toMillis(2L);
                }
            });
            int n = listFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                try {
                    file.delete();
                }
                catch (Exception exception) {}
                ++n2;
            }
        }
        catch (Exception exception) {}
    }

    public synchronized List<Province> findProvinces(String text) throws Exception {
        try {
            this.lock.lock();
            List<Province> list = this.findProvinces2(text);
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    private List<Province> findProvinces2(String text) throws Exception {
        ArrayList<Province> list;
        block9: {
            if (!this.initialized) {
                this.init();
            }
            text = StringUtils.toAlphanumericExtended((String)text);
            PreparedStatement s = null;
            ResultSet rs = null;
            list = new ArrayList<Province>();
            try {
                try {
                    String sql;
                    if (StringUtils.isNotBlank((String)text)) {
                        sql = "select code, name from PROVINCE where name_search like ? and ISO_LANGUAGE = ? order by name asc";
                        s = this.connection.prepareStatement(sql);
                        s.setString(1, String.valueOf(StringUtils.NormalizeToUppercase((String)text)) + "%");
                        s.setString(2, LocaleProvider.isEnglish() ? "en" : "fr");
                    } else {
                        sql = "select code, name from PROVINCE where ISO_LANGUAGE = ? order by name asc";
                        s = this.connection.prepareStatement(sql);
                        s.setString(1, LocaleProvider.isEnglish() ? "en" : "fr");
                    }
                    rs = s.executeQuery();
                    while (rs.next()) {
                        list.add(new Province(rs.getString(1), rs.getString(2)));
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Failed to get value", e);
                    CityIndex.closeAll(rs, s, null);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                CityIndex.closeAll(rs, s, null);
                throw throwable;
            }
            CityIndex.closeAll(rs, s, null);
        }
        return list;
    }

    public synchronized List<City> findCitiesByPostalCode(String postalCode, int limit) throws Exception {
        try {
            this.lock.lock();
            List<City> list = this.findCitiesByPostalCode2(postalCode, limit);
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    private List<City> findCitiesByPostalCode2(String postalCode, int limit) throws Exception {
        ArrayList<City> list;
        block16: {
            if (!this.initialized) {
                this.init();
            }
            postalCode = StringUtils.toAlphanumericExtended((String)postalCode);
            list = new ArrayList<City>(limit);
            if (StringUtils.isNotBlank((String)postalCode) && postalCode.length() >= 3) {
                City city;
                ResultSet rs;
                PreparedStatement s;
                block14: {
                    postalCode = postalCode.trim().toUpperCase().substring(0, 3);
                    s = null;
                    rs = null;
                    try {
                        try {
                            s = this.connection.prepareStatement(this.sqlByPostalCode);
                            int i = 1;
                            i = this.fillOrdering(s, i);
                            s.setString(i++, String.valueOf(postalCode) + "%");
                            s.setInt(i++, limit);
                            rs = s.executeQuery();
                            while (rs.next()) {
                                city = new City();
                                city.name = rs.getString(1);
                                city.province = rs.getString(2);
                                city.censusDivision = rs.getString(3);
                                city.postcodeArea = rs.getString(4);
                                city.type = rs.getString(7);
                                list.add(city);
                            }
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, "Failed to get value", e);
                            CityIndex.closeAll(rs, s, null);
                            break block14;
                        }
                    }
                    catch (Throwable throwable) {
                        CityIndex.closeAll(rs, s, null);
                        throw throwable;
                    }
                    CityIndex.closeAll(rs, s, null);
                }
                if (list.size() > 0) {
                    try {
                        try {
                            s = this.connection.prepareStatement(this.sqlByCensusDivision);
                            int i = 1;
                            i = this.fillOrdering(s, i);
                            s.setString(i++, ((City)list.get((int)0)).censusDivision);
                            s.setInt(i++, limit);
                            rs = s.executeQuery();
                            while (rs.next()) {
                                city = new City();
                                city.name = rs.getString(1);
                                city.province = rs.getString(2);
                                city.censusDivision = rs.getString(3);
                                city.postcodeArea = rs.getString(4);
                                city.type = rs.getString(7);
                                list.add(city);
                            }
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, "Failed to get value", e);
                            CityIndex.closeAll(rs, s, null);
                            break block16;
                        }
                    }
                    catch (Throwable throwable) {
                        CityIndex.closeAll(rs, s, null);
                        throw throwable;
                    }
                    CityIndex.closeAll(rs, s, null);
                }
            }
        }
        ArrayList<City> list2 = new ArrayList<City>(new LinkedHashSet(list));
        return list2;
    }

    private int fillOrdering(PreparedStatement s, int i) throws SQLException {
        s.setInt(i++, this.ordering.get("AL"));
        s.setInt(i++, this.ordering.get("BC"));
        s.setInt(i++, this.ordering.get("NB"));
        s.setInt(i++, this.ordering.get("NS"));
        s.setInt(i++, this.ordering.get("NU"));
        s.setInt(i++, this.ordering.get("ON"));
        s.setInt(i++, this.ordering.get("QC"));
        s.setInt(i++, this.ordering.get("SK"));
        s.setInt(i++, this.ordering.get("NL"));
        s.setInt(i++, this.ordering.get("NT"));
        s.setInt(i++, this.ordering.get("YT"));
        s.setInt(i++, this.ordering.get("PE"));
        s.setInt(i++, this.ordering.get("ELSE"));
        return i;
    }

    public synchronized List<City> findCities(FindCityCriteria criteria) throws Exception {
        try {
            this.lock.lock();
            this.setOrdering(criteria.getOrdering());
            List<City> list = this.findCities2(criteria.getText(), criteria.getLimit());
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    public synchronized List<City> findCities(String text, int limit) throws Exception {
        try {
            this.lock.lock();
            List<City> list = this.findCities2(text, limit);
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    private List<City> findCities2(String text, int limit) throws Exception {
        ArrayList<City> list;
        block9: {
            if (!this.initialized) {
                this.init();
            }
            PreparedStatement s = null;
            ResultSet rs = null;
            list = new ArrayList<City>(limit);
            try {
                try {
                    int i;
                    if (StringUtils.isNotBlank((String)text)) {
                        s = this.connection.prepareStatement(this.sqlWithText);
                        i = 1;
                        i = this.fillOrdering(s, i);
                        s.setString(i++, "\\b" + StringUtils.NormalizeToUppercase((String)text) + "\\w*\\b");
                        s.setInt(i++, limit);
                    } else {
                        s = this.connection.prepareStatement(this.sqlNoText);
                        i = 1;
                        i = this.fillOrdering(s, i);
                        s.setInt(i++, limit);
                    }
                    rs = s.executeQuery();
                    while (rs.next()) {
                        City c = new City();
                        c.name = rs.getString(1);
                        c.province = rs.getString(2);
                        c.censusDivision = rs.getString(3);
                        c.postcodeArea = rs.getString(4);
                        c.type = rs.getString(7);
                        list.add(c);
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Failed to get value", e);
                    CityIndex.closeAll(rs, s, null);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                CityIndex.closeAll(rs, s, null);
                throw throwable;
            }
            CityIndex.closeAll(rs, s, null);
        }
        return list;
    }

    public synchronized void dispose() {
        CityIndex.closeAll(null, null, this.connection);
        this.mvdbFile.deleteOnExit();
    }

    protected static void closeAll(ResultSet rs, Statement stmt, Connection conn) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Cannot close ResultSet", e);
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Cannot close Statement", e);
        }
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, "Cannot close Connection", e);
        }
    }
}

