/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.laboresults.menu;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.LaboResultsAccessorClient;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XBaseLaboResultsProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XLaboResultsProfessionnalQuery;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XNumberByLaboResultsProfessionnalQuery;
import ca.infodata.ofys.ui.controls.ITreeElements;
import ca.infodata.ofys.ui.laboresults.Messages;
import ca.infodata.ofys.ui.laboresults.menu.LaboResultsElement;
import ca.infodata.ofys.ui.menu.treeelements.CallbackElement;
import ca.infodata.ofys.ui.menu.treeelements.LoadingElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.IFontProvider;

public abstract class ListResultats
extends CallbackElement
implements ITreeElements,
IFontProvider {
    private static final Logger logger = Logger.getLogger(ListResultats.class.getName());
    protected static final String A_REGLER = Messages.getString("ListResultatsToResolve.A_REGLER");
    protected static final String A_VOIR = Messages.getString("ListResultatsToSeen.A_VOIR");
    protected static final String PERSONNE_A_VU = Messages.getString("ListResultatsToSeen.PERSONNE_A_VU");
    protected static final String MODIFIER = Messages.getString("ListResultatsToSeen.MODIFIER");
    protected XLaboResultsProfessionnalQuery container;
    private static ConcurrentHashMap<Ids, CacheEntry> cache = new ConcurrentHashMap();

    public ListResultats(ITreeElements parent) {
        super(parent);
    }

    public void loadCountAsync() {
        XNumberByLaboResultsProfessionnalQuery r = this.getFromLocalCache();
        if (r == null) {
            this.getFromServerAsync();
        } else {
            this.loadCountResponse(r);
        }
    }

    private void getFromServerAsync() {
        try {
            LaboResultsAccessorClient.getInstance().getNumberByLaboResultsContainerAsync(Application.get().getGlobalInstances().getSession(), this.container, this.getCallback(0));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to get scan count for " + this.container, e);
            this.loadResponse(0, null);
        }
    }

    public final void loadCountResponse(Object response) {
        XNumberByLaboResultsProfessionnalQuery count = (XNumberByLaboResultsProfessionnalQuery)(response == null ? new XNumberByLaboResultsProfessionnalQuery() : response);
        this.addToLocalCache(count);
        this.loadCountResponseOverride(count);
    }

    public abstract void loadCountResponseOverride(XNumberByLaboResultsProfessionnalQuery var1);

    public void loadListAsync() {
        ArrayList<LoadingElement> list = new ArrayList<LoadingElement>();
        list.add(new LoadingElement((ITreeElements)this));
        this.setChilds(list);
        try {
            LaboResultsAccessorClient.getInstance().findLaboResultsProfessionnal(Application.get().getGlobalInstances().getSession(), this.getCallback(1), this.getLaboResultsContainer());
        }
        catch (CannotConnectToServerException e) {
            logger.log(Level.SEVERE, "Failed to get list for " + this.container, e);
            this.loadResponse(1, null);
        }
    }

    public void loadListResponse(Object response) {
        List list = response == null ? new ArrayList(0) : (List)response;
        ArrayList<LaboResultsElement> listChild = new ArrayList<LaboResultsElement>(list.size());
        Integer patient = this.container.getIdPatient();
        Integer professionnal = this.container.getIdProfessionnal();
        if (patient != null) {
            for (XBaseLaboResultsProfessionnal labo : list) {
                LaboResultsElement e = this.newLaboElement(labo);
                e.setShowPatientName(false);
                listChild.add(e);
            }
        } else if (professionnal != null) {
            for (XBaseLaboResultsProfessionnal labo : list) {
                LaboResultsElement e = this.newLaboElement(labo);
                e.setShowPatientName(true);
                listChild.add(e);
            }
        }
        this.setChilds(listChild);
    }

    private LaboResultsElement newLaboElement(XBaseLaboResultsProfessionnal labo) {
        return new LaboResultsElement(this, labo);
    }

    public final boolean hasChildren() {
        return true;
    }

    public XLaboResultsProfessionnalQuery getLaboResultsContainer() {
        return this.container;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.getLaboResultsContainer() == null ? 0 : this.getLaboResultsContainer().hashCode());
        result = 31 * result + (this.getParent() == null ? 0 : this.getParent().hashCode());
        return result;
    }

    private void addToLocalCache(XNumberByLaboResultsProfessionnalQuery count) {
        if (this.container.getIdProfessionnal() != null) {
            Ids ids = new Ids(this.container.getIdProfessionnal(), this.container.getIdPatient());
            cache.put(ids, new CacheEntry(count));
        }
    }

    private XNumberByLaboResultsProfessionnalQuery getFromLocalCache() {
        if (this.container.getIdProfessionnal() != null) {
            Ids ids = new Ids(this.container.getIdProfessionnal(), this.container.getIdPatient());
            Iterator<Map.Entry<Ids, CacheEntry>> iterator = cache.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Ids, CacheEntry> next = iterator.next();
                if (next.getValue() != null && !next.getValue().isExpired()) continue;
                iterator.remove();
            }
            CacheEntry cacheEntry = cache.get(ids);
            return cacheEntry == null ? null : cacheEntry.count;
        }
        return null;
    }

    private static class CacheEntry {
        private final long expireTime;
        public final XNumberByLaboResultsProfessionnalQuery count;

        public CacheEntry(XNumberByLaboResultsProfessionnalQuery count) {
            this.count = count;
            this.expireTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(30L);
        }

        public boolean isExpired() {
            return System.currentTimeMillis() >= this.expireTime;
        }
    }

    private static class Ids {
        final Integer idProf;
        final Integer idPat;

        public Ids(Integer id, Integer idp) {
            this.idProf = id;
            this.idPat = idp;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.idProf == null ? 0 : this.idProf.hashCode());
            result = 31 * result + (this.idPat == null ? 0 : this.idPat.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Ids)) {
                return false;
            }
            Ids other = (Ids)obj;
            if (this.idProf == null ? other.idProf != null : !this.idProf.equals(other.idProf)) {
                return false;
            }
            return !(this.idPat == null ? other.idPat != null : !this.idPat.equals(other.idPat));
        }
    }
}

