/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.intro;

import ca.infodata.ofys.ui.controls.util.MyDialogSettings;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.Util;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

class WindowStateDialogSettings
extends MyDialogSettings {
    private static final Logger logger = Logger.getLogger(WindowStateDialogSettings.class.getName());
    private static final String HEIGHT = "h";
    private static final String WIDTH = "w";
    private static final String X = "x";
    private static final String Y = "y";
    private static final String FONT_SIZE = "fontSizeInc";
    private int defaultWidth = 1024;
    private int defaultHeight = 768;
    private int defaultX = 0;
    private int defaultY = 0;
    private int defaultFontSize = ResourceGetter.getFontSizeIncrement();

    public WindowStateDialogSettings(Display display) {
        super("winpos.xml", "root");
        if (display == null) {
            throw new NullPointerException("display");
        }
        this.setDefaults(display);
    }

    private void setDefaults(Display display) {
        boolean boundsNotSet;
        boolean fontNotSet;
        boolean bl = fontNotSet = this.get(FONT_SIZE) == null;
        if (fontNotSet) {
            this.put(FONT_SIZE, this.defaultFontSize);
        }
        boolean bl2 = boundsNotSet = this.get(WIDTH) == null || this.get(HEIGHT) == null || this.get(X) == null || this.get(Y) == null;
        if (boundsNotSet) {
            Rectangle bounds = display.getBounds();
            this.defaultHeight = bounds.height > 768 ? 768 : bounds.height;
            this.defaultWidth = bounds.width > 1024 ? 1024 : bounds.width;
            this.defaultX = Util.center((int)bounds.width, (int)this.defaultWidth);
            this.defaultY = Util.center((int)bounds.height, (int)this.defaultHeight);
            this.put(WIDTH, this.defaultWidth);
            this.put(HEIGHT, this.defaultHeight);
            this.put(X, this.defaultX);
            this.put(Y, this.defaultY);
        }
    }

    public void setLocation(Point location) {
        int x = location.x < 0 ? this.defaultX : location.x;
        int y = location.y < 0 ? this.defaultY : location.y;
        this.put(X, x);
        this.put(Y, y);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "set window location to " + new Point(x, y));
        }
    }

    public void setSize(Point size) {
        int w = size.x < 50 ? this.defaultWidth : size.x;
        int h = size.y < 50 ? this.defaultHeight : size.y;
        this.put(WIDTH, w);
        this.put(HEIGHT, h);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "set window size to " + new Point(w, h));
        }
    }

    public Point getLocation() {
        Point point;
        try {
            int x = this.getInt(X);
            int y = this.getInt(Y);
            point = new Point(x < 0 ? this.defaultX : x, y < 0 ? this.defaultY : y);
        }
        catch (Exception exception) {
            point = new Point(this.defaultX, this.defaultY);
        }
        logger.log(Level.FINE, "get window location = " + point);
        return point;
    }

    public Point getSize() {
        Point point;
        try {
            int w = this.getInt(WIDTH);
            int h = this.getInt(HEIGHT);
            point = new Point(w < 50 ? this.defaultWidth : w, h < 50 ? this.defaultHeight : h);
        }
        catch (Exception exception) {
            point = new Point(this.defaultWidth, this.defaultHeight);
        }
        logger.log(Level.FINE, "get window size = " + point);
        return point;
    }

    public int getFontSize() {
        int size;
        try {
            size = this.getInt(FONT_SIZE);
        }
        catch (Exception exception) {
            size = this.defaultFontSize;
        }
        logger.log(Level.FINE, "get font size = " + size);
        return size;
    }

    public void setFontSize(int size) {
        logger.log(Level.FINE, "set font size to " + size);
        this.put(FONT_SIZE, size);
    }
}

