/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.help;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.service.keyset.KeysetAccessorClient;
import ca.infodata.ofys.data.dataaccess.service.keyset.NullKeysetAccessorClient;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.util1.IPair;
import ca.infodata.util1.Pair;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class HelpPlugin
extends AbstractUIPlugin {
    private static final Logger logger = Logger.getLogger(HelpPlugin.class.getName());
    public static final String PLUGIN_ID = "ca.infodata.ofys.ui.help";
    private static HelpPlugin plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.configureKeysetService();
    }

    private void configureKeysetService() {
        try {
            if (Application.get().getGlobalInstances().getKeysetConnectionInfo() != null) {
                KeysetAccessorClient.setInstance((KeysetAccessorClient)new KeysetAccessorClient());
            } else {
                KeysetAccessorClient.setInstance((KeysetAccessorClient)new NullKeysetAccessorClient());
            }
        }
        catch (Exception e) {
            KeysetAccessorClient.setInstance((KeysetAccessorClient)new NullKeysetAccessorClient());
            logger.log(Level.WARNING, "Failed to instanciate KeysetAccessorClient", e);
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static HelpPlugin getDefault() {
        return plugin;
    }

    public static void showHelp(String section, boolean modal) {
        try {
            Pair param1 = Pair.newPair((Object)"section", (Object)section);
            Pair param2 = Pair.newPair((Object)"modal", (Object)String.valueOf(modal));
            UI.genericExecuteCommand((AbstractUIPlugin)HelpPlugin.getDefault(), (String)"ca.infodata.ofys.ui.help.commands.helpCommand", (IPair[])new IPair[]{param1, param2});
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to show help with section " + section, e);
        }
    }
}

