/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.eform;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.eform.XEform;
import ca.infodata.ofys.data.middle.dataobjects.eform.XEformData;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class SimpleEFormInput
implements IEditorInput {
    private XEform form;
    private XEformData data;
    private XEformData backupData;
    private boolean readonly;
    private XPatient patient;
    private boolean fromEncounter;

    public SimpleEFormInput(XEform eform, XPatient patient) {
        if (eform == null) {
            throw new NullPointerException("eform");
        }
        if (patient == null) {
            throw new NullPointerException("patient");
        }
        this.form = eform;
        this.readonly = true;
        this.patient = patient;
    }

    public SimpleEFormInput(XEform form) {
        if (form == null) {
            throw new NullPointerException("form");
        }
        this.form = form;
        this.data = null;
        this.backupData = null;
        this.readonly = true;
    }

    public SimpleEFormInput(XEformData data, XPatient patient, boolean readonly) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (patient == null) {
            throw new NullPointerException("patient");
        }
        if (patient.getId() == null) {
            throw new NullPointerException("patient.getId()");
        }
        Integer basePerson = Application.get().getGlobalInstances().getSession().getUser().getBasePerson();
        if (basePerson != null && !readonly) {
            data.setIdAuthor(basePerson);
        }
        this.patient = patient;
        this.data = data;
        this.backupData = data.clone();
        this.form = (XEform)data.getForm();
        this.readonly = readonly;
    }

    public void doCancel() {
        this.data = this.backupData = this.backupData.clone();
    }

    public Object getAdapter(Class clazz) {
        return null;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        String text;
        if (this.data != null) {
            if (this.data.getId() == null) {
                text = "Nouveau " + this.data.getForm().getName() + " ( " + this.patient.getName() + " )";
            } else {
                text = String.valueOf(this.data.getForm().getName()) + " ( " + this.patient.getName() + " )";
                if (Application.get().getGlobalInstances().inDebugMode()) {
                    text = this.data.getId() + "-e" + this.data.getIdEncounter() + " " + text;
                }
            }
        } else {
            text = String.format("%s", this.form.getName(), this.form.getLanguage());
            if (Application.get().getGlobalInstances().inDebugMode()) {
                text = this.form.getId() + " " + text;
            }
        }
        if (this.readonly) {
            text = String.valueOf(text) + " ( Lecture seule ) ";
        }
        return text;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return "";
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public XEform getForm() {
        return this.form;
    }

    public XEformData getData() {
        return this.data;
    }

    public XEformData getBackupData() {
        return this.backupData;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        result = 31 * result + (this.form == null ? 0 : this.form.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleEFormInput other = (SimpleEFormInput)obj;
        if (this.data == null ? other.data != null : !this.data.equals((Object)other.data)) {
            return false;
        }
        return !(this.form == null ? other.form != null : !this.form.equals((Object)other.form));
    }

    public XPatient getPatient() {
        return this.patient;
    }

    public boolean isFromEncounter() {
        return this.fromEncounter;
    }

    public void setFromEncounter(boolean fromEncounter) {
        this.fromEncounter = fromEncounter;
    }
}

