/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dashboard;

import ca.infodata.ofys.client.IPreSaveController;
import ca.infodata.ofys.data.middle.dataobjects.encounter.CEncounter;
import ca.infodata.ofys.ui.dashboard.models.MVEncs;
import ca.infodata.ofys.ui.dashboard.models.MVSecureCache;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PreSaveController
implements IPreSaveController {
    private static final Logger logger = Logger.getLogger(PreSaveController.class.getName());
    private MVEncs mvEncs = new MVEncs();
    private MVSecureCache mvSecureCache = new MVSecureCache();

    public List<Integer> getAllEncountersPatientId() {
        return this.mvEncs.getAllPresaveEncountersPatientId();
    }

    public List<CEncounter> getAllEncounters() {
        return this.mvEncs.getAllEncounters();
    }

    public CEncounter getEncounterByPatient(Integer patientId) {
        return this.mvEncs.getEncounter(patientId);
    }

    public void deleteEncountersByPatient(Integer patientId) {
        this.mvEncs.deleteUserStore(patientId);
    }

    public void addModifiedEncounter(CEncounter enc) {
        this.mvEncs.addModifiedEnc(enc);
    }

    public void saveOrUpdate(String context, Integer tag, Object data) {
        this.mvSecureCache.addObjectToMap(context, tag, data);
    }

    public void removeByTag(String context, Integer tag) {
        this.mvSecureCache.removeObjectFromMap(context, tag);
    }

    public Object getByTag(String context, Integer tag) {
        return this.mvSecureCache.getObjectFromMap(context, tag);
    }

    public void dispose() {
        try {
            this.mvEncs.dispose();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error disposing PresaveController.mvEncs", e);
        }
        try {
            this.mvSecureCache.dispose();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error disposing PresaveController.mvSecureCache", e);
        }
    }
}

