/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERSequenceGenerator;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSSignedGenerator;
import org.bouncycastle.cms.CMSSignedHelper;
import org.bouncycastle.cms.CMSStreamException;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerIntInfoGenerator;
import org.bouncycastle.cms.SimpleAttributeTableGenerator;

public class CMSSignedDataStreamGenerator
extends CMSSignedGenerator {
    private List _signerInfs = new ArrayList();
    private List _messageDigests = new ArrayList();
    private int _bufferSize;

    public CMSSignedDataStreamGenerator() {
    }

    public CMSSignedDataStreamGenerator(SecureRandom rand) {
        super(rand);
    }

    public void setBufferSize(int bufferSize) {
        this._bufferSize = bufferSize;
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String digestOID, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(key, cert, digestOID, CMSUtils.getProvider(sigProvider));
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String digestOID, Provider sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(key, cert, digestOID, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(), null, sigProvider);
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String encryptionOID, String digestOID, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(key, cert, encryptionOID, digestOID, CMSUtils.getProvider(sigProvider));
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String encryptionOID, String digestOID, Provider sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(key, cert, encryptionOID, digestOID, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(), null, sigProvider);
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String digestOID, AttributeTable signedAttr, AttributeTable unsignedAttr, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(key, cert, digestOID, signedAttr, unsignedAttr, CMSUtils.getProvider(sigProvider));
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String digestOID, AttributeTable signedAttr, AttributeTable unsignedAttr, Provider sigProvider) throws NoSuchAlgorithmException, InvalidKeyException {
        this.addSigner(key, cert, digestOID, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(signedAttr), (CMSAttributeTableGenerator)new SimpleAttributeTableGenerator(unsignedAttr), sigProvider);
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String encryptionOID, String digestOID, AttributeTable signedAttr, AttributeTable unsignedAttr, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(key, cert, encryptionOID, digestOID, signedAttr, unsignedAttr, CMSUtils.getProvider(sigProvider));
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String encryptionOID, String digestOID, AttributeTable signedAttr, AttributeTable unsignedAttr, Provider sigProvider) throws NoSuchAlgorithmException, InvalidKeyException {
        this.addSigner(key, cert, encryptionOID, digestOID, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(signedAttr), (CMSAttributeTableGenerator)new SimpleAttributeTableGenerator(unsignedAttr), sigProvider);
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String digestOID, CMSAttributeTableGenerator signedAttrGenerator, CMSAttributeTableGenerator unsignedAttrGenerator, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(key, cert, digestOID, signedAttrGenerator, unsignedAttrGenerator, CMSUtils.getProvider(sigProvider));
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String digestOID, CMSAttributeTableGenerator signedAttrGenerator, CMSAttributeTableGenerator unsignedAttrGenerator, Provider sigProvider) throws NoSuchAlgorithmException, InvalidKeyException {
        this.addSigner(key, cert, this.getEncOID(key, digestOID), digestOID, signedAttrGenerator, unsignedAttrGenerator, sigProvider);
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String encryptionOID, String digestOID, CMSAttributeTableGenerator signedAttrGenerator, CMSAttributeTableGenerator unsignedAttrGenerator, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(key, cert, encryptionOID, digestOID, signedAttrGenerator, unsignedAttrGenerator, CMSUtils.getProvider(sigProvider));
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String encryptionOID, String digestOID, CMSAttributeTableGenerator signedAttrGenerator, CMSAttributeTableGenerator unsignedAttrGenerator, Provider sigProvider) throws NoSuchAlgorithmException, InvalidKeyException {
        this.doAddSigner(key, CMSSignedDataStreamGenerator.getSignerIdentifier(cert), encryptionOID, digestOID, signedAttrGenerator, unsignedAttrGenerator, sigProvider, sigProvider);
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String digestOID, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(key, subjectKeyID, digestOID, CMSUtils.getProvider(sigProvider));
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String digestOID, Provider sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(key, subjectKeyID, digestOID, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(), null, sigProvider);
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String encryptionOID, String digestOID, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(key, subjectKeyID, encryptionOID, digestOID, CMSUtils.getProvider(sigProvider));
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String encryptionOID, String digestOID, Provider sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(key, subjectKeyID, encryptionOID, digestOID, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(), null, sigProvider);
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String digestOID, AttributeTable signedAttr, AttributeTable unsignedAttr, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(key, subjectKeyID, digestOID, signedAttr, unsignedAttr, CMSUtils.getProvider(sigProvider));
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String digestOID, AttributeTable signedAttr, AttributeTable unsignedAttr, Provider sigProvider) throws NoSuchAlgorithmException, InvalidKeyException {
        this.addSigner(key, subjectKeyID, digestOID, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(signedAttr), (CMSAttributeTableGenerator)new SimpleAttributeTableGenerator(unsignedAttr), sigProvider);
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String digestOID, CMSAttributeTableGenerator signedAttrGenerator, CMSAttributeTableGenerator unsignedAttrGenerator, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(key, subjectKeyID, digestOID, signedAttrGenerator, unsignedAttrGenerator, CMSUtils.getProvider(sigProvider));
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String digestOID, CMSAttributeTableGenerator signedAttrGenerator, CMSAttributeTableGenerator unsignedAttrGenerator, Provider sigProvider) throws NoSuchAlgorithmException, InvalidKeyException {
        this.addSigner(key, subjectKeyID, this.getEncOID(key, digestOID), digestOID, signedAttrGenerator, unsignedAttrGenerator, sigProvider);
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String encryptionOID, String digestOID, CMSAttributeTableGenerator signedAttrGenerator, CMSAttributeTableGenerator unsignedAttrGenerator, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(key, subjectKeyID, encryptionOID, digestOID, signedAttrGenerator, unsignedAttrGenerator, CMSUtils.getProvider(sigProvider));
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String encryptionOID, String digestOID, CMSAttributeTableGenerator signedAttrGenerator, CMSAttributeTableGenerator unsignedAttrGenerator, Provider sigProvider) throws NoSuchAlgorithmException, InvalidKeyException {
        this.doAddSigner(key, CMSSignedDataStreamGenerator.getSignerIdentifier(subjectKeyID), encryptionOID, digestOID, signedAttrGenerator, unsignedAttrGenerator, sigProvider, sigProvider);
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String encryptionOID, String digestOID, CMSAttributeTableGenerator signedAttrGenerator, CMSAttributeTableGenerator unsignedAttrGenerator, Provider sigProvider, Provider digProvider) throws NoSuchAlgorithmException, InvalidKeyException {
        this.doAddSigner(key, CMSSignedDataStreamGenerator.getSignerIdentifier(cert), encryptionOID, digestOID, signedAttrGenerator, unsignedAttrGenerator, sigProvider, digProvider);
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String encryptionOID, String digestOID, CMSAttributeTableGenerator signedAttrGenerator, CMSAttributeTableGenerator unsignedAttrGenerator, Provider sigProvider, Provider digProvider) throws NoSuchAlgorithmException, InvalidKeyException {
        this.doAddSigner(key, CMSSignedDataStreamGenerator.getSignerIdentifier(subjectKeyID), encryptionOID, digestOID, signedAttrGenerator, unsignedAttrGenerator, sigProvider, digProvider);
    }

    private void doAddSigner(PrivateKey key, SignerIdentifier signerIdentifier, String encryptionOID, String digestOID, CMSAttributeTableGenerator signedAttrGenerator, CMSAttributeTableGenerator unsignedAttrGenerator, Provider sigProvider, Provider digProvider) throws NoSuchAlgorithmException, InvalidKeyException {
        String digestName = CMSSignedHelper.INSTANCE.getDigestAlgName(digestOID);
        MessageDigest dig = CMSSignedHelper.INSTANCE.getDigestInstance(digestName, digProvider);
        SignerIntInfoGeneratorImpl signerInf = new SignerIntInfoGeneratorImpl(key, signerIdentifier, digestOID, encryptionOID, signedAttrGenerator, unsignedAttrGenerator, sigProvider, this.rand);
        this._signerInfs.add(new DigestAndSignerInfoGeneratorHolder(signerInf, dig, digestOID));
        this._messageDigests.add(dig);
    }

    public OutputStream open(OutputStream out) throws IOException {
        return this.open(out, false);
    }

    public OutputStream open(OutputStream out, boolean encapsulate) throws IOException {
        return this.open(CMSObjectIdentifiers.data, out, encapsulate);
    }

    public OutputStream open(OutputStream out, boolean encapsulate, OutputStream dataOutputStream) throws IOException {
        return this.open(CMSObjectIdentifiers.data, out, encapsulate, dataOutputStream);
    }

    public OutputStream open(OutputStream out, String eContentType, boolean encapsulate) throws IOException {
        return this.open(out, eContentType, encapsulate, null);
    }

    public OutputStream open(ASN1ObjectIdentifier eContentType, OutputStream out, boolean encapsulate) throws IOException {
        return this.open(eContentType, out, encapsulate, null);
    }

    public OutputStream open(OutputStream out, String eContentType, boolean encapsulate, OutputStream dataOutputStream) throws IOException {
        return this.open(new ASN1ObjectIdentifier(eContentType), out, encapsulate, dataOutputStream);
    }

    public OutputStream open(ASN1ObjectIdentifier eContentType, OutputStream out, boolean encapsulate, OutputStream dataOutputStream) throws IOException {
        BERSequenceGenerator sGen = new BERSequenceGenerator(out);
        sGen.addObject(CMSObjectIdentifiers.signedData);
        BERSequenceGenerator sigGen = new BERSequenceGenerator(sGen.getRawOutputStream(), 0, true);
        sigGen.addObject(this.calculateVersion(eContentType));
        ASN1EncodableVector digestAlgs = new ASN1EncodableVector();
        for (SignerInformation signer : this._signers) {
            digestAlgs.add(CMSSignedHelper.INSTANCE.fixAlgID(signer.getDigestAlgorithmID()));
        }
        for (DigestAndSignerInfoGeneratorHolder holder : this._signerInfs) {
            digestAlgs.add(holder.getDigestAlgorithm());
        }
        for (SignerInfoGenerator signerGen : this.signerGens) {
            digestAlgs.add(signerGen.getDigestAlgorithm());
        }
        sigGen.getRawOutputStream().write(new DERSet(digestAlgs).getEncoded());
        BERSequenceGenerator eiGen = new BERSequenceGenerator(sigGen.getRawOutputStream());
        eiGen.addObject(eContentType);
        OutputStream encapStream = encapsulate ? CMSUtils.createBEROctetOutputStream(eiGen.getRawOutputStream(), 0, true, this._bufferSize) : null;
        OutputStream contentStream = CMSUtils.getSafeTeeOutputStream(dataOutputStream, encapStream);
        OutputStream digStream = CMSUtils.attachDigestsToOutputStream(this._messageDigests, contentStream);
        OutputStream sigStream = CMSUtils.attachSignersToOutputStream(this.signerGens, digStream);
        return new CmsSignedDataOutputStream(sigStream, eContentType, sGen, sigGen, eiGen);
    }

    void generate(OutputStream out, String eContentType, boolean encapsulate, OutputStream dataOutputStream, CMSProcessable content) throws CMSException, IOException {
        OutputStream signedOut = this.open(out, eContentType, encapsulate, dataOutputStream);
        if (content != null) {
            content.write(signedOut);
        }
        signedOut.close();
    }

    private DERInteger calculateVersion(ASN1ObjectIdentifier contentOid) {
        boolean otherCert = false;
        boolean otherCrl = false;
        boolean attrCertV1Found = false;
        boolean attrCertV2Found = false;
        if (this.certs != null) {
            for (Object obj : this.certs) {
                if (!(obj instanceof ASN1TaggedObject)) continue;
                ASN1TaggedObject tagged = (ASN1TaggedObject)obj;
                if (tagged.getTagNo() == 1) {
                    attrCertV1Found = true;
                    continue;
                }
                if (tagged.getTagNo() == 2) {
                    attrCertV2Found = true;
                    continue;
                }
                if (tagged.getTagNo() != 3) continue;
                otherCert = true;
            }
        }
        if (otherCert) {
            return new DERInteger(5);
        }
        if (this.crls != null) {
            for (Object obj : this.crls) {
                if (!(obj instanceof ASN1TaggedObject)) continue;
                otherCrl = true;
            }
        }
        if (otherCrl) {
            return new DERInteger(5);
        }
        if (attrCertV2Found) {
            return new DERInteger(4);
        }
        if (attrCertV1Found) {
            return new DERInteger(3);
        }
        if (this.checkForVersion3(this._signers)) {
            return new DERInteger(3);
        }
        if (!CMSObjectIdentifiers.data.equals(contentOid)) {
            return new DERInteger(3);
        }
        return new DERInteger(1);
    }

    private boolean checkForVersion3(List signerInfos) {
        Iterator it = signerInfos.iterator();
        while (it.hasNext()) {
            SignerInfo s = SignerInfo.getInstance(((SignerInformation)it.next()).toSignerInfo());
            if (s.getVersion().getValue().intValue() != 3) continue;
            return true;
        }
        return false;
    }

    private class CmsSignedDataOutputStream
    extends OutputStream {
        private OutputStream _out;
        private ASN1ObjectIdentifier _contentOID;
        private BERSequenceGenerator _sGen;
        private BERSequenceGenerator _sigGen;
        private BERSequenceGenerator _eiGen;

        public CmsSignedDataOutputStream(OutputStream out, ASN1ObjectIdentifier contentOID, BERSequenceGenerator sGen, BERSequenceGenerator sigGen, BERSequenceGenerator eiGen) {
            this._out = out;
            this._contentOID = contentOID;
            this._sGen = sGen;
            this._sigGen = sigGen;
            this._eiGen = eiGen;
        }

        @Override
        public void write(int b) throws IOException {
            this._out.write(b);
        }

        @Override
        public void write(byte[] bytes, int off, int len) throws IOException {
            this._out.write(bytes, off, len);
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            this._out.write(bytes);
        }

        @Override
        public void close() throws IOException {
            byte[] calculatedDigest;
            this._out.close();
            this._eiGen.close();
            CMSSignedDataStreamGenerator.this.digests.clear();
            if (CMSSignedDataStreamGenerator.this.certs.size() != 0) {
                ASN1Set certSet = CMSUtils.createBerSetFromList(CMSSignedDataStreamGenerator.this.certs);
                this._sigGen.getRawOutputStream().write(new BERTaggedObject(false, 0, certSet).getEncoded());
            }
            if (CMSSignedDataStreamGenerator.this.crls.size() != 0) {
                ASN1Set crlSet = CMSUtils.createBerSetFromList(CMSSignedDataStreamGenerator.this.crls);
                this._sigGen.getRawOutputStream().write(new BERTaggedObject(false, 1, crlSet).getEncoded());
            }
            ASN1EncodableVector signerInfos = new ASN1EncodableVector();
            for (DigestAndSignerInfoGeneratorHolder holder : CMSSignedDataStreamGenerator.this._signerInfs) {
                calculatedDigest = holder.digest.digest();
                CMSSignedDataStreamGenerator.this.digests.put(holder.digestOID, calculatedDigest.clone());
                AlgorithmIdentifier digestAlgorithm = holder.getDigestAlgorithm();
                signerInfos.add(holder.signerInf.generate(this._contentOID, digestAlgorithm, calculatedDigest));
            }
            for (SignerInfoGenerator sigGen : CMSSignedDataStreamGenerator.this.signerGens) {
                try {
                    signerInfos.add(sigGen.generate(this._contentOID));
                    calculatedDigest = sigGen.getCalculatedDigest();
                    CMSSignedDataStreamGenerator.this.digests.put(sigGen.getDigestAlgorithm().getAlgorithm().getId(), calculatedDigest);
                }
                catch (CMSException e) {
                    throw new CMSStreamException("exception generating signers: " + e.getMessage(), e);
                }
            }
            for (SignerInformation signer : CMSSignedDataStreamGenerator.this._signers) {
                signerInfos.add(signer.toSignerInfo());
            }
            this._sigGen.getRawOutputStream().write(new DERSet(signerInfos).getEncoded());
            this._sigGen.close();
            this._sGen.close();
        }
    }

    private class DigestAndSignerInfoGeneratorHolder {
        SignerIntInfoGenerator signerInf;
        MessageDigest digest;
        String digestOID;

        DigestAndSignerInfoGeneratorHolder(SignerIntInfoGenerator signerInf, MessageDigest digest, String digestOID) {
            this.signerInf = signerInf;
            this.digest = digest;
            this.digestOID = digestOID;
        }

        AlgorithmIdentifier getDigestAlgorithm() {
            return new AlgorithmIdentifier(new DERObjectIdentifier(this.digestOID), DERNull.INSTANCE);
        }
    }

    private class SignerIntInfoGeneratorImpl
    implements SignerIntInfoGenerator {
        private final SignerIdentifier _signerIdentifier;
        private final String _encOID;
        private final CMSAttributeTableGenerator _sAttr;
        private final CMSAttributeTableGenerator _unsAttr;
        private final String _encName;
        private final Signature _sig;

        SignerIntInfoGeneratorImpl(PrivateKey key, SignerIdentifier signerIdentifier, String digestOID, String encOID, CMSAttributeTableGenerator sAttr, CMSAttributeTableGenerator unsAttr, Provider sigProvider, SecureRandom random) throws NoSuchAlgorithmException, InvalidKeyException {
            this._signerIdentifier = signerIdentifier;
            this._encOID = encOID;
            this._sAttr = sAttr;
            this._unsAttr = unsAttr;
            this._encName = CMSSignedHelper.INSTANCE.getEncryptionAlgName(this._encOID);
            String digestName = CMSSignedHelper.INSTANCE.getDigestAlgName(digestOID);
            String signatureName = String.valueOf(digestName) + "with" + this._encName;
            if (this._sAttr != null) {
                this._sig = CMSSignedHelper.INSTANCE.getSignatureInstance(signatureName, sigProvider);
            } else if (this._encName.equals("RSA")) {
                this._sig = CMSSignedHelper.INSTANCE.getSignatureInstance("RSA", sigProvider);
            } else if (this._encName.equals("DSA")) {
                this._sig = CMSSignedHelper.INSTANCE.getSignatureInstance("NONEwithDSA", sigProvider);
            } else {
                throw new NoSuchAlgorithmException("algorithm: " + this._encName + " not supported in base signatures.");
            }
            this._sig.initSign(key, random);
        }

        @Override
        public SignerInfo generate(DERObjectIdentifier contentType, AlgorithmIdentifier digestAlgorithm, byte[] calculatedDigest) throws CMSStreamException {
            try {
                byte[] bytesToSign = calculatedDigest;
                ASN1Set signedAttr = null;
                if (this._sAttr != null) {
                    Map parameters = CMSSignedDataStreamGenerator.this.getBaseParameters(contentType, digestAlgorithm, calculatedDigest);
                    AttributeTable signed = this._sAttr.getAttributes(Collections.unmodifiableMap(parameters));
                    if (contentType == null && signed != null && signed.get(CMSAttributes.contentType) != null) {
                        Hashtable tmpSigned = signed.toHashtable();
                        tmpSigned.remove(CMSAttributes.contentType);
                        signed = new AttributeTable(tmpSigned);
                    }
                    signedAttr = CMSSignedDataStreamGenerator.this.getAttributeSet(signed);
                    bytesToSign = signedAttr.getEncoded("DER");
                } else if (this._encName.equals("RSA")) {
                    DigestInfo dInfo = new DigestInfo(digestAlgorithm, calculatedDigest);
                    bytesToSign = dInfo.getEncoded("DER");
                }
                this._sig.update(bytesToSign);
                byte[] sigBytes = this._sig.sign();
                ASN1Set unsignedAttr = null;
                if (this._unsAttr != null) {
                    Map parameters = CMSSignedDataStreamGenerator.this.getBaseParameters(contentType, digestAlgorithm, calculatedDigest);
                    parameters.put("encryptedDigest", sigBytes.clone());
                    AttributeTable unsigned = this._unsAttr.getAttributes(Collections.unmodifiableMap(parameters));
                    unsignedAttr = CMSSignedDataStreamGenerator.this.getAttributeSet(unsigned);
                }
                AlgorithmIdentifier digestEncryptionAlgorithm = CMSSignedDataStreamGenerator.this.getEncAlgorithmIdentifier(this._encOID, this._sig);
                return new SignerInfo(this._signerIdentifier, digestAlgorithm, signedAttr, digestEncryptionAlgorithm, new DEROctetString(sigBytes), unsignedAttr);
            }
            catch (IOException e) {
                throw new CMSStreamException("encoding error.", e);
            }
            catch (SignatureException e) {
                throw new CMSStreamException("error creating signature.", e);
            }
        }
    }
}

