/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERTags;

public class DEROutputStream
extends FilterOutputStream
implements DERTags {
    public DEROutputStream(OutputStream os) {
        super(os);
    }

    private void writeLength(int length) throws IOException {
        if (length > 127) {
            int size = 1;
            int val = length;
            while ((val >>>= 8) != 0) {
                ++size;
            }
            this.write((byte)(size | 0x80));
            int i = (size - 1) * 8;
            while (i >= 0) {
                this.write((byte)(length >> i));
                i -= 8;
            }
        } else {
            this.write((byte)length);
        }
    }

    void writeEncoded(int tag, byte[] bytes) throws IOException {
        this.write(tag);
        this.writeLength(bytes.length);
        this.write(bytes);
    }

    void writeTag(int flags, int tagNo) throws IOException {
        if (tagNo < 31) {
            this.write(flags | tagNo);
        } else {
            this.write(flags | 0x1F);
            if (tagNo < 128) {
                this.write(tagNo);
            } else {
                byte[] stack = new byte[5];
                int pos = stack.length;
                stack[--pos] = (byte)(tagNo & 0x7F);
                do {
                    stack[--pos] = (byte)((tagNo >>= 7) & 0x7F | 0x80);
                } while (tagNo > 127);
                this.write(stack, pos, stack.length - pos);
            }
        }
    }

    void writeEncoded(int flags, int tagNo, byte[] bytes) throws IOException {
        this.writeTag(flags, tagNo);
        this.writeLength(bytes.length);
        this.write(bytes);
    }

    protected void writeNull() throws IOException {
        this.write(5);
        this.write(0);
    }

    @Override
    public void write(byte[] buf) throws IOException {
        this.out.write(buf, 0, buf.length);
    }

    @Override
    public void write(byte[] buf, int offSet, int len) throws IOException {
        this.out.write(buf, offSet, len);
    }

    public void writeObject(Object obj) throws IOException {
        if (obj == null) {
            this.writeNull();
        } else if (obj instanceof DERObject) {
            ((DERObject)obj).encode(this);
        } else if (obj instanceof DEREncodable) {
            ((DEREncodable)obj).getDERObject().encode(this);
        } else {
            throw new IOException("object not DEREncodable");
        }
    }
}

