/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;

public class MultiCollector
extends Collector {
    private final Collector[] collectors;

    public static Collector wrap(Collector ... collectors) {
        int n = 0;
        Collector[] collectorArray = collectors;
        int n2 = collectors.length;
        int n3 = 0;
        while (n3 < n2) {
            Collector c = collectorArray[n3];
            if (c != null) {
                ++n;
            }
            ++n3;
        }
        if (n == 0) {
            throw new IllegalArgumentException("At least 1 collector must not be null");
        }
        if (n == 1) {
            Collector col = null;
            Collector[] collectorArray2 = collectors;
            int n4 = collectors.length;
            n2 = 0;
            while (n2 < n4) {
                Collector c = collectorArray2[n2];
                if (c != null) {
                    col = c;
                    break;
                }
                ++n2;
            }
            return col;
        }
        if (n == collectors.length) {
            return new MultiCollector(collectors);
        }
        Collector[] colls = new Collector[n];
        n = 0;
        Collector[] collectorArray3 = collectors;
        int n5 = collectors.length;
        n2 = 0;
        while (n2 < n5) {
            Collector c = collectorArray3[n2];
            if (c != null) {
                colls[n++] = c;
            }
            ++n2;
        }
        return new MultiCollector(colls);
    }

    private MultiCollector(Collector ... collectors) {
        this.collectors = collectors;
    }

    @Override
    public boolean acceptsDocsOutOfOrder() {
        Collector[] collectorArray = this.collectors;
        int n = this.collectors.length;
        int n2 = 0;
        while (n2 < n) {
            Collector c = collectorArray[n2];
            if (!c.acceptsDocsOutOfOrder()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public void collect(int doc) throws IOException {
        Collector[] collectorArray = this.collectors;
        int n = this.collectors.length;
        int n2 = 0;
        while (n2 < n) {
            Collector c = collectorArray[n2];
            c.collect(doc);
            ++n2;
        }
    }

    @Override
    public void setNextReader(AtomicReaderContext context) throws IOException {
        Collector[] collectorArray = this.collectors;
        int n = this.collectors.length;
        int n2 = 0;
        while (n2 < n) {
            Collector c = collectorArray[n2];
            c.setNextReader(context);
            ++n2;
        }
    }

    @Override
    public void setScorer(Scorer s) throws IOException {
        Collector[] collectorArray = this.collectors;
        int n = this.collectors.length;
        int n2 = 0;
        while (n2 < n) {
            Collector c = collectorArray[n2];
            c.setScorer(s);
            ++n2;
        }
    }
}

