/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.SnapshotDeletionPolicy;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.IOUtils;

public class PersistentSnapshotDeletionPolicy
extends SnapshotDeletionPolicy {
    public static final String SNAPSHOTS_PREFIX = "snapshots_";
    private static final int VERSION_START = 0;
    private static final int VERSION_CURRENT = 0;
    private static final String CODEC_NAME = "snapshots";
    private long nextWriteGen;
    private final Directory dir;

    public PersistentSnapshotDeletionPolicy(IndexDeletionPolicy primary, Directory dir) throws IOException {
        this(primary, dir, IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
    }

    public PersistentSnapshotDeletionPolicy(IndexDeletionPolicy primary, Directory dir, IndexWriterConfig.OpenMode mode) throws IOException {
        super(primary);
        this.dir = dir;
        if (mode == IndexWriterConfig.OpenMode.CREATE) {
            this.clearPriorSnapshots();
        }
        this.loadPriorSnapshots();
        if (mode == IndexWriterConfig.OpenMode.APPEND && this.nextWriteGen == 0L) {
            throw new IllegalStateException("no snapshots stored in this directory");
        }
    }

    @Override
    public synchronized IndexCommit snapshot() throws IOException {
        IndexCommit ic = super.snapshot();
        boolean success = false;
        try {
            this.persist();
            success = true;
        }
        catch (Throwable throwable) {
            if (!success) {
                try {
                    super.release(ic);
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (!success) {
            try {
                super.release(ic);
            }
            catch (Exception exception) {}
        }
        return ic;
    }

    @Override
    public synchronized void release(IndexCommit commit) throws IOException {
        super.release(commit);
        boolean success = false;
        try {
            this.persist();
            success = true;
        }
        catch (Throwable throwable) {
            if (!success) {
                try {
                    this.incRef(commit);
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (!success) {
            try {
                this.incRef(commit);
            }
            catch (Exception exception) {}
        }
    }

    public synchronized void release(long gen) throws IOException {
        super.releaseGen(gen);
        this.persist();
    }

    private synchronized void persist() throws IOException {
        String lastSaveFile;
        String fileName = SNAPSHOTS_PREFIX + this.nextWriteGen;
        IndexOutput out = this.dir.createOutput(fileName, IOContext.DEFAULT);
        boolean success = false;
        try {
            CodecUtil.writeHeader(out, CODEC_NAME, 0);
            out.writeVInt(this.refCounts.size());
            for (Map.Entry ent : this.refCounts.entrySet()) {
                out.writeVLong((Long)ent.getKey());
                out.writeVInt((Integer)ent.getValue());
            }
            success = true;
        }
        catch (Throwable throwable) {
            if (!success) {
                IOUtils.closeWhileHandlingException(out);
                try {
                    this.dir.deleteFile(fileName);
                }
                catch (Exception exception) {}
            } else {
                IOUtils.close(out);
            }
            throw throwable;
        }
        if (!success) {
            IOUtils.closeWhileHandlingException(out);
            try {
                this.dir.deleteFile(fileName);
            }
            catch (Exception exception) {}
        } else {
            IOUtils.close(out);
        }
        this.dir.sync(Collections.singletonList(fileName));
        if (this.nextWriteGen > 0L && this.dir.fileExists(lastSaveFile = SNAPSHOTS_PREFIX + (this.nextWriteGen - 1L))) {
            this.dir.deleteFile(lastSaveFile);
        }
        ++this.nextWriteGen;
    }

    private synchronized void clearPriorSnapshots() throws IOException {
        String[] stringArray = this.dir.listAll();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            if (file.startsWith(SNAPSHOTS_PREFIX)) {
                this.dir.deleteFile(file);
            }
            ++n2;
        }
    }

    public String getLastSaveFile() {
        if (this.nextWriteGen == 0L) {
            return null;
        }
        return SNAPSHOTS_PREFIX + (this.nextWriteGen - 1L);
    }

    private synchronized void loadPriorSnapshots() throws IOException {
        long genLoaded = -1L;
        IOException ioe = null;
        ArrayList<String> snapshotFiles = new ArrayList<String>();
        String[] stringArray = this.dir.listAll();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            if (file.startsWith(SNAPSHOTS_PREFIX)) {
                long gen = Long.parseLong(file.substring(SNAPSHOTS_PREFIX.length()));
                if (genLoaded == -1L || gen > genLoaded) {
                    HashMap<Long, Integer> m;
                    block15: {
                        snapshotFiles.add(file);
                        m = new HashMap<Long, Integer>();
                        IndexInput in = this.dir.openInput(file, IOContext.DEFAULT);
                        try {
                            try {
                                CodecUtil.checkHeader(in, CODEC_NAME, 0, 0);
                                int count = in.readVInt();
                                int i = 0;
                                while (i < count) {
                                    long commitGen = in.readVLong();
                                    int refCount = in.readVInt();
                                    m.put(commitGen, refCount);
                                    ++i;
                                }
                            }
                            catch (IOException ioe2) {
                                if (ioe == null) {
                                    ioe = ioe2;
                                }
                                in.close();
                                break block15;
                            }
                        }
                        catch (Throwable throwable) {
                            in.close();
                            throw throwable;
                        }
                        in.close();
                    }
                    genLoaded = gen;
                    this.refCounts.clear();
                    this.refCounts.putAll(m);
                }
            }
            ++n2;
        }
        if (genLoaded == -1L) {
            if (ioe != null) {
                throw ioe;
            }
        } else {
            if (snapshotFiles.size() > 1) {
                String curFileName = SNAPSHOTS_PREFIX + genLoaded;
                for (String file : snapshotFiles) {
                    if (curFileName.equals(file)) continue;
                    this.dir.deleteFile(file);
                }
            }
            this.nextWriteGen = 1L + genLoaded;
        }
    }
}

