/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.viewer.celleditors;

import ca.infodata.ofys.ui.controls.viewer.AutoTabNextModifyListener;
import ca.infodata.ofys.ui.controls.viewer.SelectAllText;
import ca.infodata.ofys.ui.controls.viewer.TabNextAutoKeyListener;
import ca.infodata.ofys.ui.controls.viewer.celleditors.MyTextCellEditor;
import org.apache.commons.lang3.math.NumberUtils;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class JourTextCellEditor
extends MyTextCellEditor {
    public JourTextCellEditor(Composite arg0) {
        super(arg0);
        ((Text)this.getControl()).addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = JourTextCellEditor.this.verifyCode((Text)JourTextCellEditor.this.getControl(), e.character);
            }
        });
        ((Text)this.getControl()).addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 64 || e.detail == 32) {
                    e.doit = false;
                }
            }
        });
        ((Text)this.getControl()).addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000001) {
                    JourTextCellEditor.this.up();
                } else if (e.keyCode == 0x1000002) {
                    JourTextCellEditor.this.down();
                }
            }
        });
        ((Text)this.getControl()).setTextLimit(4);
        ((Text)this.getControl()).addModifyListener((ModifyListener)AutoTabNextModifyListener.getInstance());
        ((Text)this.getControl()).addKeyListener(TabNextAutoKeyListener.getInstance());
        ((Text)this.getControl()).addFocusListener((FocusListener)new SelectAllText());
    }

    boolean verifyCode(Text code, char newChar) {
        boolean doit = false;
        if (newChar == '\u0000' || newChar == '\b' || newChar == '\u007f') {
            doit = true;
        } else if (code.getText().length() <= 4) {
            if (code.getSelectionText().length() == 4 && code.getCaretPosition() == 4) {
                code.setText("");
            }
            if ("012345678".indexOf(newChar) > -1 && code.getCaretPosition() == 0) {
                doit = true;
            } else if ("012345678".indexOf(newChar) > -1 && code.getCaretPosition() == 1) {
                code.setText(String.valueOf(code.getText()) + ".");
                code.setSelection(2);
                doit = true;
            } else if (".".indexOf(newChar) > -1 && code.getCaretPosition() == 1) {
                doit = true;
            } else if ("05".indexOf(newChar) > -1 && code.getCaretPosition() == 3) {
                doit = true;
            }
        } else if (code.getSelection().x != code.getSelection().y) {
            doit = true;
        }
        return doit;
    }

    void up() {
        double value = 0.0;
        if (NumberUtils.isNumber((String)((Text)this.getControl()).getText())) {
            value = Double.parseDouble(((Text)this.getControl()).getText());
        }
        if ((value += 0.5) < 1.01) {
            ((Text)this.getControl()).setText(JourTextCellEditor.decFormat(value, 1, 2));
        }
    }

    void down() {
        double value = 1.5;
        if (NumberUtils.isNumber((String)((Text)this.getControl()).getText())) {
            value = Double.parseDouble(((Text)this.getControl()).getText());
        }
        if ((value -= 0.5) > -0.01) {
            ((Text)this.getControl()).setText(JourTextCellEditor.decFormat(value, 1, 2));
        }
    }
}

