/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.viewer.celleditors;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.ui.controls.viewer.AutoTabNextModifyListener;
import ca.infodata.ofys.ui.controls.viewer.SelectAllText;
import ca.infodata.ofys.ui.controls.viewer.TabNextAutoKeyListener;
import ca.infodata.ofys.ui.controls.viewer.celleditors.MyTextCellEditor;
import org.apache.commons.lang3.math.NumberUtils;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class HeureTextCellEditorRmx
extends MyTextCellEditor {
    static String INFO_HRE = Messages.getString((String)"HeureTextCellEditor.INFO_HRE", (String[])new String[0]);

    public HeureTextCellEditorRmx(Composite arg0) {
        super(arg0);
        ((Text)this.getControl()).addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = HeureTextCellEditorRmx.this.verifyCode((Text)HeureTextCellEditorRmx.this.getControl(), e.character);
            }
        });
        ((Text)this.getControl()).addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 64 || e.detail == 32) {
                    e.doit = false;
                }
            }
        });
        ((Text)this.getControl()).addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000001) {
                    HeureTextCellEditorRmx.this.up();
                } else if (e.keyCode == 0x1000002) {
                    HeureTextCellEditorRmx.this.down();
                }
            }
        });
        ((Text)this.getControl()).setTextLimit(5);
        ((Text)this.getControl()).addModifyListener((ModifyListener)AutoTabNextModifyListener.getInstance());
        ((Text)this.getControl()).addKeyListener(TabNextAutoKeyListener.getInstance());
        ((Text)this.getControl()).addFocusListener((FocusListener)new SelectAllText());
        ((Text)this.getControl()).addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
            }
        });
    }

    boolean verifyCode(Text code, char newChar) {
        boolean doit = false;
        if (newChar == '\u0000' || newChar == '\b' || newChar == '\u007f') {
            doit = true;
        } else if (code.getText().length() <= 5) {
            if (code.getSelectionText().length() == 5 && code.getCaretPosition() == 5) {
                code.setText("");
            }
            if (".".indexOf(newChar) > -1 && code.getCaretPosition() == 0) {
                code.setText("00.");
                code.setSelection(3);
                doit = false;
            } else if (".".indexOf(newChar) > -1 && code.getCaretPosition() == 1) {
                code.setText("0" + code.getText() + ".");
                code.setSelection(3);
                doit = false;
            } else if ("0123456789".indexOf(newChar) > -1 && (code.getCaretPosition() == 0 || code.getCaretPosition() == 1)) {
                doit = true;
            } else if ("0123456789".indexOf(newChar) > -1 && code.getCaretPosition() == 2) {
                code.setText(String.valueOf(code.getText()) + ".");
                code.setSelection(3);
                doit = true;
            } else if ("257".indexOf(newChar) > -1 && code.getCaretPosition() == 3) {
                doit = true;
            } else if ("05".indexOf(newChar) > -1 && code.getCaretPosition() == 4) {
                doit = true;
            }
        } else if (code.getSelection().x != code.getSelection().y) {
            doit = true;
        }
        return doit;
    }

    void up() {
        double value = 0.0;
        if (NumberUtils.isNumber((String)((Text)this.getControl()).getText())) {
            value = Double.parseDouble(((Text)this.getControl()).getText());
        }
        if ((value += 0.25) < 10.01) {
            ((Text)this.getControl()).setText(HeureTextCellEditorRmx.decFormat(value, 2, 2));
        }
    }

    void down() {
        double value = 10.25;
        if (NumberUtils.isNumber((String)((Text)this.getControl()).getText())) {
            value = Double.parseDouble(((Text)this.getControl()).getText());
        }
        if ((value -= 0.25) > -0.01) {
            ((Text)this.getControl()).setText(HeureTextCellEditorRmx.decFormat(value, 2, 2));
        }
    }
}

