/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.template;

import ca.infodata.ofys.client.modules.template.DDate;
import ca.infodata.ofys.client.modules.template.DField;
import ca.infodata.ofys.client.modules.template.DList;
import ca.infodata.ofys.client.modules.template.DNum;
import ca.infodata.ofys.client.modules.template.DRaw;
import ca.infodata.ofys.client.modules.template.DText;
import ca.infodata.ofys.client.modules.template.TemplateDefinitionParser;
import ca.infodata.ofys.client.modules.template.TypeDeDonnee;
import ca.infodata.ofys.client.modules.template.TypeDeMesure;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.ui.controls.ControlDecorator;
import ca.infodata.ofys.ui.controls.DateText;
import ca.infodata.ofys.ui.controls.MyMessageDialogBuilder;
import ca.infodata.ofys.ui.controls.calendarcombo.MyCalendarText;
import ca.infodata.ofys.ui.controls.form.ComplexNumberText;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TemplateAssistTextDialog
extends MyMessageDialogBuilder {
    private List<Control> lstListe = new ArrayList<Control>();
    private static final String RESULTAT = Messages.getString((String)"AssistantCompletionChoice.RESULTAT", (String[])new String[0]);
    private static final String OK = Messages.getString((String)"AssistantCompletionChoice.OK", (String[])new String[0]);
    private static final String CANCEL = Messages.getString((String)"AssistantCompletionChoice.ANNULER", (String[])new String[0]);
    protected static final String ET = Messages.getString((String)"AssistantCompletionChoice.ET", (String[])new String[0]);
    private List<DField> fields;
    private Map<DField, String> fieldsValue;
    private StyledText txtStyledText;
    private String writeText;
    private String displayText;
    private List<Mesure> lstMesures = new ArrayList<Mesure>();
    private List<Donnee> lstDonnees = new ArrayList<Donnee>();

    public TemplateAssistTextDialog(Shell shell, String name, List<DField> fields) {
        if (fields == null) {
            throw new NullPointerException("fields");
        }
        this.fields = fields;
        this.fieldsValue = new HashMap<DField, String>();
        this.setButtonLabels(OK, CANCEL);
        this.setParent(shell);
        this.setDefaultButton(0);
        this.setTitle(name);
    }

    public TemplateAssistTextDialog(Shell shell, String name, String text) {
        this.fields = new TemplateDefinitionParser().parse(text);
        this.fieldsValue = new HashMap<DField, String>();
        this.setButtonLabels(OK, CANCEL);
        this.setParent(shell);
        this.setDefaultButton(0);
        this.setTitle(name);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Control createCustomArea(Composite parent) {
        int n;
        ArrayList<DField> nonRawFields = new ArrayList<DField>();
        for (DField field : this.fields) {
            if (field instanceof DRaw) continue;
            nonRawFields.add(field);
        }
        Composite mainParent = new Composite(parent, 0);
        Composite fieldParent = new Composite(mainParent, 0);
        ArrayList<1> controls = new ArrayList<1>();
        for (DField field : nonRawFields) {
            FieldControl fieldControl = new FieldControl(fieldParent, field){

                @Override
                void onValueChange(DField field, String value) {
                    TemplateAssistTextDialog.this.fieldsValue.put(field, value);
                    TemplateAssistTextDialog.this.refreshText();
                }
            };
            if (field instanceof DList) {
                this.lstListe.add(fieldControl.control);
            }
            controls.add(fieldControl);
        }
        FormLayout layout = new FormLayout();
        layout.spacing = 5;
        fieldParent.setLayout((Layout)layout);
        HashMap<FieldControl, Point> sizes = new HashMap<FieldControl, Point>();
        for (FieldControl fieldControl : controls) {
            sizes.put(fieldControl, fieldControl.computeSize(-1, -1));
        }
        int n2 = UI.getWorkbenchShell().getDisplay().getClientArea().width;
        int maxHeight = UI.getWorkbenchShell().getDisplay().getClientArea().height - 150;
        for (Point size : sizes.values()) {
            maxHeight = Math.max(maxHeight, size.y);
        }
        ArrayList grid = new ArrayList();
        ArrayList<Control> column = new ArrayList<Control>();
        grid.add(column);
        int colNo = 0;
        HashMap<Integer, Integer> widthColumn = new HashMap<Integer, Integer>();
        int totalWidth = 0;
        int h = 0;
        for (Control control : controls) {
            Object width;
            Point point = (Point)sizes.get(control);
            if (h + point.y > maxHeight) {
                column = new ArrayList();
                h = 0;
                grid.add(column);
                widthColumn.put(new Integer(++colNo), null);
            }
            if ((width = (Integer)widthColumn.get(colNo)) == null || (Integer)width < point.x) {
                widthColumn.put(new Integer(colNo), new Integer(point.x));
            }
            column.add(control);
            h += point.y;
        }
        for (Integer n3 : widthColumn.values()) {
            totalWidth += n3.intValue();
        }
        int n4 = 400;
        if ((totalWidth += n4) > n2) {
            float ratio = (float)totalWidth / (float)n2;
            for (Map.Entry entry : widthColumn.entrySet()) {
                entry.setValue(new Integer((int)((float)((Integer)entry.getValue()).intValue() / ratio)));
            }
            n = new Integer((int)((float)n4 / ratio));
        }
        Control topControl = null;
        Object var18_31 = null;
        int i = 0;
        while (i < grid.size()) {
            List c = (List)grid.get(i);
            for (Control control : c) {
                void var18_32;
                FormData data = new FormData();
                data.top = topControl == null ? new FormAttachment(0) : new FormAttachment(topControl);
                data.left = var18_32 == null ? new FormAttachment(0) : new FormAttachment((Control)var18_32);
                data.width = widthColumn.containsKey(new Integer(i)) ? (Integer)widthColumn.get(new Integer(i)) : 140;
                control.setLayoutData((Object)data);
                topControl = control;
            }
            topControl = null;
            Control control = c.isEmpty() ? null : (Control)c.get(0);
            ++i;
        }
        Composite displayParent = new Composite(mainParent, 0);
        Label lblTxtTextToWrite = new Label(displayParent, 0);
        lblTxtTextToWrite.setText(RESULTAT);
        this.txtStyledText = new StyledText(displayParent, 2882);
        this.txtStyledText.setEditable(false);
        displayParent.setLayout((Layout)new FormLayout());
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.width = n;
        lblTxtTextToWrite.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)lblTxtTextToWrite);
        data.left = new FormAttachment(0);
        data.bottom = new FormAttachment(100);
        data.width = n;
        this.txtStyledText.setLayoutData((Object)data);
        layout = new FormLayout();
        mainParent.setLayout((Layout)layout);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.bottom = new FormAttachment(100);
        fieldParent.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment((Control)fieldParent, 20);
        data.bottom = new FormAttachment(100);
        data.right = new FormAttachment(100);
        displayParent.setLayoutData((Object)data);
        parent.setLayout((Layout)new FillLayout());
        this.refreshText();
        return mainParent;
    }

    protected void refreshText() {
        this.generateText();
        if (this.txtStyledText != null) {
            this.txtStyledText.setText(this.displayText);
        }
    }

    private void generateText() {
        this.lstMesures.clear();
        this.lstDonnees.clear();
        StringBuilder displayB = new StringBuilder(this.fields.size() * 50);
        StringBuilder writeB = new StringBuilder(this.fields.size() * 50);
        for (DField f : this.fields) {
            if (f instanceof DRaw) {
                displayB.append(((DRaw)f).raw);
                writeB.append(((DRaw)f).raw);
                continue;
            }
            String value = this.fieldsValue.get(f);
            if (StringUtils.isNotBlank((String)value)) {
                displayB.append(value);
                writeB.append(value);
                if (f instanceof DNum) {
                    if (((DNum)f).typeDeMesure == null || ((DNum)f).typeDeMesure.equals((Object)TypeDeMesure.S_O)) continue;
                    this.lstMesures.add(new Mesure(((DNum)f).typeDeMesure, value));
                    displayB.append(((DNum)f).typeDeMesure.getUnite());
                    writeB.append(((DNum)f).typeDeMesure.getUnite());
                    continue;
                }
                if (f instanceof DText) {
                    if (((DText)f).typeDeDonnee == null || ((DText)f).typeDeDonnee.equals((Object)TypeDeDonnee.S_O)) continue;
                    if (((DText)f).typeDeDonnee.equals((Object)TypeDeDonnee.DET_EP)) {
                        this.lstDonnees.add(new Donnee(((DText)f).typeDeDonnee, String.valueOf(f.name) + " " + value));
                        continue;
                    }
                    this.lstDonnees.add(new Donnee(((DText)f).typeDeDonnee, value));
                    continue;
                }
                if (!(f instanceof DList) || ((DList)f).typeDeDonnee == null || TypeDeDonnee.S_O.equals((Object)((DList)f).typeDeDonnee)) continue;
                if (((DList)f).typeDeDonnee.equals((Object)TypeDeDonnee.DET_EP)) {
                    this.lstDonnees.add(new Donnee(((DList)f).typeDeDonnee, String.valueOf(f.name) + " " + value));
                    continue;
                }
                this.lstDonnees.add(new Donnee(((DList)f).typeDeDonnee, value));
                continue;
            }
            displayB.append("[" + f.name + "]");
        }
        this.displayText = displayB.toString();
        this.writeText = writeB.toString();
    }

    public final String getWriteText() {
        return this.writeText;
    }

    public final List<Mesure> getLstMesures() {
        return this.lstMesures;
    }

    public final List<Donnee> getLstDonnees() {
        return this.lstDonnees;
    }

    @Override
    protected boolean customShouldTakeFocus() {
        return true;
    }

    @Override
    protected boolean buttonPressed(int buttonId) {
        return true;
    }

    public final List<Control> getLstListe() {
        return this.lstListe;
    }

    public static void main(String[] args) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new DRaw("\nDate "));
        list.add(new DDate("Date", null, null, null, false));
        list.add(new DRaw("\nTexte libre : "));
        list.add(new DText("Texte libre : ", null, false, null, Boolean.valueOf(false)));
        list.add(new DRaw("\nTexte max 10 : "));
        list.add(new DText("Texte max 10 : ", Integer.valueOf(10), false, null, Boolean.valueOf(false)));
        list.add(new DRaw("\nListe "));
        list.add(new DList("Raison", ", ", true, Boolean.TRUE, null, new String[]{"R1", "R2", "R3"}));
        list.add(new DRaw("\nChiffre : "));
        list.add(new DNum("Chiffre", null, null, null, false));
        list.add(new DRaw("\nChiffre entre 0 et 9 : "));
        list.add(new DNum("Chiffre entre 0 et 9 : ", (Number)9, null, null, false));
        list.add(new DRaw("\nChiffre entre 0.00 et 9.99 : "));
        list.add(new DNum("Chiffre entre 0.00 et 9.99 : ", (Number)9, Integer.valueOf(2), null, false));
        TemplateDefinitionParser parser = new TemplateDefinitionParser();
        String s = parser.format(list);
        Display display = new Display();
        Shell shell = new Shell(display);
        TemplateAssistTextDialog d = new TemplateAssistTextDialog(shell, "Test", s);
        d.buildAndOpen();
        shell.pack();
        shell.setSize(400, 400);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public static class Donnee {
        final TypeDeDonnee type;
        final String value;

        public Donnee(TypeDeDonnee type, String value) {
            this.type = type;
            this.value = value;
        }

        public final TypeDeDonnee getType() {
            return this.type;
        }

        public final String getValue() {
            return this.value;
        }
    }

    public static abstract class FieldControl
    extends Composite {
        DField field;
        Label label;
        Control control;

        public FieldControl(Composite parent, final DField field) {
            super(parent, 0);
            this.field = field;
            this.label = new Label((Composite)this, 16384);
            this.label.setText(field.name);
            if (field instanceof DText) {
                final DText dtext = (DText)field;
                int style = 2048;
                if (dtext.wrap != null && dtext.wrap.booleanValue()) {
                    style |= 2;
                }
                final Text text = new Text(this, style){

                    public Point computeSize(int wHint, int hHint, boolean changed) {
                        Point size = super.computeSize(wHint, hHint, changed);
                        if (dtext.height != null) {
                            size.y = dtext.height;
                        }
                        if (dtext.width != null) {
                            size.x = dtext.width;
                        }
                        return size;
                    }

                    protected void checkSubclass() {
                    }
                };
                text.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        this.onValueChange(field, text.getText());
                    }
                });
                if (dtext.maxLen != null) {
                    text.setTextLimit(dtext.maxLen.intValue());
                }
                if (dtext.typeDeDonnee != null && !dtext.typeDeDonnee.equals((Object)TypeDeDonnee.S_O)) {
                    text.setBackground(ResourceGetter.getColor((int)192, (int)255, (int)192));
                    if (dtext.typeDeDonnee.equals((Object)TypeDeDonnee.DET_EP)) {
                        text.setToolTipText(Messages.getString((String)"AUTO_ADD_DETAILS_EX", (String[])new String[0]));
                    } else {
                        text.setToolTipText(Messages.getString((String)"AUTO_ADD_DX", (String[])new String[0]));
                    }
                }
                this.control = text;
            } else if (field instanceof DList) {
                DList dList = (DList)field;
                int style = 2560;
                if (dList.multiple != null && dList.multiple.booleanValue()) {
                    style |= 2;
                }
                final org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List((Composite)this, style);
                String[] items = new String[((DList)field).items.length + 1];
                items[0] = "";
                int i = 1;
                while (i < items.length) {
                    items[i] = ((DList)field).items[i - 1];
                    ++i;
                }
                list.setItems(items);
                list.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        String s = "";
                        int k = 0;
                        while (k < list.getSelectionCount()) {
                            String selTxt = list.getSelection()[k];
                            s = k == 0 ? selTxt : String.valueOf(s) + (k == list.getSelectionCount() - 1 ? " " + ET : ", ") + selTxt;
                            ++k;
                        }
                        this.onValueChange(field, s);
                    }
                });
                list.addKeyListener(new KeyListener(){

                    public void keyPressed(KeyEvent e) {
                        if (e.character == '\u0000') {
                            org.eclipse.swt.widgets.List w = (org.eclipse.swt.widgets.List)e.widget;
                            if (e.keyCode == 0x1000001 && w.getSelectionIndex() == 0) {
                                e.doit = false;
                                w.setSelection(w.getItemCount() - 1);
                            } else if (e.keyCode == 0x1000002 && w.getSelectionIndex() == w.getItemCount() - 1) {
                                e.doit = false;
                                w.setSelection(0);
                            }
                        }
                    }

                    public void keyReleased(KeyEvent e) {
                    }
                });
                list.setSelection(dList.defaultItem + 1);
                list.addFocusListener(new FocusListener(){

                    public void focusGained(FocusEvent e) {
                        if (((org.eclipse.swt.widgets.List)e.widget).getSelectionCount() == 0) {
                            ((org.eclipse.swt.widgets.List)e.widget).select(0);
                        }
                    }

                    public void focusLost(FocusEvent e) {
                    }
                });
                if (dList.typeDeDonnee != null && !dList.typeDeDonnee.equals((Object)TypeDeDonnee.S_O)) {
                    list.setBackground(ResourceGetter.getColor((int)192, (int)255, (int)192));
                    if (dList.typeDeDonnee.equals((Object)TypeDeDonnee.DET_EP)) {
                        list.setToolTipText(Messages.getString((String)"AUTO_ADD_DETAILS_EX", (String[])new String[0]));
                    } else {
                        list.setToolTipText(Messages.getString((String)"AUTO_ADD_DX", (String[])new String[0]));
                    }
                }
                this.control = list;
            } else if (field instanceof DNum) {
                DNum num = (DNum)field;
                final ComplexNumberText text = new ComplexNumberText((Composite)this, 2048);
                if (num.digits != null) {
                    text.setScale(num.digits);
                }
                if (num.max != null) {
                    text.setPrecision(num.max.intValue());
                }
                text.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        this.onValueChange(field, text.getText());
                    }
                });
                if (!num.typeDeMesure.equals((Object)TypeDeMesure.S_O)) {
                    text.setBackground(ResourceGetter.getColor((int)192, (int)255, (int)192));
                    text.setToolTipText(Messages.getString((String)"AUTO_ADD_MESURES", (String[])new String[0]));
                }
                this.control = text.getControl();
            } else if (field instanceof DDate) {
                final DDate dd = (DDate)field;
                final MyCalendarText text = new MyCalendarText((Composite)this, 2048);
                text.getTextControl().setAllowPartial(true);
                text.addDateListener(new DateText.DateAdapter(){

                    @Override
                    public void partialChanged(IPartialDate date) {
                        text.getTextControl().setForeground(null);
                        if (dd.allowPast != null && !dd.allowPast.booleanValue() && date != null && date.before((IPartialDate)LocalDate.today())) {
                            text.getTextControl().setForeground(ResourceGetter.getColor((int)255, (int)0, (int)0));
                        }
                        if (dd.allowFuture != null && !dd.allowFuture.booleanValue() && date != null && date.after((IPartialDate)LocalDate.today())) {
                            text.getTextControl().setForeground(ResourceGetter.getColor((int)255, (int)0, (int)0));
                        }
                        this.onValueChange(field, date == null ? "" : date.formatSlash());
                    }
                });
                if (dd.todayAuto != null && dd.todayAuto.booleanValue()) {
                    text.setDate((IPartialDate)LocalDate.today());
                }
                this.control = text;
            }
            if (field.required && this.control != null) {
                ControlDecorator.decorateWithRequiredField(this.control);
            }
            FormLayout layout = new FormLayout();
            layout.spacing = 5;
            this.setLayout((Layout)layout);
            FormData data = new FormData();
            data.top = new FormAttachment(0);
            data.left = new FormAttachment(0);
            this.label.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment((Control)this.label);
            data.left = new FormAttachment(0);
            data.right = new FormAttachment(100);
            this.control.setLayoutData((Object)data);
        }

        abstract void onValueChange(DField var1, String var2);
    }

    public static class Mesure {
        final TypeDeMesure type;
        final String value;

        public Mesure(TypeDeMesure type, String value) {
            this.type = type;
            this.value = value;
        }

        public final TypeDeMesure getType() {
            return this.type;
        }

        public final String getValue() {
            return this.value;
        }

        public final boolean isOneOf(TypeDeMesure ... type) {
            TypeDeMesure[] typeDeMesureArray = type;
            int n = type.length;
            int n2 = 0;
            while (n2 < n) {
                TypeDeMesure t = typeDeMesureArray[n2];
                if (t.equals((Object)this.type)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

