/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.report2;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.IPrintController;
import ca.infodata.ofys.client.web.core.IServerRequest;
import ca.infodata.ofys.client.web.core.WebApplication;
import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.ReportAccessorClient;
import ca.infodata.ofys.data.middle.dataobjects.IDDataObject;
import ca.infodata.ofys.data.middle.dataobjects.LightweightReport;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.ReportProperties;
import ca.infodata.ofys.data.middle.dataobjects.XFinishedDocument;
import ca.infodata.ofys.data.middle.dataobjects.XFinishedReport;
import ca.infodata.ofys.data.middle.dataobjects.XReportContainer;
import ca.infodata.ofys.data.middle.dataobjects.XReportReturnContainer;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IReport;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IReportCategory;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.properties.IReportProperty;
import ca.infodata.ofys.data.middle.dataobjects.properties.report.NumberOfCopiesProperty;
import ca.infodata.ofys.data.middle.dataobjects.properties.report.Orientation;
import ca.infodata.ofys.data.middle.dataobjects.properties.report.OrientationProperty;
import ca.infodata.ofys.data.middle.dataobjects.properties.report.PageFormat2Property;
import ca.infodata.ofys.data.middle.dataobjects.properties.report.PrintMode;
import ca.infodata.ofys.data.middle.dataobjects.properties.report.PrintModeProperty;
import ca.infodata.ofys.data.middle.dataobjects.properties.report.PrinterProperty;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.ofys.status.StatusException;
import ca.infodata.ofys.ui.controls.IProgressMonitor2;
import ca.infodata.ofys.ui.controls.report2.ProgressMonitor2Callback;
import ca.infodata.ofys.ui.controls.report2.ReportCallback;
import ca.infodata.ofys.ui.controls.util.IDialogSettings3;
import ca.infodata.ofys.ui.controls.util.MyDialogSettings;
import ca.infodata.ofys.ui.library.LibPlugin;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.pdf.PrintPdfX;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;

public class PrintController
implements IPrintController {
    private static final String ERREUR_IMPRIMANTE = Messages.getString((String)"PrintController.ERREUR_IMPRIMANTE", (String[])new String[0]);
    private static final String AUCUN_RAPPORT_DE_SELECTIONNE = Messages.getString((String)"PrintController.AUCUN_RAPPORT_DE_SELECTIONNE", (String[])new String[0]);
    private static final Logger logger = Logger.getLogger(PrintController.class.getName());
    private static final String CHECKED = "CHECKED";
    private static final String SHOW_IN_PDF = "SHOW_IN_PDF";
    private static final String DEFAULT_PRINTER = "DEFAULT_PRINTER";
    private String preferenceDefaultPrinter;
    private String systemDefaultPrinter;
    private String[] printers;
    private Serializable dataObject;
    private String localDocumentFileName;
    private String keyContext;
    private List<IReportCategory> reportCategories;
    private Set<IReport> selectedReports;
    private boolean showInPdf;
    private Map<String, ReportProperties> defaultProperties;
    private MyDialogSettings settings;
    private IDialogSettings3 treeSettings;
    private IDialogSettings3 globalSettings;
    private boolean rdpSession;
    private String rdpClientName;
    private String nip = null;

    public PrintController(Serializable dataObject, String keyContext, String localFileName) {
        this(dataObject, keyContext);
        this.localDocumentFileName = localFileName;
    }

    public PrintController(Serializable dataObject, String keyContext) {
        this.dataObject = dataObject;
        if (this.keyContext != null) {
            this.keyContext = keyContext;
        } else if (this.dataObject instanceof Collection) {
            Collection c = (Collection)((Object)this.dataObject);
            if (c.size() > 0) {
                this.keyContext = c.iterator().next().getClass().getSimpleName();
            }
        } else if (this.dataObject instanceof IDDataObject) {
            IDDataObject idDataObject = (IDDataObject)this.dataObject;
            this.keyContext = idDataObject.getReferingClass().getSimpleName();
        } else {
            this.keyContext = this.dataObject.getClass().getSimpleName();
        }
        this.settings = new MyDialogSettings(".print.xml", "root");
        this.globalSettings = this.settings.getOrCreateSection("global");
        this.treeSettings = this.settings.getOrCreateSection("tree");
        this.showInPdf = this.globalSettings.getBoolean(this.computeKey(SHOW_IN_PDF));
        this.selectedReports = new HashSet<IReport>();
        this.rdpSession = LibPlugin.getDefault().getRdpStateMonitor().isRdpSession();
        this.rdpClientName = LibPlugin.getDefault().getRdpStateMonitor().getClientName();
    }

    public List<IReportCategory> getCategories() {
        return this.reportCategories;
    }

    public List<IReport> getReports(IReportCategory category) {
        return category.getReports();
    }

    public Set<IReport> getSelection() {
        return this.selectedReports;
    }

    public void printXml() throws Exception {
        Set<IReport> lstReport = this.getSelection();
        if (lstReport.isEmpty()) {
            throw new StatusException((IStatus)new Status(IStatus.Severity.WARNING, AUCUN_RAPPORT_DE_SELECTIONNE));
        }
        for (IReport report : lstReport) {
            report.getProperties().setOutput("xml");
        }
        XReportContainer reportContainerToSend = new XReportContainer();
        reportContainerToSend.setLstReport(lstReport);
        ReportCallback callback = new ReportCallback("XML", this.showInPdf, false, BaseAccessorClient.defaultStatusHandler);
        callback.setDataObject(this.dataObject);
        callback.setReportContainer(reportContainerToSend);
        try {
            ReportAccessorClient.getInstance().getFinishedReports(this.dataObject.hashCode(), this.nip, Application.get().getGlobalInstances().getSession(), this.dataObject, reportContainerToSend, (ICallback)callback);
        }
        catch (CannotConnectToServerException e) {
            if (callback != null && !callback.killed()) {
                callback.kill();
            }
            throw e;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to getFinisedReports " + reportContainerToSend + ", with object " + this.dataObject);
            if (callback != null && !callback.killed()) {
                callback.kill();
            }
            throw e;
        }
    }

    public Map<IReport, XFinishedReport> printSync() throws Exception {
        XReportReturnContainer container;
        XReportContainer reportContainerToSend = this.getReportContainerToSend();
        ReturnObject ro = ReportAccessorClient.getInstance().getFinishedReportsSync(this.dataObject.hashCode(), this.nip, Application.get().getGlobalInstances().getSession(), this.dataObject, reportContainerToSend);
        if (ro != null && ro.getStatus() != null && ro.getStatus().isOkToProceed() && (container = (XReportReturnContainer)ro.getObj()) != null) {
            return container.getPdfTypeXFinishedReport();
        }
        return Collections.emptyMap();
    }

    public void print() throws Exception {
        IReport report;
        XReportContainer reportContainerToSend = this.getReportContainerToSend();
        ReportCallback callback = null;
        if (this.getSelection().size() == 1 && (report = this.getSelection().iterator().next()) instanceof LightweightReport && ((LightweightReport)report).getFinishedReport() != null) {
            LightweightReport lwr = (LightweightReport)report;
            String repOutput = "PDF";
            if ("csv".equals(report.getProperties().getValue("output", (Object)"pdf"))) {
                repOutput = "CSV";
                this.showInPdf = false;
            }
            callback = new ReportCallback(repOutput, this.showInPdf, false, lwr.getFinishedReport(), lwr.getNumberOfDocuments(), BaseAccessorClient.defaultStatusHandler);
        }
        if (callback == null) {
            callback = new ReportCallback("PDF", this.showInPdf, false, BaseAccessorClient.defaultStatusHandler);
        }
        callback.setDataObject(this.dataObject);
        callback.setReportContainer(reportContainerToSend);
        try {
            ReportAccessorClient.getInstance().getFinishedReports(this.dataObject.hashCode(), this.nip, Application.get().getGlobalInstances().getSession(), this.dataObject, reportContainerToSend, (ICallback)callback);
        }
        catch (CannotConnectToServerException e) {
            if (callback != null && !callback.killed()) {
                callback.kill();
            }
            throw e;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to getFinisedReports " + reportContainerToSend + ", with object " + this.dataObject);
            if (callback != null && !callback.killed()) {
                callback.kill();
            }
            throw e;
        }
    }

    private XReportContainer getReportContainerToSend() {
        Set<IReport> lstReport = this.getSelection();
        if (lstReport.isEmpty()) {
            throw new StatusException((IStatus)new Status(IStatus.Severity.WARNING, AUCUN_RAPPORT_DE_SELECTIONNE));
        }
        if (!this.showInPdf) {
            String defaultPrinter = this.getDefaultPrinter();
            for (IReport report : lstReport) {
                String printer = report.getProperties().getPrinter(null);
                if (printer == null) {
                    report.getProperties().setPrinter(defaultPrinter);
                    continue;
                }
                if (this.isPrinterInPrinterList(printer)) continue;
                throw new StatusException((IStatus)new Status(IStatus.Severity.WARNING, String.valueOf(ERREUR_IMPRIMANTE) + printer));
            }
        }
        if (this.showInPdf) {
            for (IReport report : lstReport) {
                report.getProperties().put((IReportProperty)new PrintModeProperty(PrintMode.ACTUAL_SIZE));
            }
        }
        for (IReport report : lstReport) {
            if (this.localDocumentFileName != null && new File(this.localDocumentFileName).exists()) {
                report.getProperties().put("localDocumentfileName", (Serializable)((Object)this.localDocumentFileName));
            }
            if ("csv".equals(report.getProperties().getValue("output", (Object)"pdf"))) {
                report.getProperties().setOutput("csv");
                continue;
            }
            report.getProperties().setOutput("pdf");
        }
        XReportContainer reportContainerToSend = new XReportContainer();
        reportContainerToSend.setLstReport(lstReport);
        return reportContainerToSend;
    }

    public void loadReports(IProgressMonitor2 monitor) {
        ProgressMonitor2Callback callback = new ProgressMonitor2Callback(monitor){

            @Override
            public void responseReceivedOverride(ReturnObject response) throws Exception {
                XReportContainer container = (XReportContainer)response.getObj();
                if (container == null || container.getCategories() == null) {
                    PrintController.this.loaded(new ArrayList<IReportCategory>());
                } else {
                    PrintController.this.loaded(new ArrayList<IReportCategory>(container.getCategories()));
                }
            }
        };
        try {
            ReportAccessorClient.getInstance().getReports(this.dataObject.hashCode(), this.nip, Application.get().getGlobalInstances().getSession(), (ICallback)callback, this.dataObject);
        }
        catch (CannotConnectToServerException e) {
            callback.exception((Exception)((Object)e));
            if (callback != null) {
                callback.kill();
            }
        }
        catch (Exception e) {
            callback.exception(e);
            if (callback != null) {
                callback.kill();
            }
            logger.log(Level.SEVERE, "Failed to getReports for object " + this.dataObject, e);
        }
    }

    protected void loaded(ArrayList<IReportCategory> list) {
        this.reportCategories = list;
        if (this.reportCategories != null) {
            for (IReportCategory c : this.reportCategories) {
                for (IReport report : this.getReports(c)) {
                    this.addDefaultPropertiesTo(report.getId(), report.getProperties());
                    String sectionKey = this.computeKey(report);
                    IDialogSettings3 section = this.treeSettings.getSection(sectionKey);
                    if (section == null) continue;
                    String checked = section.get(CHECKED);
                    if ("1".equals(checked)) {
                        this.selectedReports.add(report);
                    }
                    this.setReportPropertiesFromDialogSettings(section, report.getProperties());
                }
            }
        }
    }

    private void setReportPropertiesFromDialogSettings(IDialogSettings3 ds, ReportProperties referenceProperties) {
        for (IReportProperty p : referenceProperties) {
            Object value;
            String xml;
            String name = p.name();
            if (this.rdpSession && this.isThisAnRdpProperty(p.name())) {
                name = String.valueOf(this.rdpClientName) + "." + p.name();
            }
            if ((xml = ds.get(name)) == null || (value = p.fromXml(xml)) == null) continue;
            p.setValue(value);
        }
    }

    private void addDefaultPropertiesTo(String reportId, ReportProperties properties) {
        ReportProperties reportProperties;
        if (properties.getValue("numberofcopies", null) == null) {
            properties.put((IReportProperty)new NumberOfCopiesProperty(Integer.valueOf(1)));
        }
        if (properties.getValue("orientation", null) == null) {
            properties.put((IReportProperty)new OrientationProperty(Orientation.PORTRAIT));
        }
        properties.put((IReportProperty)new PrinterProperty(null));
        properties.put((IReportProperty)new PageFormat2Property(null));
        if (this.defaultProperties != null && this.defaultProperties.size() > 0 && (reportProperties = this.defaultProperties.get(reportId)) != null) {
            for (IReportProperty p : reportProperties) {
                properties.put(p);
            }
        }
    }

    public String getDefaultPrinter() {
        String printer = this.getPreferenceDefaultPrinter();
        if (printer == null) {
            printer = this.getSystemDefaultPrinter();
        }
        return printer;
    }

    public String getSystemDefaultPrinter() {
        if (this.systemDefaultPrinter == null) {
            this.systemDefaultPrinter = LibPlugin.getDefault().getPrinterList().getDefaultPrinter();
        }
        return this.systemDefaultPrinter;
    }

    public String getPreferenceDefaultPrinter() {
        if (this.preferenceDefaultPrinter == null) {
            String key = this.computePreferenceDefaultPrinterKey();
            this.preferenceDefaultPrinter = this.globalSettings.get(key);
        }
        return this.preferenceDefaultPrinter;
    }

    public void setDefaultPrinter(String printer) {
        this.preferenceDefaultPrinter = printer;
        String key = this.computePreferenceDefaultPrinterKey();
        if (printer == null) {
            this.globalSettings.removeItem(key);
        } else {
            this.globalSettings.put(key, printer);
        }
        this.savePreferences();
    }

    public boolean isPrinterInPrinterList(String printer) {
        Object[] printerList = this.getPrinterList();
        int index = Arrays.binarySearch(printerList, printer);
        return index >= 0;
    }

    public String[] getPrinterList() {
        if (this.printers == null) {
            this.printers = LibPlugin.getDefault().getPrinterList().getPrinters();
        }
        return this.printers;
    }

    public void setUseJavaPrinterList(boolean b) {
        this.printers = null;
        LibPlugin.getDefault().setUseJavaPrinterList(b);
    }

    public boolean isUseJavaPrinterList() {
        return LibPlugin.getDefault().isUseJavaPrinterList();
    }

    public String computeKey(IReport report) {
        return String.valueOf(this.keyContext) + "." + report.getId();
    }

    public String computeKey(IReportCategory category) {
        return String.valueOf(this.keyContext) + "." + category.getId();
    }

    private String computeKey(String key1) {
        return String.valueOf(this.keyContext) + "." + key1;
    }

    private String computePreferenceDefaultPrinterKey() {
        if (this.rdpSession) {
            return String.valueOf(this.settings.getKeyPrefix()) + this.rdpClientName + "." + DEFAULT_PRINTER;
        }
        return String.valueOf(this.settings.getKeyPrefix()) + DEFAULT_PRINTER;
    }

    public IDialogSettings3 getPreferences(IReportCategory category) {
        String key = this.computeKey(category);
        IDialogSettings3 section = this.treeSettings.getSection(key);
        if (section == null) {
            section = this.treeSettings.addNewSection(key);
        }
        return section;
    }

    public IDialogSettings3 getPreferences(IReport report) {
        String key = this.computeKey(report);
        IDialogSettings3 section = this.treeSettings.getSection(key);
        if (section == null) {
            section = this.treeSettings.addNewSection(key);
        }
        return section;
    }

    public void savePreferences(Collection<IReport> c) {
        for (IReport report : c) {
            this.savePreferencesReport(report, null);
        }
        this.savePreferences();
    }

    public void savePreferences(IReport report, Collection<IReportProperty<?>> modifiedProperties) {
        this.savePreferencesReport(report, modifiedProperties);
        this.savePreferences();
    }

    private void savePreferencesReport(IReport report, Collection<IReportProperty<?>> modifiedProperties) {
        String key = this.computeKey(report);
        IDialogSettings3 section = this.treeSettings.getSection(key);
        if (section == null) {
            section = this.treeSettings.addNewSection(key);
        }
        if (this.selectedReports.contains(report)) {
            section.put(CHECKED, "1");
        } else {
            section.put(CHECKED, "0");
        }
        if (modifiedProperties != null) {
            for (IReportProperty<?> p : modifiedProperties) {
                String name = p.name();
                if (this.rdpSession && this.isThisAnRdpProperty(p.name())) {
                    name = String.valueOf(this.rdpClientName) + "." + p.name();
                }
                section.put(name, p.toXml());
            }
        }
    }

    private boolean isThisAnRdpProperty(String name) {
        return "printer".equals(name) || "pageFormat".equals(name);
    }

    public void savePreferences() {
        this.settings.save();
    }

    public boolean getShowInPdf() {
        return this.showInPdf;
    }

    public void setShowInPdf(boolean showInPdf) {
        this.showInPdf = showInPdf;
        String key = this.computeKey(SHOW_IN_PDF);
        this.globalSettings.put(key, showInPdf);
        this.savePreferences();
    }

    public void setGlobalPreference(String key, String value) {
        String key2 = this.computeKey(key);
        this.globalSettings.put(key2, value);
    }

    public String getGlobalPreference(String key) {
        String key2 = this.computeKey(key);
        return this.globalSettings.get(key2);
    }

    public void eraseReportPropertyForAllReports(String propertyName) {
        IDialogSettings3[] sections;
        String prefix = this.settings.getKeyPrefix();
        if (this.rdpSession && this.isThisAnRdpProperty(propertyName)) {
            prefix = String.valueOf(prefix) + this.rdpClientName + ".";
        }
        String propertyName2 = String.valueOf(prefix) + propertyName;
        IDialogSettings3[] iDialogSettings3Array = sections = this.treeSettings.getSections();
        int n = sections.length;
        int n2 = 0;
        while (n2 < n) {
            IDialogSettings3 reportSection = iDialogSettings3Array[n2];
            Set<Map.Entry<String, Object>> items = reportSection.items();
            for (Map.Entry<String, Object> e : items) {
                String key = e.getKey();
                if (!propertyName2.equals(key)) continue;
                reportSection.removeItem(key);
            }
            ++n2;
        }
    }

    public void eraseAllReportPropertyForAllReports() {
        IDialogSettings3[] sections;
        String prefix = this.settings.getKeyPrefix();
        IDialogSettings3[] iDialogSettings3Array = sections = this.treeSettings.getSections();
        int n = sections.length;
        int n2 = 0;
        while (n2 < n) {
            IDialogSettings3 reportSection = iDialogSettings3Array[n2];
            Set<Map.Entry<String, Object>> items = reportSection.items();
            for (Map.Entry<String, Object> e : items) {
                String key = e.getKey();
                if (!key.startsWith(prefix)) continue;
                reportSection.removeItem(key);
            }
            ++n2;
        }
    }

    public String getRdpClientName() {
        return this.rdpClientName;
    }

    public boolean isRdpSession() {
        return this.rdpSession;
    }

    public void doResetReportService() {
        try {
            int uniqueKey = this.hashCode();
            boolean useFileAsSource = true;
            ReportAccessorClient.getInstance().reset(uniqueKey, useFileAsSource, Application.get().getGlobalInstances().getSession());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error reseting report service", e);
        }
    }

    public Map<String, ReportProperties> getDefaultProperties() {
        return this.defaultProperties;
    }

    public void setDefaultProperties(Map<String, ReportProperties> defaultProperties) {
        this.defaultProperties = defaultProperties;
    }

    public List<String> printSyncToUrl(IServerRequest.Browser browser) throws Exception {
        return this.printSyncToUrl();
    }

    public List<String> printSyncToUrl() throws Exception {
        if (Application.get().getPersonPluginController().getDirectPrint()) {
            List<String> printUrls = this.printSync().entrySet().stream().map(e -> {
                HashMap<PrintService, PageFormat> mapPS = null;
                try {
                    String returnUrl = "";
                    XFinishedReport fr = (XFinishedReport)e.getValue();
                    PrintService ps = PrintServiceLookup.lookupDefaultPrintService();
                    PageFormat pageFormat = PrintPdfX.defaultPageFormat((PrintService)ps);
                    double width = pageFormat.getWidth();
                    double height = pageFormat.getHeight();
                    for (XFinishedDocument fd : fr.getDocuments()) {
                        boolean hasPrinted = false;
                        PrintPdfX job = new PrintPdfX(fd.data);
                        double[] size = job.getFirstPageSize();
                        if (Math.abs(width - size[0]) < width * 0.15 && Math.abs(height - size[1]) < height * 0.15) {
                            try {
                                this.doDirectPrint(ps, pageFormat, "DirectPrint-", job);
                                hasPrinted = true;
                            }
                            catch (Exception exception) {
                                logger.log(Level.SEVERE, "Failed to print report " + ((IReport)e.getKey()).toString() + ", with object " + this.dataObject);
                            }
                        } else {
                            if (mapPS == null) {
                                PrintService[] printServices;
                                mapPS = new HashMap<PrintService, PageFormat>();
                                PrintService[] printServiceArray = printServices = PrintServiceLookup.lookupPrintServices(null, null);
                                int n = printServices.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    PrintService psc = printServiceArray[n2];
                                    PageFormat pf = PrintPdfX.defaultPageFormat((PrintService)psc);
                                    mapPS.put(psc, pf);
                                    ++n2;
                                }
                            }
                            for (Map.Entry prtSrv : mapPS.entrySet()) {
                                try {
                                    double w = ((PageFormat)prtSrv.getValue()).getWidth();
                                    double h = ((PageFormat)prtSrv.getValue()).getHeight();
                                    if (!(Math.abs(w - size[0]) < w * 0.15) || !(Math.abs(h - size[1]) < h * 0.15)) continue;
                                    this.doDirectPrint((PrintService)prtSrv.getKey(), (PageFormat)prtSrv.getValue(), "DirectPrint-", job);
                                    hasPrinted = true;
                                    break;
                                }
                                catch (Exception exception) {
                                    logger.log(Level.SEVERE, "Failed to Print report " + ((IReport)e.getKey()).toString() + ", with object " + this.dataObject);
                                }
                            }
                        }
                        if (hasPrinted) continue;
                        if (UI.OS_MAC) {
                            ReportCallback.showWithExternalViewer((IReport)e.getKey(), fr);
                            continue;
                        }
                        returnUrl = WebApplication.get().getWebResourcesDelegate().newHtmlPdfResource(fr.getDocument()).getUrl();
                    }
                    return returnUrl;
                }
                catch (Exception e1) {
                    throw new RuntimeException("Print report failed" + ((IReport)e.getKey()).toString(), e1);
                }
            }).collect(Collectors.toList());
            return printUrls;
        }
        this.print();
        return Collections.emptyList();
    }

    public final void setNip(String nip) {
        this.nip = nip;
    }

    private void doDirectPrint(PrintService ps, PageFormat pageFormat, String doc, PrintPdfX job) throws PrinterException {
        job.setPageFormat(pageFormat);
        PrinterJob pJob = PrinterJob.getPrinterJob();
        pJob.setCopies(1);
        pJob.setJobName(String.valueOf(doc) + System.currentTimeMillis());
        if (pJob.getPrintService() == null) {
            pJob.setPrintService(ps);
        }
        job.setJob(pJob);
        job.setPrintMode(PrintPdfX.PRINT_MODE.ACTUAL_SIZE);
        job.print();
    }
}

