/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.popup;

import ca.infodata.ofys.ui.controls.FontAwareShell;
import ca.infodata.ofys.ui.controls.popup.PopupFeature;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public abstract class CheckListPopupFeature<E>
extends PopupFeature {
    private Table list;

    public CheckListPopupFeature(Control control) {
        super(control);
        this.showPopupDown = true;
    }

    @Override
    protected Shell createPopupControlOverride(Shell parent) {
        FontAwareShell shell = new FontAwareShell(this.getControl().getShell(), 4);
        this.list = new Table((Composite)shell, 546);
        List<E> items = this.getItems();
        for (E e : items) {
            TableItem item = new TableItem(this.list, 0);
            item.setText(this.getTextForItem(e));
            item.setData(e);
        }
        this.list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 32) {
                    if (CheckListPopupFeature.this.list.getSelectionCount() > 0) {
                        TableItem item = (TableItem)e.item;
                        TableItem[] selection = CheckListPopupFeature.this.list.getSelection();
                        int i = 0;
                        while (i < selection.length) {
                            TableItem item2 = selection[i];
                            item2.setChecked(item.getChecked());
                            CheckListPopupFeature.this.checked(item2.getData(), item.getChecked());
                            ++i;
                        }
                    } else {
                        TableItem item = (TableItem)e.item;
                        CheckListPopupFeature.this.checked(item.getData(), item.getChecked());
                    }
                }
            }
        });
        FormLayout layout = new FormLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        shell.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        this.list.setLayoutData((Object)data);
        shell.pack();
        Point size = shell.getSize();
        if (size.y > shell.getParent().getSize().y) {
            Rectangle controlBounds = this.getControl().getDisplay().map(this.getControl(), null, this.getControl().getBounds());
            this.setPopupSizeY(shell.getParent().getSize().y - controlBounds.y - 50);
        }
        this.setPopupFirstFocusControl((Control)this.list);
        return shell;
    }

    @Override
    protected void refreshPopup() {
        if (this.getPopup() != null && !this.getPopup().isDisposed()) {
            List<E> items = this.getItems();
            Table list = this.getList();
            list.removeAll();
            for (E e : items) {
                TableItem item = new TableItem(list, 0);
                item.setText(this.getTextForItem(e));
                item.setData(e);
                item.setChecked(this.getChecked(e));
            }
            this.getPopup().layout(true);
        }
    }

    protected Table getList() {
        return this.list;
    }

    protected abstract String getTextForItem(E var1);

    protected abstract List<E> getItems();

    protected abstract boolean getChecked(E var1);

    public abstract void checked(E var1, boolean var2);
}

