/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.plugins.searchview;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.ObjectUsageAccessorClient;
import ca.infodata.ofys.data.dataaccess.callback.Callback;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.preferences.XClientPreferences;
import ca.infodata.ofys.ui.controls.BaseEditor;
import ca.infodata.ofys.ui.controls.BaseView;
import ca.infodata.ofys.ui.controls.ControlsPlugin;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.ISearchView;
import ca.infodata.ofys.ui.controls.ITreeElements;
import ca.infodata.ofys.ui.controls.form.IReferenceControl;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchItem;
import ca.infodata.ofys.ui.controls.util.MyDialogSettings;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.util1.StringUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class BaseSearchView
extends BaseView
implements ISearchView {
    private static final Logger logger = Logger.getLogger(BaseSearchView.class.getName());
    private FormToolkit toolkit;
    private Composite comTopSearch;
    protected Composite comSearch;
    protected Composite comViewSelect;
    protected Table tblSearch;
    protected Button opgGlobale;
    protected Button opgInLast;
    protected KeyListener enterCtrlEnterListener;
    protected static final String ENTER_CTRL_ENTER_TOOLTIP_LOC_WEB = Messages.getString((String)"RETOUR_RECHERCHE_LOCALE_WEB", (String[])new String[0]);
    protected static final String ENTER_CTRL_ENTER_TOOLTIP_LOC = Messages.getString((String)"RETOUR_RECHERCHE", (String[])new String[0]);
    protected Label lblMessage;
    private MyButton btnSearch;
    private MyButton btnNew;
    private MyButton btnSearchWeb;
    public String viewId;
    protected Color colorRed = ResourceGetter.getColor((int)255, (int)0, (int)0);
    protected Composite parent;
    protected boolean inLastUsed;
    protected static final String MSG_TROP_DONNEES = Messages.getString((String)"MSG_TROP_DONNEES", (String[])new String[0]);
    protected static final String MSG_AUCUNES_DONNEES = Messages.getString((String)"MSG_AUCUNES_DONNEES", (String[])new String[0]);
    protected int selectedItem = -1;
    protected String searchInList = "";
    protected int decompte = 2000;
    protected long lastTimeLetterEntered = 0L;
    protected int whichItemInList = 1;
    protected static String defaultText = "";
    private boolean hasWebSearch;
    private MyDialogSettings dialogSettings = new MyDialogSettings(".inLastUsed.xml", "inLastUsed"){

        @Override
        public void setDefaultValues() {
            this.put("inLastUsed", false);
        }
    };
    private Object selectionReferencedControl;
    private IReferenceControl containerReferencedControl;
    private boolean pined;

    @Override
    public void createMyPartControl(Composite theParent) {
        this.parent = theParent;
        this.toolkit = UI.createToolKit((Widget)theParent);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        layout.spacing = 4;
        this.toolkit.adapt(this.parent);
        this.comViewSelect = this.toolkit.createComposite(this.parent);
        this.comTopSearch = this.toolkit.createComposite(this.parent);
        this.comSearch = this.toolkit.createComposite(this.parent);
        this.parent.setLayout((Layout)new FormLayout());
        this.parent.setLayout((Layout)layout);
        this.comSearch.setLayout((Layout)layout);
        this.comViewSelect.setLayout((Layout)new FormLayout());
        this.enterCtrlEnterListener = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (UI.CR((KeyEvent)e)) {
                    if (UI.CTRL((KeyEvent)e) && BaseSearchView.this.hasWebSearch) {
                        BaseSearchView.this.searchButtonSelected(true);
                    } else {
                        BaseSearchView.this.searchButtonSelected(false);
                    }
                } else if (UI.ESC((KeyEvent)e)) {
                    BaseSearchView.this.close();
                }
            }
        };
        this.tblSearch = this.toolkit.createTable(this.comSearch, 67584);
        this.tblSearch.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent arg0) {
                if (BaseSearchView.this.tblSearch.getSelectionCount() > 0 && BaseSearchView.this.tblSearch.getSelection()[0].getData() != null) {
                    BaseSearchView.this.itemSelected((SearchItem)BaseSearchView.this.tblSearch.getSelection()[0].getData());
                }
            }

            public void mouseDown(MouseEvent arg0) {
            }

            public void mouseUp(MouseEvent arg0) {
                BaseSearchView.this.selectedItem = BaseSearchView.this.tblSearch.getSelectionIndex();
            }
        });
        this.tblSearch.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                e.doit = false;
                BaseSearchView.this.selectedItem = BaseSearchView.this.tblSearch.getSelectionIndex();
            }

            public void keyPressed(KeyEvent e) {
                if (UI.CR((KeyEvent)e)) {
                    if (BaseSearchView.this.tblSearch.getSelectionCount() > 0) {
                        BaseSearchView.this.itemSelected((SearchItem)BaseSearchView.this.tblSearch.getSelection()[0].getData());
                    }
                } else if (e.keyCode == 0x1000001) {
                    e.doit = false;
                    BaseSearchView.this.selectItem(-1);
                } else if (e.keyCode == 0x1000002) {
                    e.doit = false;
                    BaseSearchView.this.selectItem(1);
                } else if (UI.ESC((KeyEvent)e)) {
                    BaseSearchView.this.close();
                } else if (e.stateMask == 0) {
                    e.doit = false;
                    int index = 0;
                    String s = String.valueOf(e.character).toLowerCase();
                    if (e.character == ' ' && BaseSearchView.this.searchInList.length() > 0) {
                        index = BaseSearchView.this.findInTable(BaseSearchView.this.searchInList, ++BaseSearchView.this.whichItemInList);
                    } else if ("0".compareTo(s) <= 0 && "z".compareTo(s) >= 0) {
                        long now = System.currentTimeMillis();
                        if (now - BaseSearchView.this.lastTimeLetterEntered > (long)BaseSearchView.this.decompte || BaseSearchView.this.whichItemInList > 1) {
                            BaseSearchView.this.searchInList = "";
                        }
                        BaseSearchView.this.whichItemInList = 1;
                        BaseSearchView.this.lastTimeLetterEntered = now;
                        BaseSearchView.this.searchInList = String.valueOf(BaseSearchView.this.searchInList) + String.valueOf(e.character).toLowerCase();
                        index = BaseSearchView.this.findInTable(BaseSearchView.this.searchInList, BaseSearchView.this.whichItemInList);
                    }
                    if (index != 0) {
                        BaseSearchView.this.selectedItem = index;
                        BaseSearchView.this.tblSearch.setSelection(BaseSearchView.this.selectedItem);
                        BaseSearchView.this.tblSearch.select(BaseSearchView.this.selectedItem);
                    }
                }
            }
        });
        this.tblSearch.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16 || e.detail == 8) {
                    e.doit = false;
                    BaseSearchView.this.setFocus();
                }
                if (e.detail == 64 || e.detail == 32) {
                    e.doit = false;
                }
            }
        });
        this.tblSearch.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (BaseSearchView.this.tblSearch.getSelectionCount() == 1 && e.button == 3) {
                    BaseSearchView.this.showContextMenu((Control)BaseSearchView.this.tblSearch);
                }
            }
        });
        this.btnSearch = new MyButton(this.comSearch, null, 64, this.toolkit);
        this.btnSearch.setImage(ResourceGetter.getImage((String)"images/rechercher.gif"));
        this.btnSearch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                BaseSearchView.this.searchButtonSelected(false);
            }
        });
        this.btnSearch.setToolTipText(Messages.getString((String)"RETOUR", (String[])new String[0]));
        this.btnNew = new MyButton(this.comSearch, Messages.getString((String)"NOUVEAU", (String[])new String[0]), 64, this.toolkit);
        this.btnNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                BaseSearchView.this.createNew();
                BaseSearchView.this.close();
            }
        });
        this.btnSearchWeb = new MyButton(this.comSearch, Messages.getString((String)"RECHERCHERWEB", (String[])new String[0]), 64, this.toolkit);
        this.btnSearchWeb.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                BaseSearchView.this.searchButtonSelected(true);
            }
        });
        this.btnSearchWeb.setToolTipText(Messages.getString((String)"CTRLRETOUR", (String[])new String[0]));
        this.btnSearchWeb.setVisible(false);
        this.opgGlobale = this.toolkit.createButton(this.comViewSelect, Messages.getString((String)"RECHERCHEGLOBALE", (String[])new String[0]), 16);
        this.opgGlobale.setToolTipText(Messages.getString((String)"RECHERCHETOUTESDONNEES", (String[])new String[0]));
        this.opgGlobale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                BaseSearchView.this.inLastUsed = false;
                BaseSearchView.this.btnLastSelected();
            }
        });
        this.opgInLast = this.toolkit.createButton(this.comViewSelect, Messages.getString((String)"RECHERCHEPRE-SELECTIONNEE", (String[])new String[0]), 16);
        this.opgInLast.setToolTipText(Messages.getString((String)"RECHERCHEDEJASELECTIONNEE", (String[])new String[0]));
        this.opgInLast.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                BaseSearchView.this.inLastUsed = true;
                BaseSearchView.this.btnLastSelected();
            }
        });
        this.parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ResourceGetter.dispose((Object)BaseSearchView.this.colorRed);
            }
        });
        this.lblMessage = this.toolkit.createLabel(this.comSearch, "", 64);
        this.lblMessage.setForeground(this.colorRed);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        this.parent.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.comViewSelect.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.comViewSelect);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.comTopSearch.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.comTopSearch, -5);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        this.comSearch.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(50);
        data.right = new FormAttachment(100);
        data.width = MyButton.getStandardButtonWidth();
        this.btnSearch.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(1);
        data.right = new FormAttachment(50);
        data.width = MyButton.getStandardButtonWidth();
        this.btnNew.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(this.btnSearch.getControl());
        data.left = new FormAttachment(1);
        data.right = new FormAttachment(100);
        data.height = 0;
        data.width = MyButton.getStandardButtonWidth();
        this.btnSearchWeb.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(this.btnSearchWeb.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.height = 0;
        this.lblMessage.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(1);
        data.right = new FormAttachment(100);
        this.opgGlobale.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.opgGlobale, 0);
        data.left = new FormAttachment(1);
        data.right = new FormAttachment(100);
        this.opgInLast.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.lblMessage);
        data.right = new FormAttachment(100);
        data.left = new FormAttachment(0);
        data.bottom = new FormAttachment(100);
        this.tblSearch.setLayoutData((Object)data);
        this.createMyControl(this.comTopSearch, this.toolkit);
        this.toolkit.paintBordersFor(this.comTopSearch);
        this.toolkit.paintBordersFor(this.comSearch);
    }

    protected void showContextMenu(Control parent) {
    }

    protected void selectItem(int next) {
        int itemCount = this.tblSearch.getItemCount();
        int itemSelected = this.selectedItem--;
        switch (next) {
            case -1: {
                if (itemSelected == 0) {
                    this.selectedItem = itemCount - 1;
                }
                break;
            }
            case 1: {
                if (itemSelected + 1 == itemCount) {
                    this.selectedItem = 0;
                    break;
                }
                ++this.selectedItem;
                break;
            }
        }
        this.tblSearch.select(this.selectedItem);
        this.tblSearch.showSelection();
    }

    protected int findInTable(String filterText, int itemInList) {
        int z = 0;
        int item = 1;
        int i = 0;
        while (i < this.tblSearch.getItemCount()) {
            if (this.tblSearch.getItem(i).getText().toLowerCase().indexOf(filterText) != -1) {
                if (itemInList > item) {
                    ++item;
                } else {
                    z = i;
                    break;
                }
            }
            ++i;
        }
        return z;
    }

    public static IViewPart openView(Class<?> myClass) {
        return BaseSearchView.openView(myClass, null);
    }

    public static IViewPart openView(Class<?> myClass, Object referencedControl) {
        String viewId = myClass.getName();
        return BaseSearchView.openView(viewId, referencedControl);
    }

    private static IViewPart openView(String viewId, Object referencedControl) {
        IViewPart viewPart = null;
        try {
            IWorkbenchPage page = ControlsPlugin.getDefault().getWorkbench().getWorkbenchWindows()[0].getPages()[0];
            page.showView(viewId, null, 1);
            viewPart = page.findView(viewId);
            if (viewPart instanceof BaseSearchView) {
                BaseSearchView view = (BaseSearchView)viewPart;
                view.setReferenceControl(referencedControl);
                view.setInitialControlValue();
                view.viewId = viewId;
            } else if (viewPart instanceof ISearchView) {
                ((ISearchView)viewPart).setReferenceControl(referencedControl);
            }
            if (viewPart instanceof ISearchView) {
                IToolBarManager menuManager = viewPart.getViewSite().getActionBars().getToolBarManager();
                final IViewPart viewPart2 = viewPart;
                if (menuManager.find("pin") == null) {
                    Action action = new Action("pin", 2){
                        boolean value;
                        {
                            super($anonymous0, $anonymous1);
                            this.value = false;
                        }

                        public void run() {
                            this.value = !this.value;
                            ((ISearchView)viewPart2).pin(this.value);
                        }
                    };
                    action.setId("pin");
                    action.setImageDescriptor(ImageDescriptor.createFromImage((Image)ResourceGetter.getImage((String)"images/pin.png")));
                    action.setToolTipText("pin");
                    menuManager.add((IAction)action);
                    menuManager.update(true);
                }
            }
        }
        catch (PartInitException e) {
            logger.log(Level.SEVERE, "Failed to open view " + viewId, e);
        }
        return viewPart;
    }

    @Override
    public void close() {
        if (this.pined) {
            return;
        }
        IWorkbenchPage page = ControlsPlugin.getDefault().getWorkbench().getWorkbenchWindows()[0].getPages()[0];
        if (page != null) {
            page.hideView(page.findView(this.viewId));
        }
    }

    public void setBtnLastEnabled(boolean value) {
    }

    private void setInitialControlValue() {
        try {
            this.inLastUsed = this.dialogSettings.getBoolean("inLastUsed");
        }
        catch (Exception e) {
            this.inLastUsed = false;
            logger.log(Level.WARNING, "Failed to retrieve inLastUsed preference", e);
        }
        this.opgInLast.setSelection(this.inLastUsed);
        this.opgGlobale.setSelection(!this.inLastUsed);
    }

    protected void loadSearchListInTable(SearchItem[] aSearchItemList) {
        int i;
        if (!this.tblSearch.isDisposed()) {
            this.tblSearch.clearAll();
            TableItem item = null;
            if (aSearchItemList != null) {
                this.tblSearch.removeAll();
                i = 0;
                while (i < aSearchItemList.length) {
                    item = new TableItem(this.tblSearch, 0);
                    item.setText(aSearchItemList[i].getText());
                    item.setData((Object)aSearchItemList[i]);
                    ++i;
                }
                if (item != null) {
                    this.tblSearch.showItem(item);
                }
                if (this.tblSearch.getItemCount() > 0) {
                    this.tblSearch.setFocus();
                    this.selectedItem = 0;
                    this.tblSearch.select(0);
                    this.tblSearch.showSelection();
                }
            }
        }
        if (this.getContainerReferenceControl() != null) {
            Object[] datas = new Object[aSearchItemList.length];
            i = 0;
            while (i < datas.length) {
                datas[i] = aSearchItemList[i].getData();
                ++i;
            }
            this.getContainerReferenceControl().callback(datas);
        }
    }

    public void searchButtonSelected(boolean isWebSearch) {
        SearchItem[] searchItemList = isWebSearch ? this.searchWeb() : this.search(this.inLastUsed);
        this.loadSearchListInTable(searchItemList);
    }

    protected void btnLastSelected() {
        try {
            this.opgInLast.setSelection(this.inLastUsed);
            this.opgGlobale.setSelection(!this.inLastUsed);
            this.dialogSettings.save();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to store inLastUsed preference", e);
        }
    }

    protected void itemSelected(SearchItem item) {
        this.genericProcessSelection(item);
    }

    protected void genericProcessSelection(SearchItem item) {
        if (item != null) {
            try {
                if (item.getData() instanceof IDataObject) {
                    IDataObject dataObject = (IDataObject)item.getData();
                    ObjectUsageAccessorClient.getInstance().setObjectUsed(dataObject.hashCode(), Application.get().getGlobalInstances().getSession(), (ICallback)new Callback(), dataObject);
                }
                if (this.getReferenceControl() instanceof ITreeElements && item.getData() instanceof IDataObject) {
                    ITreeElements control = (ITreeElements)this.getReferenceControl();
                    BaseEditor.openEditorSafe(new EditorInput((IDataObject)item.getData()), ((ITreeElements)control.getChildren()[0]).getEditorClass());
                } else if (this.getReferenceControl() instanceof IReferenceControl) {
                    ((IReferenceControl)this.getReferenceControl()).callback(item.getData());
                }
                this.processSelection(item);
                this.close();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error processing selection " + StringUtils.safeToString((Logger)logger, (Object)item), e);
            }
        }
    }

    protected abstract void processSelection(SearchItem var1);

    public abstract void setFocus();

    protected abstract void createMyControl(Composite var1, FormToolkit var2);

    protected abstract SearchItem[] search(boolean var1);

    protected abstract SearchItem[] searchWeb();

    protected abstract void createNew();

    @Override
    public IReferenceControl getContainerReferenceControl() {
        return this.containerReferencedControl;
    }

    @Override
    public Object getSelectionReferenceControl() {
        return this.selectionReferencedControl;
    }

    @Override
    public void setContainerReferenceControl(IReferenceControl referenceControl) {
        this.containerReferencedControl = referenceControl;
    }

    @Override
    public void setSelectionReferenceControl(Object referenceControl) {
        this.selectionReferencedControl = referenceControl;
    }

    @Override
    public Object getReferenceControl() {
        return this.selectionReferencedControl;
    }

    @Override
    public void setReferenceControl(Object referencedControl) {
        this.selectionReferencedControl = referencedControl;
    }

    public void setMessage(String mess) {
        this.lblMessage.setText(mess);
        this.setLblMessageActif(mess != "");
    }

    public void setIsWithButtonNew(boolean isWithButtonNew) {
        this.btnNew.setVisible(isWithButtonNew);
    }

    public void setIsWithButtonSearchWeb(boolean isWithButtonSearchWeb) {
        FormData data = new FormData();
        data.top = new FormAttachment(this.btnSearch.getControl());
        data.left = new FormAttachment(1);
        data.right = new FormAttachment(100);
        data.width = MyButton.getStandardButtonWidth();
        if (!isWithButtonSearchWeb) {
            data.height = 0;
        }
        this.btnSearchWeb.setLayoutData(data);
        this.comTopSearch.pack();
        this.btnSearchWeb.setVisible(isWithButtonSearchWeb);
        this.hasWebSearch = isWithButtonSearchWeb;
    }

    public void setLblMessageActif(boolean isLblMessageActif) {
        FormData data = new FormData();
        data = new FormData();
        data.top = new FormAttachment(this.btnSearchWeb.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.height = 38;
        if (!isLblMessageActif) {
            data.height = 0;
        }
        this.lblMessage.setLayoutData((Object)data);
        this.parent.setSize(this.parent.getSize().x - 1, this.parent.getSize().y - 1);
        this.parent.setSize(this.parent.getSize().x + 1, this.parent.getSize().y + 1);
        this.lblMessage.setVisible(isLblMessageActif);
    }

    public void setViewSelectInactive() {
        this.comViewSelect.setVisible(false);
        FormData data = new FormData();
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.height = 0;
        this.comViewSelect.setLayoutData((Object)data);
    }

    public static void setDefaultText(String text) {
        defaultText = text;
    }

    @Override
    public void pin(boolean value) {
        this.pined = value;
    }

    public static int getMAX_SEARCH_LIST_SIZE() {
        Integer max;
        XClientPreferences clientPreferences;
        XSession session = Application.get().getGlobalInstances().getSession();
        if (session != null && (clientPreferences = session.getClientPreferences()) != null && (max = clientPreferences.getReturnListLength()) != null) {
            return max;
        }
        return 25;
    }
}

