/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.form;

import ca.infodata.ofys.ui.controls.form.INumberConverter;
import java.math.BigDecimal;

public class KiloToPoundConverter
implements INumberConverter {
    private static final double ratio = 2.20462262;

    @Override
    public Double convert(Double kilo) {
        if (kilo == null) {
            return null;
        }
        double doubleVar = kilo * 2.20462262;
        BigDecimal bd = BigDecimal.valueOf(doubleVar).setScale(1, 4);
        return bd.doubleValue();
    }

    @Override
    public Double inverse(Double pound) {
        if (pound == null) {
            return null;
        }
        double doubleVar = pound / 2.20462262;
        BigDecimal bd = BigDecimal.valueOf(doubleVar).setScale(1, 4);
        return bd.doubleValue();
    }

    @Override
    public String getFromUnitText() {
        return "kg";
    }

    @Override
    public String getToUnitText() {
        return "lb";
    }
}

