/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.dnd;

import ca.infodata.ofys.ui.controls.dnd.StringTransferPool;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

public class StringTransfer<T>
extends ByteArrayTransfer {
    private final int type;
    private final String typeName;

    protected StringTransfer(String type) {
        if (type == null) {
            throw new IllegalArgumentException("type cant be null");
        }
        this.typeName = "String-application-format-" + type;
        this.type = StringTransfer.registerType((String)this.typeName);
    }

    public T pop(String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return (T)StringTransferPool.getInstance().pop(key);
    }

    public void put(String key, T value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        StringTransferPool.getInstance().put(key, value);
    }

    protected boolean validate(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    protected int[] getTypeIds() {
        return new int[]{this.type};
    }

    protected String[] getTypeNames() {
        return new String[]{this.typeName};
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (this.validate(object) && this.isSupportedType(transferData)) {
            String text = (String)object;
            super.javaToNative((Object)text.getBytes(), transferData);
        }
    }

    public Object nativeToJava(TransferData transferData) {
        byte[] buffer;
        if (this.isSupportedType(transferData) && (buffer = (byte[])super.nativeToJava(transferData)) != null) {
            String text = new String(buffer);
            return text;
        }
        return null;
    }
}

