/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls;

import ca.infodata.ofys.ui.library.DaemonThread;
import ca.infodata.util1.EventLock;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public abstract class SWTDelayedListener
implements Listener {
    private DelayTask delayTask;
    private SendTask sendTask;
    private EventLock eventLock;
    private boolean disposed;
    private final long delayInMillis;
    private volatile Event lastNonSentEvent;

    public SWTDelayedListener(long delayInMillis, int eventType) {
        if (delayInMillis < 0L) {
            throw new IllegalArgumentException("delayInMillis cannot be < 0");
        }
        this.delayInMillis = delayInMillis;
        this.disposed = false;
        this.eventLock = new EventLock();
        this.delayTask = new DelayTask();
        this.sendTask = new SendTask();
        DaemonThread thread = new DaemonThread((Runnable)this.delayTask, "SwtDelayThread");
        thread.start();
    }

    public void linkDisposeWithControl(Control control) {
        if (control == null) {
            throw new NullPointerException("control");
        }
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SWTDelayedListener.this.dispose();
            }
        });
    }

    public void linkSendWithFocusOut(Control control) {
        control.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                SWTDelayedListener.this.send();
            }
        });
    }

    protected void send() {
        if (this.sendTask != null) {
            Display.getDefault().syncExec((Runnable)this.sendTask);
        }
    }

    public abstract void handleEventOverride(Event var1);

    public final void handleEvent(Event e) {
        this.lastNonSentEvent = e;
        this.eventLock.eventOccured();
        this.eventLock.reset();
    }

    public void dispose() {
        if (!this.disposed) {
            this.delayTask.doit = false;
            this.lastNonSentEvent = null;
            this.eventLock.eventOccured();
            this.delayTask = null;
            this.sendTask = null;
            this.disposed = true;
        }
    }

    private class DelayTask
    implements Runnable {
        volatile boolean doit = true;

        private DelayTask() {
        }

        @Override
        public void run() {
            while (this.doit && SWTDelayedListener.this.eventLock.waitUntilEvent()) {
                try {
                    Thread.sleep(SWTDelayedListener.this.delayInMillis);
                }
                catch (InterruptedException interruptedException) {}
                Event event = SWTDelayedListener.this.lastNonSentEvent;
                if (event == null || System.currentTimeMillis() < SWTDelayedListener.this.delayInMillis + (long)event.time) continue;
                SWTDelayedListener.this.send();
            }
        }
    }

    private class SendTask
    implements Runnable {
        private SendTask() {
        }

        @Override
        public void run() {
            Event event = SWTDelayedListener.this.lastNonSentEvent;
            if (event != null) {
                SWTDelayedListener.this.handleEventOverride(event);
            }
            SWTDelayedListener.this.lastNonSentEvent = null;
        }
    }
}

