/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.ui.controls.DateMask;
import ca.infodata.ofys.ui.controls.MyMask;
import ca.infodata.ofys.ui.controls.MyMaskedText;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.PartialDate;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PartialDateText
extends MyMaskedText {
    private static final Logger logger = Logger.getLogger(IDateListener.class.getName());
    private static PartialDate dateIdem;
    private String rawTextCache;
    private PartialDate dateCache;
    private ArrayList<IDateListener> dateListeners = new ArrayList();
    static boolean ignore;

    static {
        ignore = false;
    }

    public PartialDateText(Composite parent, int style, FormToolkit formToolkit) {
        super(parent, style, formToolkit);
        this.init();
    }

    public PartialDateText(Composite parent, int style) {
        super(parent, style);
        this.init();
    }

    private void init() {
        this.setMask(DateMask.getInstance());
        Listener listener = new Listener(){
            private PartialDate dateCache2;

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 1: {
                        PartialDateText.this.processCustomKeys(e);
                        break;
                    }
                    case 15: {
                        PartialDateText.this.selectAll();
                        PartialDateText.this.showMask(false);
                        break;
                    }
                    case 16: {
                        dateIdem = PartialDateText.this.getDate();
                        PartialDateText.this.autoComplete();
                        PartialDateText.this.showMask(true);
                        break;
                    }
                    case 24: {
                        PartialDate date = PartialDateText.this.getDate();
                        if (this.dateCache2 == date) break;
                        PartialDateText.this.fireDateChanged(date);
                        this.dateCache2 = date;
                        break;
                    }
                }
            }
        };
        this.addListener(1, listener);
        this.addListener(15, listener);
        this.addListener(16, listener);
        this.addListener(24, listener);
        this.showMask(true);
        this.setToolTipText(Messages.getString((String)"DATE_TTT", (String[])new String[0]));
    }

    private void showMask(boolean v) {
    }

    @Override
    public void setMask(MyMask mask) {
        if (!(mask instanceof DateMask)) {
            throw new IllegalArgumentException("mask must be instance of DateMask");
        }
        super.setMask(mask);
    }

    @Override
    public void setRawText(String string) {
        if (string == null || string.length() == 0) {
            super.setRawText(string);
            this.showMask(true);
        } else {
            this.showMask(false);
            super.setRawText(string);
        }
    }

    @Override
    public void setRawTextKeepSelection(String string) {
        if (string == null || string.length() == 0) {
            this.showMask(true);
        } else {
            this.showMask(false);
            super.setRawTextKeepSelection(string);
        }
    }

    @Override
    public void setText(String string) {
        if (string == null || string.length() == 0) {
            this.showMask(true);
        } else {
            this.showMask(false);
            super.setText(string);
        }
    }

    private void autoComplete() {
        String rawText = this.getRawText();
        int length = rawText.length();
        if (length >= 3 && length <= 4) {
            try {
                int month = Integer.parseInt(rawText.substring(0, 2));
                int day = Integer.parseInt(rawText.substring(2));
                LocalDate date = LocalDate.today().withMonth(month).withDay(day);
                this.setDate(PartialDate.from((LocalDate)date));
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        } else if (length >= 1 && length <= 2) {
            try {
                int day = Integer.parseInt(rawText);
                LocalDate date = LocalDate.today().withDay(day);
                this.setDate(PartialDate.from((LocalDate)date));
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    private void processCustomKeys(Event e) {
        if (e.character == '\u0000' && e.keyCode == 0) {
            return;
        }
        switch (e.character) {
            case 'I': 
            case 'i': {
                if (dateIdem == null) break;
                this.setDate(dateIdem);
            }
        }
    }

    public void setDate(PartialDate date) {
        if (date == null) {
            this.clear();
        } else if (date == this.dateCache) {
            this.setRawText(this.getRawText());
        } else {
            this.setRawText(date.formatHyphen());
        }
    }

    public PartialDate getDate() {
        int month;
        int year;
        PartialDate date = this.dateCache;
        String rawText = this.getRawText();
        if (rawText.equals(this.rawTextCache)) {
            return this.dateCache;
        }
        int len = rawText.length();
        if (len <= 4) {
            try {
                year = Integer.parseInt(rawText);
                date = PartialDate.from(null, null, (Integer)year);
            }
            catch (NumberFormatException numberFormatException) {
                date = null;
            }
        } else if (len <= 6) {
            try {
                year = Integer.parseInt(rawText.substring(0, 4));
                month = Integer.parseInt(rawText.substring(4, rawText.length()));
                date = PartialDate.from(null, (Integer)month, (Integer)year);
            }
            catch (NumberFormatException numberFormatException) {
                date = null;
            }
        }
        if (len <= 10) {
            try {
                year = Integer.parseInt(rawText.substring(0, 4));
                month = Integer.parseInt(rawText.substring(4, 6));
                int day = Integer.parseInt(rawText.substring(6, rawText.length()));
                date = PartialDate.from((Integer)day, (Integer)month, (Integer)year);
            }
            catch (NumberFormatException numberFormatException) {
                date = null;
            }
        } else {
            date = null;
        }
        this.rawTextCache = rawText;
        this.dateCache = date;
        return date;
    }

    public void addDateListener(IDateListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.dateListeners.add(listener);
    }

    public void removeDateListener(IDateListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.dateListeners.remove(listener);
    }

    private void fireDateChanged(PartialDate date) {
        try {
            for (IDateListener listener : this.dateListeners) {
                listener.dateChanged(date);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception while notifying dateChanged event", e);
        }
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        final PartialDateText dateText = new PartialDateText((Composite)shell, 2048);
        dateText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ignore) {
                    return;
                }
                System.out.println(dateText.getDate());
                ignore = true;
                dateText.setRawTextKeepSelection(dateText.getRawText());
                ignore = false;
            }
        });
        Button button = new Button((Composite)shell, 8);
        button.setText("test");
        button.setFocus();
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                dateText.clear();
            }
        });
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public static interface IDateListener {
        public void dateChanged(PartialDate var1);
    }
}

