/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.ui.controls.IControl;
import ca.infodata.ofys.ui.controls.MyMask;
import ca.infodata.ofys.ui.controls.form.MyText;
import ca.infodata.util1.PredicateA;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.DragDetectListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class MyMaskedText
implements IControl {
    public static final int VALID_WITH_COLOR = 2;
    public static final int VALID_FIELD_MUST_NOT_BE_EMPTY = 4;
    public static final int VALID_FIELD_MUST_BE_COMPLETE = 8;
    public static final int VALID_NOT_SET_TEXT = 16;
    private boolean autoTraverseTabNextOnMaskLimit;
    private Pattern pattern = null;
    private boolean externModifyTextDoit = true;
    private final List<ModifyListenerProxy> modifyListeners = new ArrayList<ModifyListenerProxy>();
    private final List<ListenerProxy> plainModifyListeners = new ArrayList<ListenerProxy>();
    private final MyText myText;
    private MyMask mask;
    private Color foreground;
    private Color background;
    private Color defaulInvalidTextColor;
    private Color invalidTextColor;
    private TextChangeListener listener;
    private int validStyle;
    private boolean validWithColor;
    private boolean validFieldMustBeComplete;
    private boolean validFieldMustNotBeEmpty;
    private boolean validNotSetText;
    private boolean newTextVerified;
    private String newText;
    private Point newSelection = new Point(-1, -1);
    private boolean settext;
    private PredicateA<String> validPredicate;
    private final DisposeListener disposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            if (MyMaskedText.this.defaulInvalidTextColor != null && !MyMaskedText.this.defaulInvalidTextColor.isDisposed()) {
                MyMaskedText.this.defaulInvalidTextColor.dispose();
            }
        }
    };
    protected static final String CASE_OBLIGATOIRE = Messages.getString((String)"CASE_OBLIGATOIRE", (String[])new String[0]);
    protected Image fieldDecorationErrorImage;
    protected Image fieldDecorationRequiredImage;
    protected ControlDecoration controlDecorationRequired = null;
    protected ControlDecoration controlDecorationError = null;

    public MyMaskedText(Composite parent, FormToolkit formToolkit) {
        this(new MyText(parent, "", 0, formToolkit));
    }

    public MyMaskedText(Composite parent, int style, FormToolkit formToolkit) {
        this(new MyText(parent, "", style, formToolkit));
    }

    protected MyMaskedText(MyText text) {
        if (text == null) {
            throw new NullPointerException("text");
        }
        if (text.isDisposed()) {
            throw new IllegalArgumentException("text is disposed");
        }
        this.myText = text;
        this.foreground = this.myText.getForeground();
        this.background = this.myText.getBackground();
        this.invalidTextColor = this.defaulInvalidTextColor = new Color((Device)text.getDisplay(), 255, 100, 100);
        this.listener = new TextChangeListener();
        this.addListeners();
    }

    public MyMaskedText(Composite parent, int style) {
        this(parent, style, null);
    }

    public MyMaskedText(Composite parent, Pattern pattern) {
        this(parent, 2048, null);
        this.pattern = pattern;
    }

    private void addListeners() {
        this.myText.addListener(24, this.listener);
        this.myText.addListener(25, this.listener);
        this.myText.addListener(16, this.listener);
        this.myText.addListener(15, this.listener);
        this.myText.addDisposeListener(this.disposeListener);
    }

    private void verifyEvent(Event event) {
        if (this.mask != null) {
            boolean valid;
            int count;
            String text;
            String oldText = this.myText.getText();
            Point selection = this.myText.getSelection();
            int selectionCount = this.myText.getSelectionCount();
            boolean isInsert = false;
            if (event.character == '\b') {
                text = this.mask.starve(oldText, selection.y, Math.max(selectionCount, 1));
                count = oldText.length() - text.length();
                this.newSelection.y = this.newSelection.x = selection.x - count;
            } else if (event.character == '\u007f') {
                text = selection.x == selection.y ? this.mask.starve2(oldText, selection.x, selection.y + 1) : this.mask.starve2(oldText, selection.x, selection.y);
                this.newSelection.y = this.newSelection.x = selection.x;
            } else if (event.character != '\u0000' && selectionCount == 0) {
                isInsert = true;
                text = this.mask.feed(oldText, selection.x, event.character);
                count = text.length() - oldText.length();
                this.newSelection.y = this.newSelection.x = selection.x + count;
            } else {
                if (this.settext) {
                    text = event.text;
                    this.newSelection.x = selection.x;
                    this.newSelection.y = selection.y;
                } else {
                    text = new StringBuilder(oldText).replace(selection.x, selection.y, event.text).toString();
                    count = event.text.length();
                    this.newSelection.y = this.newSelection.x = selection.x + count;
                }
                if (!(this.mask.valid(text) || this.settext && this.validNotSetText)) {
                    text = this.mask.apply(text);
                    this.newSelection.y = this.newSelection.x = text.length();
                }
            }
            boolean bl = valid = this.settext && this.validNotSetText || this.mask.valid(text);
            if (valid) {
                event.doit = true;
                this.newText = text;
            } else if (isInsert) {
                if (this.mask.valid(oldText)) {
                    event.doit = false;
                } else {
                    event.doit = true;
                    this.newText = this.mask.apply(text);
                }
            } else {
                event.doit = true;
                this.newText = this.mask.apply(text);
            }
            this.newTextVerified = true;
            this.setForegroundColor(valid, text);
            this.setBackgroundColor(valid, text);
        } else if (this.pattern != null) {
            String string = event.text;
            Matcher matcher = this.pattern.matcher(string);
            if (matcher.matches()) {
                event.doit = true;
                this.setForegroundColor(true, string);
                this.setBackgroundColor(true, string);
            } else {
                event.doit = false;
                return;
            }
        }
    }

    private void modifyEvent(Event event) {
        if (this.mask != null) {
            if (!this.newTextVerified) {
                return;
            }
            this.newTextVerified = false;
            if (!this.myText.getText().equals(this.newText)) {
                this.myText.setText(this.newText);
                this.myText.setSelection(this.newSelection);
            }
            if (this.myText.isEventFromKey() && this.autoTraverseTabNextOnMaskLimit && this.myText.isFocusControl() && this.myText.getText().length() == this.mask.getMask().length() && this.myText.getCaretPosition() == this.mask.getMask().length()) {
                this.myText.traverse(16);
            }
        }
    }

    private void focusOutEvent() {
        this.valid();
    }

    private void focusInEvent() {
        if (this.mask != null && this.validWithColor) {
            this.myText.setForeground(this.foreground);
            this.myText.setBackground(this.background);
        }
    }

    public boolean valid() {
        String text = this.myText.getText();
        boolean valid = true;
        if (this.mask != null) {
            if (this.validFieldMustBeComplete) {
                boolean bl = valid = valid && (text.length() == 0 || text.length() == this.mask.getMask().length());
            }
            if (this.validFieldMustNotBeEmpty) {
                valid = valid && text.length() != 0;
            }
            valid = valid && this.mask.valid(text);
            valid = valid && (this.getValidPredicate() == null || this.getValidPredicate().evaluate((Object)text));
        } else if (this.pattern != null) {
            valid = this.pattern.matcher(text).matches();
            if (this.validFieldMustNotBeEmpty) {
                valid = valid && text.length() != 0;
            }
        } else if (this.validFieldMustNotBeEmpty) {
            valid = valid && text.length() != 0;
        }
        this.setForegroundColor(valid, text);
        this.setBackgroundColor(valid, text);
        return valid;
    }

    private void setForegroundColor(boolean valid, String text) {
        if (this.validWithColor && text != null && text.length() != 0) {
            if (valid) {
                this.myText.setForeground(this.foreground);
            } else {
                if (this.getInvalidTextColor() == null) {
                    throw new IllegalStateException("invalidTextColor is null");
                }
                this.myText.setForeground(this.getInvalidTextColor());
            }
        }
    }

    private void setBackgroundColor(boolean valid, String text) {
        if (this.validWithColor) {
            if (valid) {
                this.myText.setBackground(this.background);
            } else {
                if (this.getInvalidTextColor() == null) {
                    throw new IllegalStateException("invalidTextColor is null");
                }
                this.myText.setBackground(this.getInvalidTextColor());
            }
        }
    }

    public Color getInvalidTextColor() {
        return this.invalidTextColor;
    }

    public void setInvalidTextColor(Color color) {
        this.invalidTextColor = color;
    }

    public void addModifyListener(ModifyListener ml) {
        if (ml == null) {
            throw new NullPointerException();
        }
        ModifyListenerProxy proxy = new ModifyListenerProxy(ml);
        this.modifyListeners.add(proxy);
        this.myText.addModifyListener(proxy);
    }

    public void addListener(int eventType, Listener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (eventType == 24) {
            ListenerProxy proxy = new ListenerProxy(listener);
            this.plainModifyListeners.add(proxy);
            this.myText.addListener(eventType, proxy);
        } else {
            this.myText.addListener(eventType, listener);
        }
    }

    public void removeListener(int eventType, Listener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (eventType == 24) {
            Iterator<ListenerProxy> iterator = this.plainModifyListeners.iterator();
            while (iterator.hasNext()) {
                ListenerProxy proxy = iterator.next();
                if (!proxy.listener.equals(listener)) continue;
                this.myText.removeListener(eventType, proxy);
                iterator.remove();
            }
        } else {
            this.myText.removeListener(eventType, listener);
        }
    }

    public void removeModifyListener(ModifyListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        Iterator<ModifyListenerProxy> iterator = this.modifyListeners.iterator();
        while (iterator.hasNext()) {
            ModifyListenerProxy proxy = iterator.next();
            if (!proxy.listener.equals(listener)) continue;
            this.myText.removeModifyListener(proxy);
            iterator.remove();
        }
    }

    @Override
    public Control getControl() {
        return this.myText.getControl();
    }

    public int getValidStyle() {
        return this.validStyle;
    }

    public void setValidStyle(int style) {
        this.validStyle = style;
        this.validWithColor = (style | 2) == style;
        this.validFieldMustBeComplete = (style | 8) == style;
        this.validFieldMustNotBeEmpty = (style | 4) == style;
        this.validNotSetText = (style | 0x10) == style;
        this.showRequiredFieldDecorator(this.validFieldMustNotBeEmpty);
        if (!this.validWithColor) {
            this.setForeground(this.foreground);
            this.setBackground(this.background);
        }
    }

    public void showRequiredFieldDecorator(boolean b) {
        if (b) {
            if (this.controlDecorationRequired == null) {
                this.fieldDecorationRequiredImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_REQUIRED").getImage();
                this.controlDecorationRequired = new ControlDecoration(this.getControl(), 0x1004000);
                this.controlDecorationRequired.setMarginWidth(0);
                this.controlDecorationRequired.setImage(this.fieldDecorationRequiredImage);
                this.controlDecorationRequired.setDescriptionText(CASE_OBLIGATOIRE);
            }
            this.controlDecorationRequired.show();
        } else if (this.controlDecorationRequired != null) {
            this.controlDecorationRequired.hide();
        }
    }

    public MyMask getMask() {
        return this.mask;
    }

    public void setMask(MyMask mask) {
        this.mask = mask;
    }

    public boolean isAutoTraverseTabNextOnMaskLimit() {
        return this.autoTraverseTabNextOnMaskLimit;
    }

    public void setAutoTraverseTabNextOnMaskLimit(boolean autoTraverseTabNextOnMaskLimit) {
        this.autoTraverseTabNextOnMaskLimit = autoTraverseTabNextOnMaskLimit;
    }

    public void addControlListener(ControlListener listener) {
        this.myText.addControlListener(listener);
    }

    public void addDisposeListener(DisposeListener listener) {
        this.myText.addDisposeListener(listener);
    }

    public void addDragDetectListener(DragDetectListener listener) {
        this.myText.addDragDetectListener(listener);
    }

    public void addFocusListener(FocusListener listener) {
        this.myText.addFocusListener(listener);
    }

    public void addHelpListener(HelpListener listener) {
        this.myText.addHelpListener(listener);
    }

    public void addKeyListener(KeyListener listener) {
        this.myText.addKeyListener(listener);
    }

    public void addMenuDetectListener(MenuDetectListener listener) {
        this.myText.addMenuDetectListener(listener);
    }

    public void addMouseListener(MouseListener listener) {
        this.myText.addMouseListener(listener);
    }

    public void addMouseMoveListener(MouseMoveListener listener) {
        this.myText.addMouseMoveListener(listener);
    }

    public void addMouseTrackListener(MouseTrackListener listener) {
        this.myText.addMouseTrackListener(listener);
    }

    public void addMouseWheelListener(MouseWheelListener listener) {
        this.myText.addMouseWheelListener(listener);
    }

    public void addPaintListener(PaintListener listener) {
        this.myText.addPaintListener(listener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.myText.addSelectionListener(listener);
    }

    public void addTraverseListener(TraverseListener listener) {
        this.myText.addTraverseListener(listener);
    }

    public void addVerifyListener(VerifyListener listener) {
        this.myText.addVerifyListener(listener);
    }

    public void append(String string) {
        this.myText.append(string);
    }

    public void clearSelection() {
        this.myText.clearSelection();
    }

    public Point computeSize(int hint, int hint2, boolean changed) {
        return this.myText.computeSize(hint, hint2, changed);
    }

    public Point computeSize(int hint, int hint2) {
        return this.myText.computeSize(hint, hint2);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        return this.myText.computeTrim(x, y, width, height);
    }

    public void copy() {
        this.myText.copy();
    }

    public void cut() {
        this.myText.cut();
    }

    public void dispose() {
        this.myText.dispose();
    }

    public boolean dragDetect(Event event) {
        return this.myText.dragDetect(event);
    }

    public boolean dragDetect(MouseEvent event) {
        return this.myText.dragDetect(event);
    }

    public boolean equals(Object obj) {
        return this.myText.equals(obj);
    }

    public boolean forceFocus() {
        return this.myText.forceFocus();
    }

    public Accessible getAccessible() {
        return this.myText.getAccessible();
    }

    public Color getBackground() {
        return this.myText.getBackground();
    }

    public Image getBackgroundImage() {
        return this.myText.getBackgroundImage();
    }

    public int getBorderWidth() {
        return this.myText.getBorderWidth();
    }

    public Rectangle getBounds() {
        return this.myText.getBounds();
    }

    public int getCaretLineNumber() {
        return this.myText.getCaretLineNumber();
    }

    public Point getCaretLocation() {
        return this.myText.getCaretLocation();
    }

    public int getCaretPosition() {
        return this.myText.getCaretPosition();
    }

    public int getCharCount() {
        return this.myText.getCharCount();
    }

    public Rectangle getClientArea() {
        return this.myText.getClientArea();
    }

    public Cursor getCursor() {
        return this.myText.getCursor();
    }

    public Object getData() {
        return this.myText.getData();
    }

    public Object getData(String key) {
        return this.myText.getData(key);
    }

    public Display getDisplay() {
        return this.myText.getDisplay();
    }

    public boolean getDoubleClickEnabled() {
        return this.myText.getDoubleClickEnabled();
    }

    public boolean getDragDetect() {
        return this.myText.getDragDetect();
    }

    public char getEchoChar() {
        return this.myText.getEchoChar();
    }

    public boolean getEditable() {
        return this.myText.getEditable();
    }

    public boolean getEnabled() {
        return this.myText.getEnabled();
    }

    public Font getFont() {
        return this.myText.getFont();
    }

    public Color getForeground() {
        return this.myText.getForeground();
    }

    public ScrollBar getHorizontalBar() {
        return this.myText.getHorizontalBar();
    }

    public Object getLayoutData() {
        return this.myText.getLayoutData();
    }

    public int getLineCount() {
        return this.myText.getLineCount();
    }

    public String getLineDelimiter() {
        return this.myText.getLineDelimiter();
    }

    public int getLineHeight() {
        return this.myText.getLineHeight();
    }

    public Listener[] getListeners(int eventType) {
        return this.myText.getListeners(eventType);
    }

    public Point getLocation() {
        return this.myText.getLocation();
    }

    public Menu getMenu() {
        return this.myText.getMenu();
    }

    public String getMessage() {
        return this.myText.getMessage();
    }

    public Monitor getMonitor() {
        return this.myText.getMonitor();
    }

    public int getOrientation() {
        return this.myText.getOrientation();
    }

    public Composite getParent() {
        return this.myText.getParent();
    }

    public Region getRegion() {
        return this.myText.getRegion();
    }

    public Point getSelection() {
        return this.myText.getSelection();
    }

    public int getSelectionCount() {
        return this.myText.getSelectionCount();
    }

    public String getSelectionText() {
        return this.myText.getSelectionText();
    }

    public Shell getShell() {
        return this.myText.getShell();
    }

    public Point getSize() {
        return this.myText.getSize();
    }

    public int getStyle() {
        return this.myText.getStyle();
    }

    public int getTabs() {
        return this.myText.getTabs();
    }

    public String getRawText() {
        return this.myText.getText();
    }

    public String getText() {
        if (this.mask != null) {
            return this.mask.unapply(this.myText.getText());
        }
        return this.myText.getText();
    }

    public String getText(int start, int end) {
        return this.myText.getText(start, end);
    }

    public int getTextLimit() {
        return this.myText.getTextLimit();
    }

    public String getToolTipText() {
        return this.myText.getToolTipText();
    }

    public int getTopIndex() {
        return this.myText.getTopIndex();
    }

    public int getTopPixel() {
        return this.myText.getTopPixel();
    }

    public ScrollBar getVerticalBar() {
        return this.myText.getVerticalBar();
    }

    public boolean getVisible() {
        return this.myText.getVisible();
    }

    public int hashCode() {
        return this.myText.hashCode();
    }

    public void insert(String string) {
        this.myText.insert(string);
    }

    public boolean isDisposed() {
        return this.myText.isDisposed();
    }

    public boolean isEnabled() {
        return this.myText.isEnabled();
    }

    public boolean isFocusControl() {
        return this.myText.isFocusControl();
    }

    public boolean isListening(int eventType) {
        return this.myText.isListening(eventType);
    }

    public boolean isReparentable() {
        return this.myText.isReparentable();
    }

    public boolean isVisible() {
        return this.myText.isVisible();
    }

    public void moveAbove(Control control) {
        this.myText.moveAbove(control);
    }

    public void moveBelow(Control control) {
        this.myText.moveBelow(control);
    }

    public void notifyListeners(int eventType, Event event) {
        this.myText.notifyListeners(eventType, event);
    }

    public void pack() {
        this.myText.pack();
    }

    public void pack(boolean changed) {
        this.myText.pack(changed);
    }

    public void paste() {
        this.myText.paste();
    }

    public boolean print(GC gc) {
        return this.myText.print(gc);
    }

    public void redraw() {
        this.myText.redraw();
    }

    public void redraw(int x, int y, int width, int height, boolean all) {
        this.myText.redraw(x, y, width, height, all);
    }

    public void removeControlListener(ControlListener listener) {
        this.myText.removeControlListener(listener);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.myText.removeDisposeListener(listener);
    }

    public void removeDragDetectListener(DragDetectListener listener) {
        this.myText.removeDragDetectListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.myText.removeFocusListener(listener);
    }

    public void removeHelpListener(HelpListener listener) {
        this.myText.removeHelpListener(listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.myText.removeKeyListener(listener);
    }

    public void removeMenuDetectListener(MenuDetectListener listener) {
        this.myText.removeMenuDetectListener(listener);
    }

    public void removeMouseListener(MouseListener listener) {
        this.myText.removeMouseListener(listener);
    }

    public void removeMouseMoveListener(MouseMoveListener listener) {
        this.myText.removeMouseMoveListener(listener);
    }

    public void removeMouseTrackListener(MouseTrackListener listener) {
        this.myText.removeMouseTrackListener(listener);
    }

    public void removeMouseWheelListener(MouseWheelListener listener) {
        this.myText.removeMouseWheelListener(listener);
    }

    public void removePaintListener(PaintListener listener) {
        this.myText.removePaintListener(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.myText.removeSelectionListener(listener);
    }

    public void removeTraverseListener(TraverseListener listener) {
        this.myText.removeTraverseListener(listener);
    }

    public void removeVerifyListener(VerifyListener listener) {
        this.myText.removeVerifyListener(listener);
    }

    public void selectAll() {
        this.myText.selectAll();
    }

    public void setBackground(Color color) {
        this.myText.setBackground(color);
        this.background = color;
    }

    public void setBackgroundImage(Image image) {
        this.myText.setBackgroundImage(image);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.myText.setBounds(x, y, width, height);
    }

    public void setBounds(Rectangle rect) {
        this.myText.setBounds(rect);
    }

    public void setCapture(boolean capture) {
        this.myText.setCapture(capture);
    }

    public void setCursor(Cursor cursor) {
        this.myText.setCursor(cursor);
    }

    public void setData(Object data) {
        this.myText.setData(data);
    }

    public void setData(String key, Object value) {
        this.myText.setData(key, value);
    }

    public void setDoubleClickEnabled(boolean doubleClick) {
        this.myText.setDoubleClickEnabled(doubleClick);
    }

    public void setDragDetect(boolean dragDetect) {
        this.myText.setDragDetect(dragDetect);
    }

    public void setEchoChar(char echo) {
        this.myText.setEchoChar(echo);
    }

    public void setEditable(boolean editable) {
        this.myText.setEditable(editable);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.myText.setEnabled(enabled);
    }

    public boolean setFocus() {
        return this.myText.setFocus();
    }

    public void setFont(Font font) {
        this.myText.setFont(font);
    }

    public void setForeground(Color color) {
        this.myText.setForeground(color);
        this.foreground = color;
    }

    public void setLayoutData(Object layoutData) {
        this.myText.setLayoutData(layoutData);
    }

    public void setLocation(int x, int y) {
        this.myText.setLocation(x, y);
    }

    public void setLocation(Point location) {
        this.myText.setLocation(location);
    }

    public void setMenu(Menu menu) {
        this.myText.setMenu(menu);
    }

    public void setMessage(String message) {
        this.myText.setMessage(message);
    }

    public void setOrientation(int orientation) {
        this.myText.setOrientation(orientation);
    }

    public boolean setParent(Composite parent) {
        return this.myText.setParent(parent);
    }

    public void setRedraw(boolean redraw) {
        this.myText.setRedraw(redraw);
    }

    public void setRegion(Region region) {
        this.myText.setRegion(region);
    }

    public void setSelection(int start, int end) {
        this.myText.setSelection(start, end);
    }

    public void setSelection(int start) {
        this.myText.setSelection(start);
    }

    public void setSelection(Point selection) {
        this.myText.setSelection(selection);
    }

    public void setSize(int width, int height) {
        this.myText.setSize(width, height);
    }

    public void setSize(Point size) {
        this.myText.setSize(size);
    }

    public void setTabs(int tabs) {
        this.myText.setTabs(tabs);
    }

    public void clear() {
        this.setRawText(null);
    }

    public void setText(String string) {
        String string2 = string = string == null ? "" : string;
        if (this.mask != null && !this.validNotSetText) {
            string = this.mask.apply(string);
        }
        this.setRawText(string);
    }

    public void setTextKeepSelection(String string) {
        String string2 = string = string == null ? "" : string;
        if (this.mask != null && !this.validNotSetText) {
            string = this.mask.apply(string);
        }
        this.setRawTextKeepSelection(string);
    }

    public void setRawText(String string) {
        String string2 = string = string == null ? "" : string;
        if (!this.getText().equals(string)) {
            this.settext = true;
            this.myText.setText(string);
            this.settext = false;
        }
    }

    public void setRawTextKeepSelection(String string) {
        String string2 = string = string == null ? "" : string;
        if (!this.getText().equals(string)) {
            this.settext = true;
            Point selection = this.myText.getSelection();
            this.myText.setText(string);
            this.myText.setSelection(selection);
            this.settext = false;
        }
    }

    public void setTextLimit(int limit) {
        this.myText.setTextLimit(limit);
    }

    public void setToolTipText(String string) {
        this.myText.setToolTipText(string);
    }

    public void setTopIndex(int index) {
        this.myText.setTopIndex(index);
    }

    public void setVisible(boolean visible) {
        this.myText.setVisible(visible);
    }

    public void showSelection() {
        this.myText.showSelection();
    }

    public Point toControl(int x, int y) {
        return this.myText.toControl(x, y);
    }

    public Point toControl(Point point) {
        return this.myText.toControl(point);
    }

    public Point toDisplay(int x, int y) {
        return this.myText.toDisplay(x, y);
    }

    public Point toDisplay(Point point) {
        return this.myText.toDisplay(point);
    }

    public boolean traverse(int traversal) {
        return this.myText.traverse(traversal);
    }

    public void update() {
        this.myText.update();
    }

    public PredicateA<String> getValidPredicate() {
        return this.validPredicate;
    }

    public void setValidPredicate(PredicateA<String> validPredicate) {
        this.validPredicate = validPredicate;
    }

    public boolean isEventFromKey() {
        return this.myText.isEventFromKey();
    }

    public boolean isValidNotSetText() {
        return this.validNotSetText;
    }

    private class ListenerProxy
    implements Listener {
        private Listener listener;

        private ListenerProxy(Listener listener) {
            this.listener = listener;
        }

        public void handleEvent(Event e) {
            if (MyMaskedText.this.externModifyTextDoit) {
                this.listener.handleEvent(e);
            }
        }
    }

    private class ModifyListenerProxy
    implements ModifyListener {
        private ModifyListener listener;

        private ModifyListenerProxy(ModifyListener listener) {
            this.listener = listener;
        }

        public void modifyText(ModifyEvent e) {
            if (MyMaskedText.this.externModifyTextDoit) {
                this.listener.modifyText(e);
            }
        }
    }

    private class TextChangeListener
    implements Listener {
        private TextChangeListener() {
        }

        public void handleEvent(Event event) {
            if (event.type == 16) {
                MyMaskedText.this.focusOutEvent();
            } else if (event.type == 15) {
                MyMaskedText.this.focusInEvent();
            }
            if (!MyMaskedText.this.externModifyTextDoit) {
                return;
            }
            MyMaskedText.this.externModifyTextDoit = false;
            if (event.type == 25) {
                MyMaskedText.this.verifyEvent(event);
            } else if (event.type == 24) {
                MyMaskedText.this.modifyEvent(event);
            }
            MyMaskedText.this.externModifyTextDoit = true;
        }
    }
}

