/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.browser;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.convert.IConvertProcessor;
import ca.infodata.ofys.client.gson.GsonDelegate;
import ca.infodata.ofys.client.web.core.IServerRequestHandler;
import ca.infodata.ofys.client.web.core.IWebApplication;
import ca.infodata.ofys.client.web.core.IWebResource;
import ca.infodata.ofys.client.web.core.IWebResourcesDelegate;
import ca.infodata.ofys.client.web.core.IWebSocketChannel;
import ca.infodata.ofys.client.web.core.IWebSocketDelegate;
import ca.infodata.ofys.client.web.core.IWebSocketFilter;
import ca.infodata.ofys.client.web.core.WebSocketResponse;
import ca.infodata.ofys.ui.browser.HtmlBrowserTools;
import ca.infodata.ofys.ui.browser.sonar.SonarDispatcher;
import ca.infodata.ofys.ui.browser.sonar.SonarWS;
import ca.infodata.util1.ProviderR;
import java.io.IOException;
import java.net.URL;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "ca.infodata.ofys.ui.browser";
    private static Activator plugin;

    public void stopJetty() {
        HtmlBrowserTools.stopJetty();
    }

    public void restartJetty() {
        HtmlBrowserTools.stopJetty();
        HtmlBrowserTools.startJetty(this.getBundle().getBundleContext());
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        final IWebSocketDelegate webSocketDelegate = new IWebSocketDelegate(){

            public void send(IWebSocketFilter filter, ProviderR<String> msgDelegate) {
                SonarWS.send(filter, msgDelegate);
            }

            public void send(IWebSocketFilter filter, String msg) {
                SonarWS.send(filter, msg);
            }

            public void send(IWebSocketFilter filter, WebSocketResponse wsResponse) {
                SonarWS.send(filter, (ProviderR<String>)new GsonDelegate((Object)wsResponse));
            }

            public IWebSocketChannel get(IWebSocketFilter filter) {
                return SonarWS.get(filter);
            }
        };
        final IWebResourcesDelegate webResourcesDelegate = new IWebResourcesDelegate(){

            public IWebResource newHtmlPdfViewerResource(String resourceName, byte[] pdf, boolean allowPrinting, boolean recentViewer) throws IOException {
                return HtmlBrowserTools.newHtmlPdfViewerResource(resourceName, pdf, allowPrinting, recentViewer);
            }

            public boolean hasHtmlPdfViewerResource(String resourceName) {
                return HtmlBrowserTools.hasHtmlPdfViewerResource(resourceName, null);
            }

            public boolean hasHtmlImageViewerResource(String resourceName) {
                return HtmlBrowserTools.hasHtmlImageViewerResource(resourceName);
            }

            public IWebResource getOrCreateImageViewerResource(String resourceName, byte[] data) throws IOException {
                return HtmlBrowserTools.getOrCreateImageViewerResource(resourceName, data);
            }

            public IWebResource getOrCreateHtmlPdfViewerResource(String resourceName, byte[] pdf, boolean allowPrinting, boolean recentViewer) throws IOException {
                return HtmlBrowserTools.getOrCreateHtmlPdfViewerResource(resourceName, pdf, allowPrinting, recentViewer);
            }

            public IWebResource getOrCreateHtmlPdfResource(String resourceName, byte[] pdf) throws IOException {
                return HtmlBrowserTools.getOrCreateHtmlPdfResource(resourceName, null, pdf);
            }

            public IWebResource getImageViewerResource(String resourceName) {
                return HtmlBrowserTools.getImageViewerResource(resourceName, null);
            }

            public IWebResource getHtmlPdfViewerResource(String resourceName) {
                return HtmlBrowserTools.getHtmlPdfViewerResource(resourceName, null);
            }

            public IWebResource getHtmlPdfResource(String resourceName) {
                return HtmlBrowserTools.getHtmlPdfResource(resourceName, null);
            }

            public IWebResource newHtmlPdfResource(String resourceName, byte[] pdf) throws IOException {
                return HtmlBrowserTools.newHtmlPdfResource(resourceName, null, pdf);
            }

            public IWebResource newHtmlPdfViewerResource(byte[] pdf, boolean allowPrinting, boolean recentViewer) throws IOException {
                return HtmlBrowserTools.newHtmlPdfViewerResource(pdf, allowPrinting, recentViewer);
            }

            public IWebResource newHtmlPdfResource(byte[] pdf) throws IOException {
                return HtmlBrowserTools.newHtmlPdfResource(pdf);
            }
        };
        Application.get().setWebApplication(new IWebApplication(){

            public IWebSocketDelegate getWebSocketDelegate() {
                return webSocketDelegate;
            }

            public IConvertProcessor getConvertProcessor() {
                return Application.get().getConvertProcessor();
            }

            public void dispose() {
            }

            public void restart() {
                Activator.getDefault().restartJetty();
            }

            public IWebResourcesDelegate getWebResourcesDelegate() {
                return webResourcesDelegate;
            }

            public IServerRequestHandler getServerRequestHandler() {
                throw new UnsupportedOperationException();
            }

            public URL getPublicURL() {
                return HtmlBrowserTools.getJettyURL();
            }
        });
        SonarDispatcher.startSonar();
    }

    public void stop(BundleContext context) throws Exception {
        SonarDispatcher.getInstance().stopSonar();
        HtmlBrowserTools.stopJetty();
        super.stop(context);
        plugin = null;
    }

    public static Activator getDefault() {
        return plugin;
    }
}

