/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.search;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentPeriodType;
import ca.infodata.ofys.ui.appointment.AppointmentPlugin;
import ca.infodata.ofys.ui.appointment.search.ComplexSearchController;
import ca.infodata.ofys.ui.appointment.search.ListBasedCriteriaControl;
import ca.infodata.util1.date.LocaleProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class AppointmentPeriodTypeCriteriaControl
extends ListBasedCriteriaControl<XAppointmentPeriodType> {
    private List<XAppointmentPeriodType> list = AppointmentPeriodTypeCriteriaControl.getTypes();

    public AppointmentPeriodTypeCriteriaControl(Composite parent, int style, FormToolkit toolkit) {
        super(parent, style, Messages.getString((String)"PERIODES", (String[])new String[0]), toolkit);
    }

    private static List<XAppointmentPeriodType> getTypes() {
        ArrayList<XAppointmentPeriodType> types = new ArrayList<XAppointmentPeriodType>(AppointmentPlugin.getDefault().getPeriodTypes());
        Iterator iterator = types.iterator();
        while (iterator.hasNext()) {
            XAppointmentPeriodType type = (XAppointmentPeriodType)iterator.next();
            if (type.isActive() && Boolean.TRUE.equals(type.getCanHaveAppointment())) continue;
            iterator.remove();
        }
        return types;
    }

    @Override
    protected List<XAppointmentPeriodType> getList() {
        return this.list;
    }

    public void propertyChanged(int propertyId) {
        if (propertyId == 5 || propertyId == 11) {
            this.refreshPopup();
        }
    }

    @Override
    protected void dataSelectedInControl(XAppointmentPeriodType e, boolean selected) {
        ComplexSearchController controller = this.getController();
        if (controller != null) {
            if (selected) {
                controller.getPeriodTypes().add(e);
            } else {
                controller.getPeriodTypes().remove(e);
            }
        }
    }

    @Override
    protected boolean isDataSelectedInController(XAppointmentPeriodType e) {
        if (this.getController() == null) {
            return false;
        }
        return this.getController().getPeriodTypes().contains(e);
    }

    @Override
    protected String getTextForItem(XAppointmentPeriodType e) {
        if (LocaleProvider.isEnglish()) {
            return e.getEnglish();
        }
        if (LocaleProvider.isSpanish()) {
            return e.getSpanish();
        }
        return e.getFrench();
    }

    @Override
    protected void reset() {
        if (this.getController() != null) {
            this.getController().getPeriodTypes().clear();
            this.refreshPopup();
        }
    }
}

