/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.menu;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.AppointmentAccessorClient;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XImageDecorator;
import ca.infodata.ofys.data.middle.dataobjects.appointment.IAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientStatus;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.ui.appointment.AppointmentPlugin;
import ca.infodata.ofys.ui.appointment.menu.PatientAppointmentElements;
import ca.infodata.ofys.ui.controls.ITreeElements;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.menu.DossierPlugin;
import ca.infodata.ofys.ui.menu.treeelements.LoadingElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorInput;

public class ListPatientFutureAppointments
implements ITreeElements,
IFontProvider {
    private static final Logger logger = Logger.getLogger(ListPatientFutureAppointments.class.getName());
    private static final String FUTURS = Messages.getString((String)"FUTURS", (String[])new String[0]);
    private ITreeElements parent;
    private IPatient patient;
    private boolean isLoading;
    private ITreeElements[] children;
    public int childrenNumber = -1;

    public ListPatientFutureAppointments(ITreeElements parent, IPatient patient) {
        if (patient == null || parent == null) {
            throw new IllegalArgumentException();
        }
        this.parent = parent;
        this.patient = patient;
    }

    public Object[] getChildren() {
        if (this.notLoaded()) {
            this.fillAsLoading();
        }
        return this.children;
    }

    private void fillAsLoading() {
        this.isLoading = true;
        this.children = new ITreeElements[]{new LoadingElement((ITreeElements)this)};
        this.findFutureAppointments();
    }

    private boolean notLoaded() {
        return this.children == null || this.isLoading;
    }

    private void findFutureAppointments() {
        try {
            AppointmentAccessorClient.getInstance().findFutureAppointmentsByPatient(this.patient.hashCode(), Application.get().getGlobalInstances().getSession(), (ICallback)new JobCallback(Messages.getString((String)"TROUVER_LES_RENDEZVOUS_FUTURS", (String[])new String[0]), (IStatusHandler)DefaultStatusHandler.getInstance()){

                public void responseReceived(ReturnObject response) {
                    if (response == null || response.getObj() == null) {
                        ListPatientFutureAppointments.this.fill(Collections.EMPTY_LIST);
                    } else {
                        ListPatientFutureAppointments.this.fill((List)response.getObj());
                    }
                }
            }, this.patient.getId().intValue());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Erreur", e);
            this.fill(Collections.EMPTY_LIST);
        }
    }

    private void fill(List<IAppointment> appointments) {
        Collections.sort(appointments, AppointmentPlugin.getDefault().getXAppointmentComparator(true));
        ArrayList<PatientAppointmentElements> listChild = new ArrayList<PatientAppointmentElements>(appointments.size() + 2);
        for (IAppointment appointment : appointments) {
            if (Boolean.TRUE.equals(appointment.getIsDeleted()) || appointment.getPatientStatus() == XPatientStatus.CANCEL || appointment.getPatientStatus() == XPatientStatus.CANCEL_LESS_24H) continue;
            listChild.add(new PatientAppointmentElements(this, appointment));
        }
        this.children = listChild.toArray(new ITreeElements[listChild.size()]);
        this.refreshTree();
        this.isLoading = false;
    }

    private void refreshTree() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                TreeViewer treeViewer = DossierPlugin.getDefault().getTreeViewer();
                Tree tree = treeViewer.getTree();
                if (tree != null && !tree.isDisposed()) {
                    treeViewer.refresh(ListPatientFutureAppointments.this.getParent());
                }
            }
        });
    }

    public Object getParent() {
        return this.parent;
    }

    public boolean hasChildren() {
        return true;
    }

    public String getText() {
        return FUTURS;
    }

    public String getTooltipText() {
        return this.getText();
    }

    public Image getImage() {
        return ResourceGetter.getImage((String)"images/rendez-vous.gif");
    }

    public String getEditorClass() {
        return null;
    }

    public IEditorInput getEditorInput() {
        return null;
    }

    public XImageDecorator getDecorators() {
        return XImageDecorator.NULL_DECORATORS;
    }

    public void showContextMenu(Control control) {
    }

    public int hashCode() {
        return new String(String.valueOf(this.parent.hashCode()) + " " + this.getClass().getName()).hashCode();
    }

    public boolean equals(Object toCompare) {
        boolean ret = false;
        if (toCompare instanceof ListPatientFutureAppointments && toCompare.hashCode() == this.hashCode()) {
            ret = true;
        }
        return ret;
    }

    public void doKeyListener(Control control, KeyEvent ke) {
    }

    public int getChildrenNumberForPastille() {
        return this.childrenNumber;
    }

    public Font getFont(Object element) {
        return ResourceGetter.getFontNormal();
    }
}

