/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.editor;

import ca.infodata.ofys.ui.appointment.editor.MyScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;

class ScrolledCompositeLayout
extends Layout {
    boolean inLayout = false;
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;

    ScrolledCompositeLayout() {
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        MyScrolledComposite sc = (MyScrolledComposite)composite;
        Point size = new Point(64, 64);
        if (sc.content != null) {
            Point preferredSize = sc.content.computeSize(wHint, hHint, flushCache);
            Point currentSize = sc.content.getSize();
            size.x = sc.getExpandHorizontal() ? preferredSize.x : currentSize.x;
            int n = size.y = sc.getExpandVertical() ? preferredSize.y : currentSize.y;
        }
        if (wHint != -1) {
            size.x = wHint;
        }
        if (hHint != -1) {
            size.y = hHint;
        }
        return size;
    }

    protected boolean flushCache(Control control) {
        return true;
    }

    protected void layout(Composite composite, boolean flushCache) {
        if (this.inLayout) {
            return;
        }
        MyScrolledComposite sc = (MyScrolledComposite)composite;
        if (sc.content == null) {
            return;
        }
        ScrollBar hBar = sc.getHorizontalBar();
        ScrollBar vBar = sc.getVerticalBar();
        if (hBar != null && hBar.getSize().y >= sc.getSize().y) {
            return;
        }
        if (vBar != null && vBar.getSize().x >= sc.getSize().x) {
            return;
        }
        this.inLayout = true;
        Rectangle hostRect = sc.getClientArea();
        Point contentSize = sc.content.computeSize(-1, -1);
        Rectangle contentRect = sc.content.getBounds();
        contentRect = new Rectangle(contentRect.x, contentRect.y, hostRect.width, hostRect.height);
        if (vBar != null) {
            contentRect.height = Math.max(contentSize.y, hostRect.height);
        }
        if (hBar != null) {
            contentRect.width = Math.max(contentSize.y, hostRect.width);
        }
        if (!sc.alwaysShowScroll) {
            boolean hVisible = sc.needHScroll(contentRect, false);
            boolean vVisible = sc.needVScroll(contentRect, hVisible);
            if (!hVisible && vVisible) {
                hVisible = sc.needHScroll(contentRect, vVisible);
            }
            if (hBar != null) {
                hBar.setVisible(hVisible);
            }
            if (vBar != null) {
                vBar.setVisible(vVisible);
            }
        }
        if (hBar != null) {
            hBar.setMaximum(contentRect.width);
            hBar.setThumb(Math.min(contentRect.width, hostRect.width));
            int hPage = contentRect.width - hostRect.width;
            int hSelection = hBar.getSelection();
            if (hSelection >= hPage) {
                if (hPage <= 0) {
                    hSelection = 0;
                    hBar.setSelection(0);
                }
                contentRect.x = -hSelection;
            }
        }
        if (vBar != null) {
            vBar.setMaximum(contentRect.height);
            vBar.setThumb(Math.min(contentRect.height, hostRect.height));
            int vPage = contentRect.height - hostRect.height;
            int vSelection = vBar.getSelection();
            if (vSelection >= vPage) {
                if (vPage <= 0) {
                    vSelection = 0;
                    vBar.setSelection(0);
                }
                contentRect.y = -vSelection;
            }
        }
        sc.content.setBounds(contentRect);
        this.inLayout = false;
    }
}

