/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.contextmenu;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.AppointmentAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.appointment.IAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientStatus;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.patient.IPatientRelated;
import ca.infodata.ofys.ui.appointment.AppointmentPlugin;
import ca.infodata.ofys.ui.appointment.XAppointmentFormatter;
import ca.infodata.ofys.ui.controls.ControlsPlugin;
import ca.infodata.ofys.ui.controls.plugins.searchview.ISearchSelectionContextMenuContribution;
import ca.infodata.ofys.ui.person.print.PatientPrintDialog;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ArmEvent;
import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class PatientSearchViewContextMenuContribution
implements ISearchSelectionContextMenuContribution {
    private static final Logger logger = Logger.getLogger("ca.infodata.ofys.ui.appointment.contextmenu.PatientSearchViewContextMenuContribution");

    public void contributeContextMenuTo(ISelection selection, Control control) {
        IStructuredSelection structuredSelection;
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1) {
            Object element = structuredSelection.getFirstElement();
            IPatient patient = null;
            if (element instanceof IPatientRelated) {
                patient = ((IPatientRelated)element).getPatient();
            } else if (element instanceof IPatient) {
                patient = (IPatient)element;
            }
            if (patient != null) {
                Menu menu = this.getMenu(control);
                this.addPrintToContextMenu(patient, control, menu);
                this.addShowPastAppointmentToContextMenu(patient, control, menu);
                this.addShowFuturAppointmentToContextMenu(patient, control, menu);
            }
        }
    }

    private Menu getMenu(Control control) {
        if (control.isDisposed()) {
            return null;
        }
        if (control.getMenu() == null) {
            Menu menu = new Menu(control);
            control.setMenu(menu);
            return menu;
        }
        return control.getMenu();
    }

    private void addPrintToContextMenu(final IPatient patient, final Control control, Menu parent) {
        MenuItem item = new MenuItem(parent, 8);
        item.setText(Messages.getString((String)"IMPRIMER", (String[])new String[0]));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new PatientPrintDialog(control.getShell(), patient).open();
            }
        });
        new MenuItem(parent, 2);
    }

    private void addShowFuturAppointmentToContextMenu(final IPatient patient, final Control control, final Menu parent) {
        final MenuItem item = new MenuItem(parent, 64);
        item.setText(Messages.getString((String)"RENDEZVOUS_FUTURS", (String[])new String[0]));
        item.addArmListener(new ArmListener(){

            public void widgetArmed(ArmEvent e) {
                PatientSearchViewContextMenuContribution.this.loadFuturSubMenu(patient, control, parent, item);
            }
        });
    }

    private void addShowPastAppointmentToContextMenu(final IPatient patient, final Control control, final Menu parent) {
        final MenuItem item = new MenuItem(parent, 64);
        item.setText(Messages.getString((String)"RENDEZVOUS_PASSES", (String[])new String[0]));
        item.addArmListener(new ArmListener(){

            public void widgetArmed(ArmEvent e) {
                PatientSearchViewContextMenuContribution.this.loadPastSubMenu(patient, control, parent, item);
            }
        });
    }

    protected void loadFuturSubMenu(IPatient patient, Control control, Menu parent, MenuItem item) {
        if (item.getMenu() == null) {
            Menu menu = new Menu(parent);
            item.setMenu(menu);
            this.showFuturAppointments(patient, menu);
        }
    }

    protected void loadPastSubMenu(IPatient patient, Control control, Menu parent, MenuItem item) {
        if (item.getMenu() == null) {
            Menu menu = new Menu(parent);
            item.setMenu(menu);
            this.showPastAppointments(patient, menu);
        }
    }

    private void showFuturAppointments(IPatient patient, final Menu parent) {
        block4: {
            final MenuItem loadingItem = new MenuItem(parent, 8);
            loadingItem.setText(String.valueOf(Messages.getString((String)"CHARGEMENT", (String[])new String[0])) + "...");
            JobCallback callback = new JobCallback(Messages.getString((String)"RECHERCHE", (String[])new String[0]), ControlsPlugin.getDefaultStatusHandler()){

                public void responseReceived(ReturnObject response) {
                    final List appointments = response == null ? new ArrayList(0) : (List)response.getObj();
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!parent.isDisposed()) {
                                loadingItem.dispose();
                                PatientSearchViewContextMenuContribution.this.fill(parent, appointments);
                            }
                        }
                    });
                }
            };
            try {
                AppointmentAccessorClient.getInstance().findFutureAppointmentsByPatient(this.hashCode(), Application.get().getGlobalInstances().getSession(), (ICallback)callback, patient.getId().intValue());
            }
            catch (CannotConnectToServerException cannotConnectToServerException) {
                if (callback != null && !callback.killed()) {
                    callback.kill();
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to find futures appointments for patient " + patient.getId(), e);
                if (callback == null || callback.killed()) break block4;
                callback.kill();
            }
        }
    }

    private void showPastAppointments(IPatient patient, final Menu parent) {
        block4: {
            final MenuItem loadingItem = new MenuItem(parent, 8);
            loadingItem.setText(String.valueOf(Messages.getString((String)"CHARGEMENT", (String[])new String[0])) + "...");
            JobCallback callback = new JobCallback(Messages.getString((String)"RECHERCHE", (String[])new String[0]), ControlsPlugin.getDefaultStatusHandler()){

                public void responseReceived(ReturnObject response) {
                    final List appointments = response == null ? new ArrayList(0) : (List)response.getObj();
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!parent.isDisposed()) {
                                loadingItem.dispose();
                                PatientSearchViewContextMenuContribution.this.fill(parent, appointments);
                            }
                        }
                    });
                }
            };
            try {
                AppointmentAccessorClient.getInstance().findPastAppointmentsByPatient(this.hashCode(), Application.get().getGlobalInstances().getSession(), (ICallback)callback, patient.getId().intValue());
            }
            catch (CannotConnectToServerException cannotConnectToServerException) {
                if (callback != null && !callback.killed()) {
                    callback.kill();
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to find past appointments for patient " + patient.getId(), e);
                if (callback == null || callback.killed()) break block4;
                callback.kill();
            }
        }
    }

    protected void fill(Menu parent, List<IAppointment> list) {
        if (list.size() == 0) {
            this.addEmptyItem(parent);
        } else {
            for (IAppointment appointment : list) {
                if (Boolean.TRUE.equals(appointment.getIsDeleted()) || appointment.getPatientStatus() == XPatientStatus.CANCEL || appointment.getPatientStatus() == XPatientStatus.CANCEL_LESS_24H) continue;
                MenuItem item = new MenuItem(parent, 8);
                item.setText(XAppointmentFormatter.format(appointment, true, true, false, true, true, true));
                item.setData((Object)appointment);
                this.addSelectionListener(item, appointment);
            }
        }
    }

    private void addEmptyItem(Menu parent) {
        MenuItem item = new MenuItem(parent, 8);
        item.setText(Messages.getString((String)"Print.AUCUN", (String[])new String[0]));
        item.setData(null);
    }

    private void addSelectionListener(MenuItem item, final IAppointment appointment) {
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AppointmentPlugin.getDefault().openAppointmentEditor("PatientAppointmentContextMenuElement", appointment);
            }
        });
    }
}

