var QA = {};
(function(){
	$("head").append('<style type="text/css">.qa_dialog_box, .qa_dialog_box td'+
		'{font-family: "Arial";font-size:1.4em;}'+
		'.qa_dialog_box  .ui-dialog-titlebar'+
		'{background-color: transparent;border: transparent;}'+
		'.qa_dialog_box .ui-dialog-titlebar-close {display: none;}</style>');
	var cb;
	function makeDialog(content){
		removeDialog();
		var dialog = $('<div id="QADialogBox"></div>').append($('<div>' + content + '</div>'));
		$("body").append(dialog);
	}

	QA.tell = function(tell, dialogOpt){
		makeDialog(tell.tell);
		var dialogOptions = {
		  dialogClass: "qa_dialog_box",
		  minWidth: 500,
		  modal: true
		};
		
		if(dialogOpt){
			$.extend(dialogOptions, dialogOpt);
		}
		$( "#QADialogBox" ).dialog(dialogOptions);
	};
	
	
	function removeDialog(){
		$("#QADialogBox").remove();
	}
	
	var csstPrefillForm = '<form id="csst_prefill_form" action="action" method="get">'+
				'<h5 style="margin: 0 0 10px 0;">Veuillez repondre aux questions suivantes : </h5>'+
				'<table>'+
				'	<tr>'+
				'		<td>1. Est-ce qu’il s’agit d’une demande de retrait préventif ?</td>'+
				'		<td> <input type="radio" value="oui" name="retrait"/> Oui </td>'+
				'		<td> <input  type="radio" value="non" name="retrait"/>Non </td>'+
				'	</tr>'+
				'	<tr>'+
				'		<td>2. Est-ce qu’il s’agit d’une lésion professionnelle ?</td>'+
				'		<td> <input type="radio" value="oui" name="lesion"/>Oui </td>'+
				'		<td> <input  type="radio" value="non" name="lesion"/>Non </td>'+
				'	</tr>'+
				'	<tr>'+
				'		<td>3. Est-ce qu’il s’agit d’une victime d’acte criminel ?</td>'+
				'		<td> <input type="radio" value="oui" name="criminel"/>Oui </td>'+
				'		<td> <input  type="radio" value="non" name="criminel"/>Non </td>'+
				'	</tr>'+
				'	<tr>'+
				'		<td>4. Est-ce qu’il s’agit d’un sauveteur (acte de civisme) ?</td>'+
				'		<td> <input type="radio" value="oui" name="civisme"/>Oui </td>'+
				'		<td> <input  type="radio" value="non" name="civisme"/>Non </td>'+
				'	</tr>'+
				'</table>'+
			'</form>';

	function getCSSTFormValues(){
		var res = {}, checked;
		var questions = ['retrait', 'lesion', 'criminel', 'civisme'];
		for(var i = 0; i < questions.length; i++){
			checked = $('input[name=' + questions[i] + ']:checked', '#csst_prefill_form').val();
			if(checked){
				res[questions[i]] = checked;
			}
		}
		return res;
	}

	
	QA.csstPopQuiz = function(callback){
		var csstFormValues;
		
		var opt = {
			minWidth: 650,
			buttons: [
				{
					text: "Continuer",
					click: function() {
						csstFormValues = getCSSTFormValues();
						if(callback){
							callback(csstFormValues);
						}
						$(this).dialog("close");
					}
				}
			]
		};
		QA.tell({tell:csstPrefillForm}, opt);
	};
})();


var formValidator = {};

(function(){
	$("head").append('<style type="text/css">div.error'+
		'{display: block;border: solid 1px red;color: red;}');

	//IsNotEmpty
	formValidator.IsNotEmpty = function() { 
	    this.varLen = undefined;
	    this.varMaxLen = undefined;
	};
	formValidator.IsNotEmpty.prototype.validate = function(modelObject, modelArray) {
        for (var i = 0; i < modelArray.length; i++) {
            var z = getValue(modelObject, modelArray[i]);
            if (z) {
                if (this.varMaxLen) {
                    if (z.length > this.varMaxLen) {
                        return false;
                    }
                }
                if (this.varLen) {
                    if (z.length !== this.varLen) {
                        return false;
                    }
                }
            } else {
                return false;
            }
        }
        return true;
    };
	formValidator.IsNotEmpty.prototype.maxLen = function(n) {
	    this.varMaxLen = n; 
	    return this;
	};
	formValidator.IsNotEmpty.prototype.len = function(n) {
	    this.varLen = n; 
	    return this;
	};

	//IsNumber
	formValidator.IsNumber = function() {};
	formValidator.IsNumber.prototype.validate = function(modelObject, modelArray) {
        for (var i = 0; i < modelArray.length; i++) {
            var z = getValue(modelObject, modelArray[i]);
            if (z) {
                if (!z.match(/^\d+$/)) {
                    return false;
                }
                if (this.varMax) {
                    if (parseInt(z) > this.varMax) {
                        return false;
                    }
                } 
                if (this.varMin) {
                    if (parseInt(z) < this.varMin) {
                        return false;
                    }
                }
            }
        }
        return true;
	};
	formValidator.IsNumber.prototype.max = function (n) {this.varMax = n; return this;}; 
	formValidator.IsNumber.prototype.min = function (n) {this.varMin = n; return this;}; 

	var getValue = function(modelObject, model) {
	    var value = modelObject[model];
	    if (value === undefined) {
	        throw "value is undefined for model " + model;
	    }
	    return value;
	};
	
	formValidator.validators = {
	    "isEmpty": function(modelObject, modelArray) {
	        for (var i = 0; i < modelArray.length; i++) {
	            if (getValue(modelObject, modelArray[i])) {
	                return false;
	            }
	        }
	        return true;
	    },
	    "isNotEmpty" : new formValidator.IsNotEmpty(),
        "isNotEmptyOr": function(modelObject, modelArray) {
            for (var i = 0; i < modelArray.length; i++) {
                if (getValue(modelObject, modelArray[i])) {
                    return true;
                }
            }
            return false;
        },
        "isNotEmptyXor": function(modelObject, modelArray) {
            var filled =  false;
            for (var i = 0; i < modelArray.length; i++) {
                if (getValue(modelObject, modelArray[i])) {
                    if (filled) {
                        return false;
                    } else {
                        filled = true;
                    }
                }
            }
            return filled;
        },        
		isDate: function (modelObject, modelArray){
		    for (var i = 0; i < modelArray.length; i++) {
		        var z = getValue(modelObject, modelArray[i]);
                if (z) {
                    if (!z.match(/^(\d{4})[\/\-](0?[1-9]|1[012])[\/\-](0?[1-9]|[12][0-9]|3[01])$/)) {
                        return false;
                    }
                }
		    }
		    return true;
		},
		"isNumber" : new formValidator.IsNumber(), 
		isCanadaPostalCode: function (modelObject, modelArray){
		    for (var i = 0; i < modelArray.length; i++) {
		        var z = getValue(modelObject, modelArray[i]);
                if (z) {
                    if (!z.match(/^[A-Z]{1}[0-9]{1}[A-Z]{1}\s?[0-9]{1}[A-Z]{1}[0-9]{1}$/)) {
                        return false;
                    }
                }
		    }
		    return true;
		},
	};
	
	var errorMessages = {
			invalidFormat: 'Format de cle de validation invalide',
	};

	formValidator.ValidStep = function() {
	    this.validatorArray = [];
	    this.modelArray = [];
	    this.errorMessage = undefined;
	};
	formValidator.ValidStep.prototype.error = function(message) {
        this.errorMessage = message;
        return this;
    };
	formValidator.ValidStep.prototype.valid = function(validator) {
	    if (typeof validator === 'string') {
            this.validatorArray.push(formValidator.validators[validator]);
        } else {
            this.validatorArray.push(validator);  
        }
        return this;
    };
	formValidator.ValidStep.prototype.model = function(mArray) {
        if (typeof mArray === 'string') {
            this.modelArray.push(mArray);
        } else {
            this.modelArray = mArray;                
        }
        return this;
    };
	
	var validationRules = [];
	
	//see validStep function
    formValidator.addValidation = function(validSteps) {
       validationRules.push({"validSteps" : validSteps});
    }
	
	//form parameter could be a css selector string - #id, .class, etc or a jquery element)
	formValidator.validate = function(){
	    clearMessages();
	    var modelObject = listFormInputs2();
	    var errors = [];
		for (var i = 0; i < validationRules.length; i++) {
		    var validationRule = validationRules[i];
		    var steps = validationRule.validSteps;
		    var result = true;
		    for (var j = 0; j < steps.length && result; j++) {
		        var step = steps[j];
		        for (var k = 0; k < step.validatorArray.length; k++) {
		            var validator = step.validatorArray[k];
		            if (validator.validate) {
		                result = validator.validate(modelObject, step.modelArray);
		            } else {
		                result = validator(modelObject, step.modelArray);
		            }
                    if (result === false ) {
                        if (step.errorMessage ) {
                            errors.push( step.errorMessage );
                        }
                        break;
                    }
		        }
		    }
		}	
		if(errors.length === 0){
			return true;
		}else{
			generateErrorMessages(errors);
			return false;
		}
	};
	function clearMessages(){
		var main = $('#errMessages'), msg;
		main.empty();
		return main;
	}
	function generateErrorMessages(errors){
		var main = clearMessages();
		for(var i = 0; i < errors.length; i++){
			msg = errors[i];
			main.append($('<div class="error">'+ msg+'</div>'));
		}
	}

})();

