/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import org.tukaani.xz.ArrayCache;

public class MyBasicArrayCache
extends ArrayCache {
    private static final int CACHEABLE_SIZE_MIN = 1024;
    private static final int ELEMENTS_PER_STACK = 512;
    private final CacheMap<byte[]> byteArrayCache = new CacheMap();
    private final CacheMap<int[]> intArrayCache = new CacheMap();

    private static <T> T getArray(CacheMap<T> cache, int size) {
        Reference r;
        Object array;
        if (size < 1024) {
            return null;
        }
        Object stack = cache.get(size);
        if (stack == null) {
            return null;
        }
        do {
            if ((r = (Reference)((CyclicStack)stack).pop()) != null) continue;
            return null;
        } while ((array = r.get()) == null);
        return array;
    }

    private static <T> void putArray(CacheMap<T> cache, T array, int size) {
        if (size < 1024) {
            return;
        }
        CyclicStack<Reference<SoftReference<T>>> stack = cache.getOrCreate(size);
        stack.push(new SoftReference<T>(array));
    }

    public byte[] getByteArray(int size, boolean fillWithZeros) {
        byte[] array = MyBasicArrayCache.getArray(this.byteArrayCache, size);
        if (array == null) {
            array = this.allocateNewByteArray(size);
        } else if (fillWithZeros) {
            Arrays.fill(array, (byte)0);
        }
        return array;
    }

    protected byte[] allocateNewByteArray(int size) {
        return new byte[size];
    }

    public void putArray(byte[] array) {
        MyBasicArrayCache.putArray(this.byteArrayCache, array, array.length);
    }

    public int[] getIntArray(int size, boolean fillWithZeros) {
        int[] array = MyBasicArrayCache.getArray(this.intArrayCache, size);
        if (array == null) {
            array = this.allocateNewIntArray(size);
        } else if (fillWithZeros) {
            Arrays.fill(array, 0);
        }
        return array;
    }

    protected int[] allocateNewIntArray(int size) {
        return new int[size];
    }

    public void putArray(int[] array) {
        MyBasicArrayCache.putArray(this.intArrayCache, array, array.length);
    }

    public static void main(String[] args) {
        System.out.println(1024);
    }

    private static class CacheMap<T>
    extends Int2ObjectOpenHashMap<CyclicStack<Reference<T>>> {
        private static final long serialVersionUID = 1L;

        public CacheMap() {
            super(128, 0.25f);
        }

        public CyclicStack<Reference<T>> get(int k) {
            return (CyclicStack)super.get(k);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CyclicStack<Reference<T>> getOrCreate(int k) {
            CyclicStack value = (CyclicStack)super.get(k);
            if (value == null) {
                CyclicStack cyclicStack = value = new CyclicStack();
                synchronized (cyclicStack) {
                    super.put(k, value);
                }
            }
            return value;
        }
    }

    private static class CyclicStack<T> {
        private final T[] elements = new Object[512];
        private int pos = 0;

        public synchronized T pop() {
            T e = this.elements[this.pos];
            this.elements[this.pos] = null;
            this.pos = this.pos - 1 & 0x1FF;
            return e;
        }

        public synchronized void push(T e) {
            this.pos = this.pos + 1 & 0x1FF;
            this.elements[this.pos] = e;
        }
    }
}

