/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.preferences;

import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.medication.XPrescriptionDrugNameFormat;
import ca.infodata.ofys.data.middle.dataobjects.preferences.XDsqUserPreferences;
import ca.infodata.ofys.data.middle.dataobjects.sxapi.XAlertAndNotFound;
import ca.infodata.ofys.data.middle.dataobjects.sxapi.XAlertItem;
import ca.infodata.ofys.data.middle.dataobjects.sxapi.XAllergyItem;
import ca.infodata.ofys.data.middle.dataobjects.sxapi.XDrugItem;
import ca.infodata.ofys.data.middle.dataobjects.sxapi.XIntoleranceItem;
import ca.infodata.ofys.util.MiscUtil;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.List;

public final class XUserPreferences
extends EditableDataObject
implements KryoSerializable {
    private static final long serialVersionUID = 1L;
    public Integer id;
    public Integer sizeDossierView;
    public Integer prescriptionAutoPrint;
    public int[] buttonBackgroundColor;
    public int[] buttonForegroundColor;
    public int[] textboxBackgroundColor;
    public int[] labelForegroundColor;
    public int[] buttonBackgroundColorEnabled;
    public int[] buttonForegroundColorEnabled;
    public Integer printTextSize;
    public Integer printTextTitleSize;
    public Integer textSize;
    public Integer textTitleSize;
    public Integer isAdvancedUser;
    public Boolean isAdvisorActivated;
    public XPrescriptionDrugNameFormat drugNameFormatSummary;
    public XPrescriptionDrugNameFormat drugNameFormatDetail;
    public Boolean showDuplicatedRx;
    public Integer alertLevelToShow;
    public Boolean showAlertAllergies;
    public Boolean showAlertCrossAllergies;
    public Boolean showAlertTherapeuticDuplication;
    public Boolean showAllergiesNotFound;
    public Boolean showDrugsNotFound;
    public Boolean showIntolerancesNotFound;
    public XDsqUserPreferences dsqPreferences;
    public String courrielDossier5;
    public String courrielDossier6;
    public String courrielDossier7;
    public String courrielDossier8;
    public String courrielDossier9;
    public String courrielDossier10;
    public String courrielDossier11;
    public String courrielDossier12;
    public String courrielDossier13;
    public String courrielDossier14;
    public String courrielDossier15;
    public String courrielDossier16;
    public String courrielDossier17;
    public String courrielDossier18;
    public String courrielDossier19;
    public String courrielDossier20;
    public String crdsSearch;

    @Override
    public void write(Kryo k, Output out) {
        out.writeInt(this.id.intValue(), true);
        out.writeByte(MiscUtil.fromIntToByte(this.sizeDossierView));
        out.writeByte(MiscUtil.fromIntToByte(this.prescriptionAutoPrint));
        out.writeInt(MiscUtil.transfertIntegerArrayToInteger(this.buttonBackgroundColor).intValue(), true);
        out.writeInt(MiscUtil.transfertIntegerArrayToInteger(this.buttonForegroundColor).intValue(), true);
        out.writeInt(MiscUtil.transfertIntegerArrayToInteger(this.textboxBackgroundColor).intValue(), true);
        out.writeInt(MiscUtil.transfertIntegerArrayToInteger(this.labelForegroundColor).intValue(), true);
        out.writeInt(MiscUtil.transfertIntegerArrayToInteger(this.buttonBackgroundColorEnabled).intValue(), true);
        out.writeInt(MiscUtil.transfertIntegerArrayToInteger(this.buttonForegroundColorEnabled).intValue(), true);
        out.writeByte(MiscUtil.fromIntToByte(this.printTextSize));
        out.writeByte(MiscUtil.fromIntToByte(this.printTextTitleSize));
        out.writeByte(MiscUtil.fromIntToByte(this.textSize));
        out.writeByte(MiscUtil.fromIntToByte(this.textTitleSize));
        out.writeByte(MiscUtil.fromIntToByte(this.isAdvancedUser));
        out.writeBoolean(Boolean.TRUE.equals(this.isAdvisorActivated));
        out.writeByte(this.drugNameFormatSummary == null ? XPrescriptionDrugNameFormat.GENERIC.getValue() : this.drugNameFormatSummary.getValue());
        out.writeByte(this.drugNameFormatDetail == null ? XPrescriptionDrugNameFormat.GENERIC_AND_COMMERCIAL.getValue() : this.drugNameFormatDetail.getValue());
        out.writeBoolean(Boolean.TRUE.equals(this.showDuplicatedRx));
        out.writeByte(MiscUtil.fromInt(this.alertLevelToShow));
        out.writeBoolean(Boolean.TRUE.equals(this.showAlertAllergies));
        out.writeBoolean(Boolean.TRUE.equals(this.showAlertCrossAllergies));
        out.writeBoolean(Boolean.TRUE.equals(this.showAlertTherapeuticDuplication));
        out.writeBoolean(Boolean.TRUE.equals(this.showAllergiesNotFound));
        out.writeBoolean(Boolean.TRUE.equals(this.showDrugsNotFound));
        out.writeBoolean(Boolean.TRUE.equals(this.showIntolerancesNotFound));
        if (this.courrielDossier5 == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeString(this.courrielDossier5);
        }
        if (this.courrielDossier6 == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeString(this.courrielDossier6);
        }
        if (this.courrielDossier7 == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeString(this.courrielDossier7);
        }
        if (this.courrielDossier8 == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeString(this.courrielDossier8);
        }
        if (this.courrielDossier9 == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeString(this.courrielDossier9);
        }
        if (this.courrielDossier10 == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeString(this.courrielDossier10);
        }
        if (this.courrielDossier11 == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeString(this.courrielDossier11);
        }
        if (this.courrielDossier12 == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeString(this.courrielDossier12);
        }
        if (this.courrielDossier13 == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeString(this.courrielDossier13);
        }
        if (this.courrielDossier14 == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeString(this.courrielDossier14);
        }
        if (this.courrielDossier15 == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeString(this.courrielDossier15);
        }
        if (this.courrielDossier16 == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeString(this.courrielDossier16);
        }
        if (this.courrielDossier17 == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeString(this.courrielDossier17);
        }
        if (this.courrielDossier18 == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeString(this.courrielDossier18);
        }
        if (this.courrielDossier19 == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeString(this.courrielDossier19);
        }
        if (this.courrielDossier20 == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeString(this.courrielDossier20);
        }
        if (this.crdsSearch == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeString(this.crdsSearch);
        }
        k.writeObjectOrNull(out, (Object)this.dsqPreferences, XDsqUserPreferences.class);
        super.write(k, out);
    }

    @Override
    public void read(Kryo k, Input in) {
        this.id = MiscUtil.toInt(in.readInt(true));
        this.sizeDossierView = MiscUtil.toInt(in.readByte());
        this.prescriptionAutoPrint = MiscUtil.toInt(in.readByte());
        this.buttonBackgroundColor = MiscUtil.transfertIntToIntegerArray(in.readInt(true));
        this.buttonForegroundColor = MiscUtil.transfertIntToIntegerArray(in.readInt(true));
        this.textboxBackgroundColor = MiscUtil.transfertIntToIntegerArray(in.readInt(true));
        this.labelForegroundColor = MiscUtil.transfertIntToIntegerArray(in.readInt(true));
        this.buttonBackgroundColorEnabled = MiscUtil.transfertIntToIntegerArray(in.readInt(true));
        this.buttonForegroundColorEnabled = MiscUtil.transfertIntToIntegerArray(in.readInt(true));
        this.printTextSize = MiscUtil.toInt(in.readByte());
        this.printTextTitleSize = MiscUtil.toInt(in.readByte());
        this.textSize = MiscUtil.toInt(in.readByte());
        this.textTitleSize = MiscUtil.toInt(in.readByte());
        this.isAdvancedUser = MiscUtil.toInt(in.readByte());
        this.isAdvisorActivated = in.readBoolean();
        this.drugNameFormatSummary = XPrescriptionDrugNameFormat.from(Integer.valueOf(in.readByte()));
        this.drugNameFormatDetail = XPrescriptionDrugNameFormat.from(Integer.valueOf(in.readByte()));
        this.showDuplicatedRx = in.readBoolean();
        this.alertLevelToShow = MiscUtil.toInt(in.readByte());
        this.showAlertAllergies = in.readBoolean();
        this.showAlertCrossAllergies = in.readBoolean();
        this.showAlertTherapeuticDuplication = in.readBoolean();
        this.showAllergiesNotFound = in.readBoolean();
        this.showDrugsNotFound = in.readBoolean();
        this.showIntolerancesNotFound = in.readBoolean();
        this.courrielDossier5 = in.readByte() == 0 ? null : in.readString();
        this.courrielDossier6 = in.readByte() == 0 ? null : in.readString();
        this.courrielDossier7 = in.readByte() == 0 ? null : in.readString();
        this.courrielDossier8 = in.readByte() == 0 ? null : in.readString();
        this.courrielDossier9 = in.readByte() == 0 ? null : in.readString();
        this.courrielDossier10 = in.readByte() == 0 ? null : in.readString();
        this.courrielDossier11 = in.readByte() == 0 ? null : in.readString();
        this.courrielDossier12 = in.readByte() == 0 ? null : in.readString();
        this.courrielDossier13 = in.readByte() == 0 ? null : in.readString();
        this.courrielDossier14 = in.readByte() == 0 ? null : in.readString();
        this.courrielDossier15 = in.readByte() == 0 ? null : in.readString();
        this.courrielDossier16 = in.readByte() == 0 ? null : in.readString();
        this.courrielDossier17 = in.readByte() == 0 ? null : in.readString();
        this.courrielDossier18 = in.readByte() == 0 ? null : in.readString();
        this.courrielDossier19 = in.readByte() == 0 ? null : in.readString();
        this.courrielDossier20 = in.readByte() == 0 ? null : in.readString();
        this.crdsSearch = in.readByte() == 0 ? null : in.readString();
        this.dsqPreferences = (XDsqUserPreferences)k.readObjectOrNull(in, XDsqUserPreferences.class);
        super.read(k, in);
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
        this.setUpdated();
    }

    public Integer getSizeDossierView() {
        return this.sizeDossierView;
    }

    public void setSizeDossierView(Integer sizeDossierView) {
        this.sizeDossierView = sizeDossierView;
        this.setUpdated();
    }

    public Integer getPrescriptionAutoPrint() {
        return this.prescriptionAutoPrint;
    }

    public void setPrescriptionAutoPrint(Integer prescriptionAutoPrint) {
        this.prescriptionAutoPrint = prescriptionAutoPrint;
        this.setUpdated();
    }

    public int[] getButtonBackgroundColor() {
        return this.buttonBackgroundColor;
    }

    public void setButtonBackgroundColor(int[] buttonBackgroundColor) {
        this.buttonBackgroundColor = buttonBackgroundColor;
        this.setUpdated();
    }

    public int[] getButtonForegroundColor() {
        return this.buttonForegroundColor;
    }

    public void setButtonForegroundColor(int[] buttonForegroundColor) {
        this.buttonForegroundColor = buttonForegroundColor;
        this.setUpdated();
    }

    public int[] getTextboxBackgroundColor() {
        return this.textboxBackgroundColor;
    }

    public void setTextboxBackgroundColor(int[] textboxBackgroundColor) {
        this.textboxBackgroundColor = textboxBackgroundColor;
        this.setUpdated();
    }

    public int[] getLabelForegroundColor() {
        return this.labelForegroundColor;
    }

    public void setLabelForegroundColor(int[] labelForegroundColor) {
        this.labelForegroundColor = labelForegroundColor;
        this.setUpdated();
    }

    public int[] getButtonBackgroundColorEnabled() {
        return this.buttonBackgroundColorEnabled;
    }

    public void setButtonBackgroundColorEnabled(int[] buttonBackgroundColorEnabled) {
        this.buttonBackgroundColorEnabled = buttonBackgroundColorEnabled;
        this.setUpdated();
    }

    public int[] getButtonForegroundColorEnabled() {
        return this.buttonForegroundColorEnabled;
    }

    public void setButtonForegroundColorEnabled(int[] buttonForegroundColorEnabled) {
        this.buttonForegroundColorEnabled = buttonForegroundColorEnabled;
        this.setUpdated();
    }

    public Integer getPrintTextSize() {
        return this.printTextSize;
    }

    public void setPrintTextSize(Integer printTextSize) {
        this.printTextSize = printTextSize;
        this.setUpdated();
    }

    public Integer getPrintTextTitleSize() {
        return this.printTextTitleSize;
    }

    public void setPrintTextTitleSize(Integer printTextTitleSize) {
        this.printTextTitleSize = printTextTitleSize;
        this.setUpdated();
    }

    public Integer getTextSize() {
        return this.textSize;
    }

    public void setTextSize(Integer textSize) {
        this.textSize = textSize;
        this.setUpdated();
    }

    public Integer getTextTitleSize() {
        return this.textTitleSize;
    }

    public void setTextTitleSize(Integer textTitleSize) {
        this.textTitleSize = textTitleSize;
        this.setUpdated();
    }

    public Integer getIsAdvancedUser() {
        return this.isAdvancedUser;
    }

    public void setIsAdvancedUser(Integer isAdvancedUser) {
        this.isAdvancedUser = isAdvancedUser;
        this.setUpdated();
    }

    @Deprecated
    public Boolean getIsAdvisorActivated() {
        return this.isAdvisorActivated;
    }

    @Deprecated
    public void setIsAdvisorActivated(Boolean isAdvisorActivated) {
        this.isAdvisorActivated = isAdvisorActivated;
        this.setUpdated();
    }

    public XPrescriptionDrugNameFormat getDrugNameFormatSummary() {
        return this.drugNameFormatSummary;
    }

    public void setDrugNameFormatSummary(XPrescriptionDrugNameFormat drugNameFormatSummary) {
        this.drugNameFormatSummary = drugNameFormatSummary;
        this.setUpdated();
    }

    public XPrescriptionDrugNameFormat getDrugNameFormatDetail() {
        return this.drugNameFormatDetail;
    }

    public void setDrugNameFormatDetail(XPrescriptionDrugNameFormat drugNameFormatDetail) {
        this.drugNameFormatDetail = drugNameFormatDetail;
        this.setUpdated();
    }

    public Boolean getShowDuplicatedRx() {
        return this.showDuplicatedRx;
    }

    public void setShowDuplicatedRx(Boolean showDuplicatedRx) {
        this.showDuplicatedRx = showDuplicatedRx;
        this.setUpdated();
    }

    public Integer getAlertLevelToShow() {
        return this.alertLevelToShow;
    }

    public void setAlertLevelToShow(Integer alertLevelToShow) {
        this.alertLevelToShow = alertLevelToShow;
        this.setUpdated();
    }

    public Boolean getShowAlertAllergies() {
        return this.showAlertAllergies;
    }

    public void setShowAlertAllergies(Boolean showAlertAllergies) {
        this.showAlertAllergies = showAlertAllergies;
        this.setUpdated();
    }

    public Boolean getShowAlertCrossAllergies() {
        return this.showAlertCrossAllergies;
    }

    public void setShowAlertCrossAllergies(Boolean showAlertCrossAllergies) {
        this.showAlertCrossAllergies = showAlertCrossAllergies;
        this.setUpdated();
    }

    public Boolean getShowAlertTherapeuticDuplication() {
        return this.showAlertTherapeuticDuplication;
    }

    public void setShowAlertTherapeuticDuplication(Boolean showAlertTherapeuticDuplication) {
        this.showAlertTherapeuticDuplication = showAlertTherapeuticDuplication;
        this.setUpdated();
    }

    public Boolean getShowAllergiesNotFound() {
        return this.showAllergiesNotFound;
    }

    public void setShowAllergiesNotFound(Boolean showAllergiesNotFound) {
        this.showAllergiesNotFound = showAllergiesNotFound;
        this.setUpdated();
    }

    public Boolean getShowDrugsNotFound() {
        return this.showDrugsNotFound;
    }

    public void setShowDrugsNotFound(Boolean showDrugsNotFound) {
        this.showDrugsNotFound = showDrugsNotFound;
        this.setUpdated();
    }

    public Boolean getShowIntolerancesNotFound() {
        return this.showIntolerancesNotFound;
    }

    public void setShowIntolerancesNotFound(Boolean showIntolerancesNotFound) {
        this.showIntolerancesNotFound = showIntolerancesNotFound;
        this.setUpdated();
    }

    @Override
    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof XUserPreferences) {
            equals = this.getId() == null ? super.equals(obj) : this.hashCode() == obj.hashCode();
        }
        return equals;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        hashCode = this.getId() == null ? super.hashCode() : ("XUserPreferences" + this.getId().hashCode()).hashCode();
        return hashCode;
    }

    @Override
    public XUserPreferences clone() {
        int i;
        XUserPreferences c = (XUserPreferences)super.clone();
        c.id = this.id;
        c.sizeDossierView = this.sizeDossierView;
        c.prescriptionAutoPrint = this.prescriptionAutoPrint;
        if (this.buttonBackgroundColor != null) {
            c.buttonBackgroundColor = new int[this.buttonBackgroundColor.length];
            for (i = 0; i < this.buttonBackgroundColor.length; ++i) {
                c.buttonBackgroundColor[i] = this.buttonBackgroundColor[i];
            }
        }
        if (this.buttonForegroundColor != null) {
            c.buttonForegroundColor = new int[this.buttonForegroundColor.length];
            for (i = 0; i < this.buttonForegroundColor.length; ++i) {
                c.buttonForegroundColor[i] = this.buttonForegroundColor[i];
            }
        }
        if (this.textboxBackgroundColor != null) {
            c.textboxBackgroundColor = new int[this.textboxBackgroundColor.length];
            for (i = 0; i < this.textboxBackgroundColor.length; ++i) {
                c.textboxBackgroundColor[i] = this.textboxBackgroundColor[i];
            }
        }
        if (this.labelForegroundColor != null) {
            c.labelForegroundColor = new int[this.labelForegroundColor.length];
            for (i = 0; i < this.labelForegroundColor.length; ++i) {
                c.labelForegroundColor[i] = this.labelForegroundColor[i];
            }
        }
        if (this.buttonBackgroundColorEnabled != null) {
            c.buttonBackgroundColorEnabled = new int[this.buttonBackgroundColorEnabled.length];
            for (i = 0; i < this.buttonBackgroundColorEnabled.length; ++i) {
                c.buttonBackgroundColorEnabled[i] = this.buttonBackgroundColorEnabled[i];
            }
        }
        if (this.buttonForegroundColorEnabled != null) {
            c.buttonForegroundColorEnabled = new int[this.buttonForegroundColorEnabled.length];
            for (i = 0; i < this.buttonForegroundColorEnabled.length; ++i) {
                c.buttonForegroundColorEnabled[i] = this.buttonForegroundColorEnabled[i];
            }
        }
        c.printTextSize = this.printTextSize;
        c.printTextTitleSize = this.printTextTitleSize;
        c.textSize = this.textSize;
        c.textTitleSize = this.textTitleSize;
        c.isAdvancedUser = this.isAdvancedUser;
        c.isAdvisorActivated = this.isAdvisorActivated;
        c.drugNameFormatSummary = this.drugNameFormatSummary;
        c.drugNameFormatDetail = this.drugNameFormatDetail;
        c.showDuplicatedRx = this.showDuplicatedRx;
        c.alertLevelToShow = this.alertLevelToShow;
        c.showAlertAllergies = this.showAlertAllergies;
        c.showAlertCrossAllergies = this.showAlertCrossAllergies;
        c.showAlertTherapeuticDuplication = this.showAlertTherapeuticDuplication;
        c.showAllergiesNotFound = this.showAllergiesNotFound;
        c.showDrugsNotFound = this.showDrugsNotFound;
        c.showIntolerancesNotFound = this.showIntolerancesNotFound;
        c.dsqPreferences = this.dsqPreferences == null ? null : this.dsqPreferences.clone();
        return c;
    }

    public boolean hasSomethingToShow(XAlertAndNotFound alert) {
        List<XAlertItem> lstAlert = alert.getAlerts();
        for (XAlertItem element : lstAlert) {
            int level = this.shouldShowAlert(element);
            if (level != 1 && level != 2) continue;
            return true;
        }
        boolean showDrugsNotFound = !Boolean.FALSE.equals(this.getShowDrugsNotFound());
        boolean showAllergiesNotFound = !Boolean.FALSE.equals(this.getShowAllergiesNotFound());
        boolean showIntolerancesNotFound = !Boolean.FALSE.equals(this.getShowIntolerancesNotFound());
        List<XDrugItem> lstDrugs = alert.getDrugs();
        List<XAllergyItem> lstAllergies = alert.getAllergies();
        List<XIntoleranceItem> lstIntolerances = alert.getIntolerances();
        return showDrugsNotFound && !lstDrugs.isEmpty() || showAllergiesNotFound && !lstAllergies.isEmpty() || showIntolerancesNotFound && !lstIntolerances.isEmpty();
    }

    public int shouldShowAlert(XAlertItem alert) {
        if (alert == null) {
            throw new NullPointerException("alert");
        }
        boolean showAlertAllergies = !Boolean.FALSE.equals(this.getShowAlertAllergies());
        boolean showAlertCrossAllergies = !Boolean.FALSE.equals(this.getShowAlertCrossAllergies());
        boolean showAlertTherapeuticDuplication = !Boolean.FALSE.equals(this.getShowAlertTherapeuticDuplication());
        int alertLevelToShow = this.getAlertLevelToShow() == null ? Integer.MAX_VALUE : this.getAlertLevelToShow();
        boolean showAlert = false;
        boolean criticalAlert = false;
        switch ((int)alert.getType()) {
            case 6: {
                showAlert = showAlertAllergies;
                break;
            }
            case 7: {
                showAlert = showAlertCrossAllergies;
                break;
            }
            case 11: 
            case 12: {
                showAlert = showAlertTherapeuticDuplication;
                break;
            }
            case 1: {
                showAlert = alertLevelToShow >= 1;
                criticalAlert = true;
                break;
            }
            case 2: {
                showAlert = alertLevelToShow >= 2;
                break;
            }
            case 3: {
                showAlert = alertLevelToShow >= 3;
                break;
            }
            case 4: {
                showAlert = alertLevelToShow >= 4;
                break;
            }
            case 5: {
                boolean bl = showAlert = alertLevelToShow >= 5;
            }
        }
        if (criticalAlert) {
            return 2;
        }
        if (showAlert) {
            return 1;
        }
        return 0;
    }

    public XDsqUserPreferences getDsqPreferences() {
        return this.dsqPreferences;
    }

    public void setDsqPreferences(XDsqUserPreferences dsqPreferences) {
        this.dsqPreferences = dsqPreferences;
    }

    public final String getCrdsSearch() {
        return this.crdsSearch;
    }

    public final void setCrdsSearch(String crdsSearch) {
        this.crdsSearch = crdsSearch;
    }

    @Override
    public boolean isDirty() {
        if (super.isDirty()) {
            return true;
        }
        return this.dsqPreferences != null && this.dsqPreferences.isDirty();
    }
}

